package ru.yandex.autotests.direct.api.bids.setauto;

import com.yandex.direct.api.v5.bids.BidFieldEnum;
import com.yandex.direct.api.v5.bids.BidGetItem;
import com.yandex.direct.api.v5.bids.CalculateByEnum;
import com.yandex.direct.api.v5.bids.GetResponse;
import com.yandex.direct.api.v5.general.PositionEnum;
import com.yandex.direct.api.v5.general.ScopeEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bids.BidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetAutoItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetAutoRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.is;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(BidsFeatures.SET_AUTO)
@Description("Тесты на проверку округления ставок")
public class SetAutoBidRoundingTest {

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    private static final String LOGIN = BidsLogins.SUPER;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static long keywordId;

    @BeforeClass
    @Step("Подготовка данных для теста")
    @SuppressWarnings("Duplicates")
    public static void readBanner() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(BidsLogins.BIDS_CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaignWithStrategies(
                new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                BidsLogins.BIDS_CLIENT
        );
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, BidsLogins.BIDS_CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, BidsLogins.BIDS_CLIENT);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(BidsLogins.BIDS_CLIENT, adGroupId);
    }

    @Test
    @TestCaseId("3091")
    public void setAutoRoundUpTest() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withKeywordId(keywordId)
                                .withPosition(PositionEnum.P_12)
                                .withCalculateBy(CalculateByEnum.DIFF)
                                .withIncreasePercent(2)
                                .withMaxBid(143845000L)
                                .withScope(ScopeEnum.SEARCH)
                ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.successWithKeywordId()
        );

        GetResponse response = api.clientLogin(BidsLogins.BIDS_CLIENT).userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withFieldNames(BidFieldEnum.BID)
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withKeywordIds(keywordId)));

        assumeThat("Должен вернуться один элемент", response.getBids(), hasSize(1));
        BidGetItem responseItem = response.getBids().get(0);

        assertThat("Ставка должна округлиться вверх", responseItem.getBid(), is(143850000L));
    }

    @Test
    @TestCaseId("3092")
    public void setAutoRoundDownTest() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withKeywordId(keywordId)
                                .withPosition(PositionEnum.P_12)
                                .withCalculateBy(CalculateByEnum.DIFF)
                                .withIncreasePercent(2)
                                .withMaxBid(143844999L)
                                .withScope(ScopeEnum.SEARCH)
                ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.successWithKeywordId()
        );

        GetResponse response = api.clientLogin(BidsLogins.BIDS_CLIENT).userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withFieldNames(BidFieldEnum.BID)
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withKeywordIds(keywordId)));

        assumeThat("Должен вернуться один элемент", response.getBids(), hasSize(1));
        BidGetItem responseItem = response.getBids().get(0);

        assertThat("Ставка должна округлиться вниз", responseItem.getBid(), is(143840000L));
    }
}
