package ru.yandex.autotests.direct.api.bids.setauto;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.bids.CalculateByEnum;
import com.yandex.direct.api.v5.general.PositionEnum;
import com.yandex.direct.api.v5.general.ScopeEnum;
import org.apache.commons.lang.StringUtils;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.bids.BidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetAutoItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetAutoRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by ginger on 22.09.14.
 */
@Aqua.Test
@Features(BidsFeatures.SET_AUTO)
@RunWith(Parameterized.class)
public class SetAutoByRolesWithAccessTest {

    private static final Long MAX_BID = MoneyCurrency.get(Currency.RUB).getLongMaxPrice().longValue();

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private Long adGroupId;

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String loginForAuthorization;

    @Parameterized.Parameter(1)
    public String loginForHeader;

    @Parameterized.Parameter(2)
    public String loginForCreateCampaign;

    @Parameterized.Parameters(name = "loginForAuthorization = {0}, loginForHeader = {1}, loginForCreateCampaign = {2}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {BidsLogins.BIDS_AGENCY,BidsLogins.BIDS_SUBCLIENT,BidsLogins.BIDS_AGENCY},
                {BidsLogins.BIDS_REP_ADMIN_AGENCY,BidsLogins.BIDS_SUBCLIENT,BidsLogins.BIDS_AGENCY},
                {BidsLogins.BIDS_CLIENT,BidsLogins.BIDS_CLIENT,BidsLogins.BIDS_CLIENT},
                {BidsLogins.BIDS_REP_CLIENT,BidsLogins.BIDS_CLIENT,BidsLogins.BIDS_CLIENT}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void reshardUsers() {
        api.userSteps.clientFakeSteps().reshardUserWithLock(BidsLogins.BIDS_SUBCLIENT, ShardNumbers.EXTRA_SHARD);
    }


    @Before
    public void prepareData(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(loginForAuthorization);
        Long campaignId = api.as(loginForCreateCampaign).userSteps.campaignSteps().addDefaultTextCampaign(loginForHeader);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, loginForHeader);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, loginForHeader);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1493")
    public void callBidsSetAuto() {
        //testplan: string № 105
        long keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(loginForHeader, adGroupId);
        api.as(loginForAuthorization).userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withKeywordId(keywordId)
                                .withPosition(PositionEnum.FOOTERFIRST)
                                .withIncreasePercent(50)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(3)
                                .withMaxBid(MAX_BID)
                                .withScope(ScopeEnum.SEARCH)
                ),
                loginForHeader,
                BidExpectedResult.successWithKeywordId());
    }

    @Test
    @TestCaseId("2754")
    public void callBidsSetAutoForAutotargeting() {
        Long autotargetingId = api.userSteps.keywordsSteps().addAutotargeting(loginForHeader, adGroupId);
        api.as(loginForAuthorization).userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withKeywordId(autotargetingId)
                                .withPosition(PositionEnum.FOOTERFIRST)
                                .withIncreasePercent(50)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(3)
                                .withMaxBid(MAX_BID)
                                .withScope(ScopeEnum.SEARCH)
                ),
                loginForHeader,
                BidExpectedResult.errors(
                        new Notification(6001,
                                Api5ErrorDetails.SET_AUTO_DENIED_FOR_AUTOTARGETING,
                                StringUtils.capitalize(BidSetItemMap.KEYWORD_ID),
                                autotargetingId
                        )
                )
        );
    }
}
