package ru.yandex.autotests.direct.api.bids.setauto;

import com.yandex.direct.api.v5.bids.CalculateByEnum;
import com.yandex.direct.api.v5.general.PositionEnum;
import com.yandex.direct.api.v5.general.ScopeEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesAdgroupType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PhrasesRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.bids.BidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetAutoItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetAutoRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(BidsFeatures.SET_AUTO)
public class SetAutoContentPromotionTest {

    private static final String LOGIN = BidsLogins.SUPER;

    private static Long adGroupId;
    private static Long keywordId1;
    private static Long keywordId2;
    private static Long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void beforeClass() {
        api.userSteps.clientFakeSteps().setAPIUnits(BidsLogins.BIDS_CLIENT, 12000000);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(BidsLogins.BIDS_CLIENT);
        api.userSteps.clientFakeSteps().enableAPI(BidsLogins.BIDS_CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaignWithStrategies(
                new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                BidsLogins.BIDS_CLIENT
        );
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, BidsLogins.BIDS_CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, BidsLogins.BIDS_CLIENT);
        keywordId1 = api.userSteps.keywordsSteps().addDefaultKeyword(BidsLogins.BIDS_CLIENT, adGroupId);
        keywordId2 = api.userSteps.keywordsSteps().addDefaultKeyword(BidsLogins.BIDS_CLIENT, adGroupId);

        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(BidsLogins.BIDS_CLIENT);
        CampaignsRecord campaignsRecord = jooqDbSteps.campaignsSteps().getCampaignById(campaignId);
        campaignsRecord.setType(CampaignsType.content_promotion);
        jooqDbSteps.campaignsSteps().updateCampaigns(campaignsRecord);
        PhrasesRecord phrasesRecord = jooqDbSteps.adGroupsSteps().getPhrases(adGroupId);
        phrasesRecord.setAdgroupType(PhrasesAdgroupType.content_promotion);
        jooqDbSteps.adGroupsSteps().updatePhrases(phrasesRecord);
    }

    @Test
    public void setAutoOneValidBidWithAllFieldsInRequest() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withAdGroupId(adGroupId)
                                .withPosition(PositionEnum.FOOTERFIRST)
                                .withIncreasePercent(50)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(3)
                                .withMaxBid(10000000L)
                                .withScope(ScopeEnum.SEARCH,ScopeEnum.NETWORK)
                ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        new Notification(3500, Api5ErrorDetailsJava.TYPE_OF_AD_GROUP_NOT_SUPPORTED)
                )
        );
    }

    @Test
    public void setAutoWithValidCampaignId() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withCampaignId(campaignId)
                                .withPosition(PositionEnum.PREMIUMBLOCK)
                                .withIncreasePercent(30)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(4)
                                .withMaxBid(10000000L)
                                .withScope(ScopeEnum.SEARCH)
                ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        new Notification(3500, Api5ErrorDetailsJava.TYPE_OF_AD_GROUP_NOT_SUPPORTED)
                )
        );
    }

    @Test
    public void setAutoWithValidAdGroupId() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withAdGroupId(adGroupId)
                                .withPosition(PositionEnum.PREMIUMFIRST)
                                .withIncreasePercent(60)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(3)
                                .withMaxBid(10000000L)
                                .withScope(ScopeEnum.SEARCH)
                ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        new Notification(3500, Api5ErrorDetailsJava.TYPE_OF_AD_GROUP_NOT_SUPPORTED)
                )
        );
    }

    @Test
    public void setAutoWithValidKeywordId() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withKeywordId(keywordId1)
                                .withPosition(PositionEnum.FOOTERFIRST)
                                .withIncreasePercent(50)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(3)
                                .withMaxBid(10000000L)
                                .withScope(ScopeEnum.SEARCH)
                ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        new Notification(3500, Api5ErrorDetailsJava.TYPE_OF_AD_GROUP_NOT_SUPPORTED)
                )
        );
    }

    @Test
    public void setAutoBidsWithoutMaxBid() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withBids(
                                new BidSetAutoItemMap()
                                        .withKeywordId(keywordId1)
                                        .withPosition(PositionEnum.FOOTERFIRST)
                                        .withIncreasePercent(50)
                                        .withCalculateBy(CalculateByEnum.VALUE)
                                        .withContextCoverage(3)
                                        .withScope(ScopeEnum.SEARCH)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        new Notification(3500, Api5ErrorDetailsJava.TYPE_OF_AD_GROUP_NOT_SUPPORTED)
                )
        );
    }

    @Test
    public void setAutoWithMinIncreasePercent() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withKeywordId(keywordId1)
                                .withPosition(PositionEnum.FOOTERFIRST)
                                .withIncreasePercent(0)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(3)
                                .withMaxBid(10000000L)
                                .withScope(ScopeEnum.SEARCH)
                ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        new Notification(3500, Api5ErrorDetailsJava.TYPE_OF_AD_GROUP_NOT_SUPPORTED)
                )
        );
    }

    @Test
    public void setAutoWithMaxIncreasePercent() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withKeywordId(keywordId1)
                                .withPosition(PositionEnum.FOOTERFIRST)
                                .withIncreasePercent(1000)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(3)
                                .withMaxBid(10000000L)
                                .withScope(ScopeEnum.SEARCH)
                ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        new Notification(3500, Api5ErrorDetailsJava.TYPE_OF_AD_GROUP_NOT_SUPPORTED)
                )
        );
    }

    @Test
    public void setAutoWithoutIncreasePercent() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withKeywordId(keywordId1)
                                .withPosition(PositionEnum.FOOTERFIRST)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(3)
                                .withMaxBid(10000000L)
                                .withScope(ScopeEnum.SEARCH)
                ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        new Notification(3500, Api5ErrorDetailsJava.TYPE_OF_AD_GROUP_NOT_SUPPORTED)
                )
        );
    }

    @Test
    public void setAutoWithSeveralItems() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withKeywordId(keywordId1)
                                .withPosition(PositionEnum.P_12)
                                .withCalculateBy(CalculateByEnum.DIFF)
                                .withIncreasePercent(2)
                                .withMaxBid(60_000_000L)
                                .withScope(ScopeEnum.SEARCH),
                        new BidSetAutoItemMap()
                                .withKeywordId(keywordId2)
                                .withPosition(PositionEnum.P_12)
                                .withCalculateBy(CalculateByEnum.DIFF)
                                .withIncreasePercent(2)
                                .withMaxBid(150_000_000L)
                                .withScope(ScopeEnum.SEARCH)
                ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        new Notification(3500, Api5ErrorDetailsJava.TYPE_OF_AD_GROUP_NOT_SUPPORTED)
                ),
                BidExpectedResult.errors(
                        new Notification(3500, Api5ErrorDetailsJava.TYPE_OF_AD_GROUP_NOT_SUPPORTED)
                )
        );
    }
}
