package ru.yandex.autotests.direct.api.bids.setauto;

import com.yandex.direct.api.v5.bids.BidFieldEnum;
import com.yandex.direct.api.v5.bids.CalculateByEnum;
import com.yandex.direct.api.v5.bids.ContextCoverage;
import com.yandex.direct.api.v5.bids.ContextCoverageItem;
import com.yandex.direct.api.v5.bids.GetResponse;
import com.yandex.direct.api.v5.general.PositionEnum;
import com.yandex.direct.api.v5.general.ScopeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetAutoItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetAutoRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by semkagtn on 13.10.15.
 * https://st.yandex-team.ru/TESTIRT-7463
 */
@Aqua.Test
@Features(BidsFeatures.SET_AUTO)
@Issue("https://st.yandex-team.ru/DIRECT-47246")
public class SetAutoContextBidForCampaignWithHighestPositionAndMaximumCoverageStrategiesTest {

    private static final String LOGIN = BidsLogins.BIDS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private long adGroupId;
    private Long oldContextBid;
    private Long maxBid;

    @Before
    @Step("Подготовка данных для теста")
    public void prepareData() {
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaignWithStrategies(
                new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                LOGIN
        );
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);

        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(new GetRequestMap()
                .withFieldNames(BidFieldEnum.AD_GROUP_ID, BidFieldEnum.CONTEXT_BID, BidFieldEnum.CONTEXT_COVERAGE)
                .withSelectionCriteria(new BidsSelectionCriteriaMap()
                        .withAdGroupIds(adGroupId)));
        assumeThat("вернулась одная ставка", getResponse.getBids(), hasSize(1));
        oldContextBid = getResponse.getBids().get(0).getContextBid();

        ContextCoverage contextCoverage = getResponse.getBids().get(0).getContextCoverage().getValue();
        maxBid = contextCoverage.getItems().stream()
                .max((x, y) -> x.getProbability().compareTo(y.getProbability()))
                .map(ContextCoverageItem::getPrice)
                .orElse(null);
        assumeThat("в ContextPrice присутствует элемент с Probability = 100%", maxBid, notNullValue());
        maxBid += 50_000_000;
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1495")
    public void setAutoContextBidForCampaignWithHighestPositionAndMaximumCoverageStrategies() {
        api.userSteps.bidsSteps().bidsSetAuto(new SetAutoRequestMap()
                .withBids(new BidSetAutoItemMap()
                        .withAdGroupId(adGroupId)
                        .withMaxBid(maxBid)
                        .withPosition(PositionEnum.PREMIUMBLOCK)
                        .withIncreasePercent(10)
                        .withCalculateBy(CalculateByEnum.VALUE)
                        .withContextCoverage(100)
                        .withScope(ScopeEnum.SEARCH, ScopeEnum.NETWORK)), LOGIN);

        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(new GetRequestMap()
                .withFieldNames(BidFieldEnum.AD_GROUP_ID, BidFieldEnum.CONTEXT_BID)
                .withSelectionCriteria(new BidsSelectionCriteriaMap()
                        .withAdGroupIds(adGroupId)));
        assumeThat("вернулась одная ставка", getResponse.getBids(), hasSize(1));
        Long contextBid = getResponse.getBids().get(0).getContextBid();

        assertThat("ставка на РСЯ соответствует ожидаемой", contextBid, not(equalTo(oldContextBid)));
    }
}
