package ru.yandex.autotests.direct.api.bids.setauto;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.bids.AuctionBidItem;
import com.yandex.direct.api.v5.bids.BidFieldEnum;
import com.yandex.direct.api.v5.bids.BidGetItem;
import com.yandex.direct.api.v5.bids.CalculateByEnum;
import com.yandex.direct.api.v5.bids.GetResponse;
import com.yandex.direct.api.v5.general.PositionEnum;
import com.yandex.direct.api.v5.general.ScopeEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bids.BidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetAutoItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetAutoRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.comparesEqualTo;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by ginger on 17.08.15.
 * https://st.yandex-team.ru/TESTIRT-6544
 */
@Aqua.Test
@Features(BidsFeatures.SET_AUTO)
@RunWith(Parameterized.class)
@Issue("https://st.yandex-team.ru/DIRECT-44179")
public class SetAutoFormulaForComputationBidByAuctionBids {
    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static long keywordID;

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final int INCREASE_PERCENT = 200;

    @Parameterized.Parameter(value = 0)
    public PositionEnum position;

    @Parameterized.Parameter(value = 1)
    public CalculateByEnum calculateBy;

    @Parameterized.Parameter(value = 2)
    public PriceCalculator priceCalculator;

    @Parameterized.Parameters(name = "position = {0}, calculateBy = {1}")
    public static Collection data() {
        final BigDecimal INCREASE_PERCENT_DIVIDE_BY_100 = new BigDecimal(INCREASE_PERCENT).divide(new BigDecimal(100));
        return Arrays.asList(new Object[][]{
                {PositionEnum.P_24, CalculateByEnum.VALUE, new PriceCalculator() {
                    @Override
                    public BigDecimal calculatePrice(BidGetItem bidGetItem) {
                        AuctionBidItem auctionBidFooterBlock = bidGetItem.getAuctionBids().stream()
                                .filter(auctionBid -> auctionBid.getPosition().equals(PositionEnum.P_24.value()))
                                .findAny().orElseThrow(() -> new AssertionError("в AuctionBids нет требуемой позиции"));
                        BigDecimal footerBlock = getBigDecimal(auctionBidFooterBlock.getBid());
                        return footerBlock.add(footerBlock.multiply(INCREASE_PERCENT_DIVIDE_BY_100));
                    }
                }},
                {PositionEnum.P_24, CalculateByEnum.DIFF, new PriceCalculator() {
                    @Override
                    public BigDecimal calculatePrice(BidGetItem bidGetItem) {
                        AuctionBidItem auctionBidFooterBlock = bidGetItem.getAuctionBids().stream()
                                .filter(auctionBid -> auctionBid.getPosition().equals(PositionEnum.P_24.value()))
                                .findAny().orElseThrow(() -> new AssertionError("в AuctionBids нет требуемой позиции"));
                        AuctionBidItem auctionBidFooterFirst = bidGetItem.getAuctionBids().stream()
                                .filter(auctionBid -> auctionBid.getPosition().equals(PositionEnum.P_21.value()))
                                .findAny().orElseThrow(() -> new AssertionError("в AuctionBids нет требуемой позиции"));
                        BigDecimal footerBlock = getBigDecimal(auctionBidFooterBlock.getBid());
                        BigDecimal footerFirst = getBigDecimal(auctionBidFooterFirst.getBid());
                        return footerBlock.add(footerFirst.subtract(footerBlock).multiply(INCREASE_PERCENT_DIVIDE_BY_100));
                    }
                }},
                {PositionEnum.P_21, CalculateByEnum.VALUE, new PriceCalculator() {
                    @Override
                    public BigDecimal calculatePrice(BidGetItem bidGetItem) {
                        AuctionBidItem auctionBidFooterFirst = bidGetItem.getAuctionBids().stream()
                                .filter(auctionBid -> auctionBid.getPosition().equals(PositionEnum.P_21.value()))
                                .findAny().orElseThrow(() -> new AssertionError("в AuctionBids нет требуемой позиции"));
                        BigDecimal footerFirst = getBigDecimal(auctionBidFooterFirst.getBid());
                        return footerFirst.add(footerFirst.multiply(INCREASE_PERCENT_DIVIDE_BY_100));
                    }
                }},
                {PositionEnum.P_21, CalculateByEnum.DIFF, new PriceCalculator() {
                    @Override
                    public BigDecimal calculatePrice(BidGetItem bidGetItem) {
                        AuctionBidItem auctionBidFooterFirst = bidGetItem.getAuctionBids().stream()
                                .filter(auctionBid -> auctionBid.getPosition().equals(PositionEnum.P_21.value()))
                                .findAny().orElseThrow(() -> new AssertionError("в AuctionBids нет требуемой позиции"));
                        BigDecimal footerFirst = getBigDecimal(auctionBidFooterFirst.getBid());
                        AuctionBidItem auctionBidPremiumBlock = bidGetItem.getAuctionBids().stream()
                                .filter(auctionBid -> auctionBid.getPosition().equals(PositionEnum.P_14.value()))
                                .findAny().orElseThrow(() -> new AssertionError("в AuctionBids нет требуемой позиции"));
                        BigDecimal premiumBlock = getBigDecimal(auctionBidPremiumBlock.getBid());
                        BigDecimal diff = premiumBlock.subtract(footerFirst);
                        if (diff.compareTo(BigDecimal.ZERO) < 0) {
                            diff = BigDecimal.ZERO;
                        }
                        return footerFirst.add(diff.multiply(INCREASE_PERCENT_DIVIDE_BY_100));
                    }
                }},
                {PositionEnum.P_22, CalculateByEnum.VALUE, new PriceCalculator() {
                    @Override
                    public BigDecimal calculatePrice(BidGetItem bidGetItem) {
                        AuctionBidItem auctionBidFooterFirst = bidGetItem.getAuctionBids().stream()
                                .filter(auctionBid -> auctionBid.getPosition().equals(PositionEnum.P_21.value()))
                                .findAny().orElseThrow(() -> new AssertionError("в AuctionBids нет требуемой позиции"));
                        BigDecimal footerFirst = getBigDecimal(auctionBidFooterFirst.getBid());
                        return footerFirst.add(footerFirst.multiply(INCREASE_PERCENT_DIVIDE_BY_100));
                    }
                }},
                {PositionEnum.P_22, CalculateByEnum.DIFF, new PriceCalculator() {
                    @Override
                    public BigDecimal calculatePrice(BidGetItem bidGetItem) {
                        AuctionBidItem auctionBidFooterFirst = bidGetItem.getAuctionBids().stream()
                                .filter(auctionBid -> auctionBid.getPosition().equals(PositionEnum.P_21.value()))
                                .findAny().orElseThrow(() -> new AssertionError("в AuctionBids нет требуемой позиции"));
                        BigDecimal footerFirst = getBigDecimal(auctionBidFooterFirst.getBid());
                        AuctionBidItem auctionBidPremiumBlock = bidGetItem.getAuctionBids().stream()
                                .filter(auctionBid -> auctionBid.getPosition().equals(PositionEnum.P_14.value()))
                                .findAny().orElseThrow(() -> new AssertionError("в AuctionBids нет требуемой позиции"));
                        BigDecimal premiumBlock = getBigDecimal(auctionBidPremiumBlock.getBid());
                        BigDecimal diff = premiumBlock.subtract(footerFirst);
                        if (diff.compareTo(BigDecimal.ZERO) < 0) {
                            diff = BigDecimal.ZERO;
                        }
                        return footerFirst.add(diff.multiply(INCREASE_PERCENT_DIVIDE_BY_100));
                    }
                }},
                {PositionEnum.P_23, CalculateByEnum.VALUE, new PriceCalculator() {
                    @Override
                    public BigDecimal calculatePrice(BidGetItem bidGetItem) {
                        AuctionBidItem auctionBidFooterFirst = bidGetItem.getAuctionBids().stream()
                                .filter(auctionBid -> auctionBid.getPosition().equals(PositionEnum.P_21.value()))
                                .findAny().orElseThrow(() -> new AssertionError("в AuctionBids нет требуемой позиции"));
                        BigDecimal footerFirst = getBigDecimal(auctionBidFooterFirst.getBid());
                        return footerFirst.add(footerFirst.multiply(INCREASE_PERCENT_DIVIDE_BY_100));
                    }
                }},
                {PositionEnum.P_23, CalculateByEnum.DIFF, new PriceCalculator() {
                    @Override
                    public BigDecimal calculatePrice(BidGetItem bidGetItem) {
                        AuctionBidItem auctionBidFooterFirst = bidGetItem.getAuctionBids().stream()
                                .filter(auctionBid -> auctionBid.getPosition().equals(PositionEnum.P_21.value()))
                                .findAny().orElseThrow(() -> new AssertionError("в AuctionBids нет требуемой позиции"));
                        BigDecimal footerFirst = getBigDecimal(auctionBidFooterFirst.getBid());
                        AuctionBidItem auctionBidPremiumBlock = bidGetItem.getAuctionBids().stream()
                                .filter(auctionBid -> auctionBid.getPosition().equals(PositionEnum.P_14.value()))
                                .findAny().orElseThrow(() -> new AssertionError("в AuctionBids нет требуемой позиции"));
                        BigDecimal premiumBlock = getBigDecimal(auctionBidPremiumBlock.getBid());
                        BigDecimal diff = premiumBlock.subtract(footerFirst);
                        if (diff.compareTo(BigDecimal.ZERO) < 0) {
                            diff = BigDecimal.ZERO;
                        }
                        return footerFirst.add(diff.multiply(INCREASE_PERCENT_DIVIDE_BY_100));
                    }
             }},
                {PositionEnum.P_14, CalculateByEnum.VALUE, new PriceCalculator() {
                    @Override
                    public BigDecimal calculatePrice(BidGetItem bidGetItem) {
                        AuctionBidItem auctionBidPremiumBlock = bidGetItem.getAuctionBids().stream()
                                .filter(auctionBid -> auctionBid.getPosition().equals(PositionEnum.P_14.value()))
                                .findAny().orElseThrow(() -> new AssertionError("в AuctionBids нет требуемой позиции"));
                        BigDecimal premiumBlock = getBigDecimal(auctionBidPremiumBlock.getBid());
                        return premiumBlock.add(premiumBlock.multiply(INCREASE_PERCENT_DIVIDE_BY_100));
                    }
                }},
                {PositionEnum.P_14, CalculateByEnum.DIFF, new PriceCalculator() {
                    @Override
                    public BigDecimal calculatePrice(BidGetItem bidGetItem) {
                        AuctionBidItem auctionBidPremiumFirst2 = bidGetItem.getAuctionBids().stream()
                                .filter(auctionBid -> auctionBid.getPosition().equals(PositionEnum.P_13.value()))
                                .findAny().orElseThrow(() -> new AssertionError("в AuctionBids нет требуемой позиции"));
                        BigDecimal premiumFirst2 = getBigDecimal(auctionBidPremiumFirst2.getBid());
                        AuctionBidItem auctionBidPremiumBlock = bidGetItem.getAuctionBids().stream()
                                .filter(auctionBid -> auctionBid.getPosition().equals(PositionEnum.P_14.value()))
                                .findAny().orElseThrow(() -> new AssertionError("в AuctionBids нет требуемой позиции"));
                        BigDecimal premiumBlock = getBigDecimal(auctionBidPremiumBlock.getBid());
                        return premiumBlock.add(premiumFirst2.subtract(premiumBlock).multiply(INCREASE_PERCENT_DIVIDE_BY_100));
                    }
                }},
                {PositionEnum.P_13, CalculateByEnum.VALUE, new PriceCalculator() {
                    @Override
                    public BigDecimal calculatePrice(BidGetItem bidGetItem) {
                        AuctionBidItem auctionBidPremiumBlock = bidGetItem.getAuctionBids().stream()
                                .filter(auctionBid -> auctionBid.getPosition().equals(PositionEnum.P_13.value()))
                                .findAny().orElseThrow(() -> new AssertionError("в AuctionBids нет требуемой позиции"));
                        BigDecimal premiumBlock = getBigDecimal(auctionBidPremiumBlock.getBid());
                        return premiumBlock.add(premiumBlock.multiply(INCREASE_PERCENT_DIVIDE_BY_100));
                    }
                }},
                {PositionEnum.P_13, CalculateByEnum.DIFF, new PriceCalculator() {
                    @Override
                    public BigDecimal calculatePrice(BidGetItem bidGetItem) {
                        AuctionBidItem auctionBidPremiumFirst2 = bidGetItem.getAuctionBids().stream()
                                .filter(auctionBid -> auctionBid.getPosition().equals(PositionEnum.P_12.value()))
                                .findAny().orElseThrow(() -> new AssertionError("в AuctionBids нет требуемой позиции"));
                        BigDecimal premiumFirst2 = getBigDecimal(auctionBidPremiumFirst2.getBid());
                        AuctionBidItem auctionBidPremiumBlock = bidGetItem.getAuctionBids().stream()
                                .filter(auctionBid -> auctionBid.getPosition().equals(PositionEnum.P_13.value()))
                                .findAny().orElseThrow(() -> new AssertionError("в AuctionBids нет требуемой позиции"));
                        BigDecimal premiumBlock = getBigDecimal(auctionBidPremiumBlock.getBid());
                        return premiumBlock.add(premiumFirst2.subtract(premiumBlock).multiply(INCREASE_PERCENT_DIVIDE_BY_100));
                    }
                }},
                {PositionEnum.P_12, CalculateByEnum.VALUE, new PriceCalculator() {
                    @Override
                    public BigDecimal calculatePrice(BidGetItem bidGetItem) {
                        AuctionBidItem auctionBidPremiumFirst = bidGetItem.getAuctionBids().stream()
                                .filter(auctionBid -> auctionBid.getPosition().equals(PositionEnum.P_12.value()))
                                .findAny().orElseThrow(() -> new AssertionError("в AuctionBids нет требуемой позиции"));
                        BigDecimal premiumFirst = getBigDecimal(auctionBidPremiumFirst.getBid());
                        return premiumFirst.add(premiumFirst.multiply(INCREASE_PERCENT_DIVIDE_BY_100));
                    }
                }},
                {PositionEnum.P_12, CalculateByEnum.DIFF, new PriceCalculator() {
                    @Override
                    public BigDecimal calculatePrice(BidGetItem bidGetItem) {
                        AuctionBidItem auctionBidPremiumFirst2 = bidGetItem.getAuctionBids().stream()
                                .filter(auctionBid -> auctionBid.getPosition().equals(PositionEnum.P_12.value()))
                                .findAny().orElseThrow(() -> new AssertionError("в AuctionBids нет требуемой позиции"));
                        BigDecimal premiumFirst2 = getBigDecimal(auctionBidPremiumFirst2.getBid());
                        AuctionBidItem auctionBidPremiumFirst = bidGetItem.getAuctionBids().stream()
                                .filter(auctionBid -> auctionBid.getPosition().equals(PositionEnum.P_11.value()))
                                .findAny().orElseThrow(() -> new AssertionError("в AuctionBids нет требуемой позиции"));
                        BigDecimal premiumFirst = getBigDecimal(auctionBidPremiumFirst.getBid());
                        return premiumFirst2.add(premiumFirst.subtract(premiumFirst2).multiply(INCREASE_PERCENT_DIVIDE_BY_100));
                    }
                }},
                {PositionEnum.P_11, CalculateByEnum.VALUE, new PriceCalculator() {
                    @Override
                    public BigDecimal calculatePrice(BidGetItem bidGetItem) {
                        AuctionBidItem auctionBidPremiumFirst = bidGetItem.getAuctionBids().stream()
                                .filter(auctionBid -> auctionBid.getPosition().equals(PositionEnum.P_11.value()))
                                .findAny().orElseThrow(() -> new AssertionError("в AuctionBids нет требуемой позиции"));
                        BigDecimal premiumFirst = getBigDecimal(auctionBidPremiumFirst.getBid());
                        return premiumFirst.add(premiumFirst.multiply(INCREASE_PERCENT_DIVIDE_BY_100));
                    }
                }},
                {PositionEnum.P_11, CalculateByEnum.DIFF, new PriceCalculator() {
                    @Override
                    public BigDecimal calculatePrice(BidGetItem bidGetItem) {
                        AuctionBidItem auctionBidPremiumFirst = bidGetItem.getAuctionBids().stream()
                                .filter(auctionBid -> auctionBid.getPosition().equals(PositionEnum.P_11.value()))
                                .findAny().orElseThrow(() -> new AssertionError("в AuctionBids нет требуемой позиции"));
                        BigDecimal premiumFirst = getBigDecimal(auctionBidPremiumFirst.getBid());
                        return premiumFirst;
                    }
                }}
        });
    }

    @BeforeClass
    @Step("Подготовка данных для теста")
    public static void readBanner() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(BidsLogins.BIDS_CLIENT);
        api.as(BidsLogins.BIDS_CLIENT);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaignWithStrategies(
                new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                BidsLogins.BIDS_CLIENT
        );
        Long adGroupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupID);
        keywordID = api.userSteps.keywordsSteps().addKeyword(BidsLogins.BIDS_CLIENT, adGroupID, "продать всех телепузиков");
        api.protocol(ProtocolType.SOAP);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1496")
    public void checkPriceValueInBidsGet() {
        BigDecimal expectedPrice = getExpectedPrice(priceCalculator);
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withBids(
                                new BidSetAutoItemMap()
                                        .withKeywordId(keywordID)
                                        .withIncreasePercent(INCREASE_PERCENT)
                                        .withCalculateBy(calculateBy)
                                        .withPosition(position)
                                        .withMaxBid(MoneyCurrency.get(Currency.RUB).getLongMaxPrice().longValue())
                                        .withScope(ScopeEnum.SEARCH)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.successWithKeywordId());
        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withKeywordIds(keywordID)
                        )
                        .withFieldNames(BidFieldEnum.BID),
                BidsLogins.BIDS_CLIENT
        );
        BigDecimal actualPrice = getBigDecimal(getResponse.getBids().get(0).getBid());
        assertThat("значение поля Bid соответствует ожидаемому",
                actualPrice,
                comparesEqualTo(expectedPrice));
    }


    private static interface PriceCalculator {
        public BigDecimal calculatePrice(BidGetItem bidGetItem);
    }

    private static BigDecimal getBigDecimal(Long value) {
        return BigDecimal.valueOf(value);
    }

    private static BigDecimal getExpectedPrice(PriceCalculator priceCalculator) {
        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withKeywordIds(keywordID)
                        )
                        .withFieldNames(
                                BidFieldEnum.BID,
                                BidFieldEnum.AUCTION_BIDS
                        ),
                BidsLogins.BIDS_CLIENT
        );
        assumeThat("получили верное кол-во ставок в get", getResponse.getBids().size(), equalTo(1));
        assumeThat("получили AuctionBids", getResponse.getBids().get(0).getAuctionBids(), notNullValue());
        return priceCalculator.calculatePrice(getResponse.getBids().get(0));
    }
}
