package ru.yandex.autotests.direct.api.bids.setauto;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.bids.BidFieldEnum;
import com.yandex.direct.api.v5.bids.GetResponse;
import com.yandex.direct.api.v5.general.ScopeEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bids.BidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetAutoItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetAutoRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.TestSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ch.lambdaj.Lambda.on;
import static ch.lambdaj.Lambda.sort;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 01.10.14.
 */

@Aqua.Test
@Features(BidsFeatures.SET_AUTO)
@Tag(TagDictionary.TRUNK)
public class SetAutoFormulaForComputationContextBidText {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static long keywordId;

    @Rule
    public Trashman trasher = new Trashman(api);

    private static List<Integer> contextCoverages = Arrays.asList(1, 50, 100);
    private static List<Integer> increasePercents = Arrays.asList(0, 500, 1000);

    @BeforeClass
    @Step("Подготовка данных для теста")
    public static void readBanner(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(BidsLogins.BIDS_CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaignWithStrategies(
                new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                BidsLogins.BIDS_CLIENT
        );
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, BidsLogins.BIDS_CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, BidsLogins.BIDS_CLIENT);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(BidsLogins.BIDS_CLIENT, adGroupId);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1499")
    public void computationContextBidChangingContextCoverageTest(){
        List<Long> contextBids = new ArrayList<>();
        for (int contextCoverage : contextCoverages) {
            api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withBids(
                                new BidSetAutoItemMap()
                                        .withKeywordId(keywordId)
                                        .withIncreasePercent(350)
                                        .withContextCoverage(contextCoverage)
                                        .withMaxBid(10000000L)
                                        .withScope(ScopeEnum.NETWORK)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.successWithKeywordId());
            GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                    new GetRequestMap()
                            .withSelectionCriteria(
                                    new BidsSelectionCriteriaMap().withKeywordIds(keywordId)
                            )
                            .withFieldNames(
                                    BidFieldEnum.CONTEXT_BID
                            ),
                    BidsLogins.BIDS_CLIENT
            );
            contextBids.add(getResponse.getBids().get(0).getContextBid());
        }
        List<Long> sortedContextBids = sort(contextBids, on(Long.class));
        assertThat("Функция расчёта ContextBid по параметру ContextCoverage не убывает",
                contextBids, equalTo(sortedContextBids));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1500")
    public void computationContextBidChangingIncreasePercentTest(){
        List<Long> contextBids = new ArrayList<>();
        for (int increasePercent : increasePercents) {
            api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withBids(
                                new BidSetAutoItemMap()
                                        .withKeywordId(keywordId)
                                        .withIncreasePercent(increasePercent)
                                        .withContextCoverage(35)
                                        .withMaxBid(10000000L)
                                        .withScope(ScopeEnum.NETWORK)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.successWithKeywordId());
            GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                    new GetRequestMap()
                            .withSelectionCriteria(
                                    new BidsSelectionCriteriaMap().withKeywordIds(keywordId)
                            )
                            .withFieldNames(
                                    BidFieldEnum.CONTEXT_BID
                            ),
                    BidsLogins.BIDS_CLIENT
            );
            contextBids.add(getResponse.getBids().get(0).getContextBid());
        }
        List<Long> sortedContextBids = sort(contextBids, on(Long.class));
        TestSteps.assertThat("функция расчёта ContextBid по параметру IncreasePercent не убывает",
                contextBids, equalTo(sortedContextBids));
    }

}
