package ru.yandex.autotests.direct.api.bids.setauto;

import com.google.common.base.Joiner;
import com.yandex.direct.api.v5.bids.CalculateByEnum;
import com.yandex.direct.api.v5.general.PositionEnum;
import com.yandex.direct.api.v5.general.ScopeEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.money.MoneyFormat;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.bids.BidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetAutoItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetAutoRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;
import static ru.yandex.autotests.directapi.model.Logins.SUPER_LOGIN;

/**
 * Created by ginger on 14.08.14.
 */
@Aqua.Test
@Features(BidsFeatures.SET_AUTO)
@Tag(TagDictionary.TRUNK)
public class SetAutoNegativeTest {

    private static Long campaignId;
    private static Long adGroupId;
    private static long keywordId1;
    private static long keywordId2;
    private static Long anotherCampaignId;
    private static Long anotherAdGroupId;
    private static long anotherkeywordId;
    private static Long archiveCampaignId;
    private static long deletedkeywordId;
    private static Long deletedCampaignId;
    private static Long archiveAdGroupId;
    private static long archivekeywordId;
    private static Long deletedAdGroupId;

    private static final String CLIENT = BidsLogins.BIDS_CLIENT;
    private static final String ANOTHER_CLIENT = BidsLogins.BIDS_ANOTHER_CLIENT;
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(SUPER_LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);


    @BeforeClass
    @Step("Подготовка данных для теста")
    public static void readBanner() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(BidsLogins.BIDS_CLIENT);
        api.userSteps.clientFakeSteps().enableAPI(BidsLogins.BIDS_CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, CLIENT);
        keywordId1 = api.userSteps.keywordsSteps().addDefaultKeyword(CLIENT, adGroupId);
        keywordId2 = api.userSteps.keywordsSteps().addDefaultKeyword(CLIENT, adGroupId);

        //Чужая кампания
        anotherCampaignId =
                api.as(Logins.SUPER_LOGIN).userSteps.campaignSteps().addDefaultTextCampaign(ANOTHER_CLIENT);
        anotherAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(anotherCampaignId, ANOTHER_CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(anotherAdGroupId, ANOTHER_CLIENT);
        anotherkeywordId = api.userSteps.keywordsSteps().addDefaultKeyword(ANOTHER_CLIENT, anotherAdGroupId);

        //Архивная кампания
        archiveCampaignId =
                api.as(Logins.SUPER_LOGIN).userSteps.campaignSteps().addDefaultTextCampaign(ANOTHER_CLIENT);
        archiveAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(archiveCampaignId, ANOTHER_CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(archiveAdGroupId, ANOTHER_CLIENT);
        archivekeywordId = api.userSteps.keywordsSteps().addDefaultKeyword(ANOTHER_CLIENT, archiveAdGroupId);
        api.userSteps.campaignSteps().campaignsSuspend(ANOTHER_CLIENT, archiveCampaignId);
        api.userSteps.campaignSteps().campaignsArchive(ANOTHER_CLIENT, archiveCampaignId);

        //Удаленная кампания
        deletedCampaignId =
                api.as(Logins.SUPER_LOGIN).userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
        deletedAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(deletedCampaignId, CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(deletedAdGroupId, CLIENT);
        deletedkeywordId = api.userSteps.keywordsSteps().addDefaultKeyword(CLIENT, deletedAdGroupId);
        api.userSteps.campaignSteps().campaignsDelete(CLIENT, deletedCampaignId);
        api.protocol(ProtocolType.SOAP);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1501")
    public void trySetAutoNullParams() {
        //testplan string № 60
        api.userSteps.bidsSteps().shouldGetErrorOnBidsSetAuto(
                new SetAutoRequestMap(),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(SetAutoRequestMap.BIDS))
        );

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1502")
    public void trySetAutoNullBids() {
        //testplan string № 61
        api.userSteps.bidsSteps().shouldGetErrorOnBidsSetAuto(
                new SetAutoRequestMap()
                        .withBids(
                                new BidSetAutoItemMap()
                        ),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.IN_ELEMENT_OF_ARRAY_MISSING_REQUIRED_FIELD,
                        path(SetAutoRequestMap.BIDS),
                        path(BidSetAutoItemMap.SCOPE))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1503")
    public void trySetAutoWithEmptyArray() {
        //testplan string № 62
        api.userSteps.bidsSteps().shouldGetErrorOnBidsSetAuto(
                new SetAutoRequestMap()
                        .withBids(
                                new BidSetAutoItemMap(),
                                new BidSetAutoItemMap(),
                                new BidSetAutoItemMap()
                        ),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.IN_ELEMENT_OF_ARRAY_MISSING_REQUIRED_FIELD,
                        path(SetAutoRequestMap.BIDS),
                        path(BidSetAutoItemMap.SCOPE))
        );
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1504")
    public void trySetAutoOneInvalidBids() {
        //testplan: string №65
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withBids(
                                new BidSetAutoItemMap()
                                        .withKeywordId(-1L)
                                        .withPosition(PositionEnum.FOOTERBLOCK)
                                        .withContextCoverage(10)
                                        .withCalculateBy(CalculateByEnum.DIFF)
                                        .withScope(ScopeEnum.SEARCH)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        (new Notification(5005, Api5ErrorDetailsJava.FIELD_MUST_BE_POSITIVE_INTEGER,
                                path(BidSetAutoItemMap.KEYWORD_ID)))
                ));
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1505")
    public void trySetAutoBidsForArchivedCampaignID() {
        //testplan: string №72
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withBids(
                                new BidSetAutoItemMap()
                                        .withCampaignId(archiveCampaignId)
                                        .withPosition(PositionEnum.FOOTERFIRST)
                                        .withIncreasePercent(50)
                                        .withCalculateBy(CalculateByEnum.VALUE)
                                        .withContextCoverage(3)
                                        .withMaxBid(10000000L)
                                        .withScope(ScopeEnum.SEARCH)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                path(BidSetAutoItemMap.CAMPAIGN_ID),
                                archiveCampaignId))
                ));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1506")
    public void trySetAutoBidsForDeletedCampaignID() {
        //testplan: string №72
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withBids(
                                new BidSetAutoItemMap()
                                        .withCampaignId(deletedCampaignId)
                                        .withPosition(PositionEnum.FOOTERFIRST)
                                        .withIncreasePercent(50)
                                        .withCalculateBy(CalculateByEnum.VALUE)
                                        .withContextCoverage(3)
                                        .withMaxBid(10000000L)
                                        .withScope(ScopeEnum.SEARCH)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                path(BidSetAutoItemMap.CAMPAIGN_ID),
                                deletedCampaignId))
                ));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1507")
    public void trySetAutoBidsForArchivedAdGroupID() {
        //testplan: string №73
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withBids(
                                new BidSetAutoItemMap()
                                        .withAdGroupId(archiveAdGroupId)
                                        .withPosition(PositionEnum.FOOTERFIRST)
                                        .withIncreasePercent(50)
                                        .withCalculateBy(CalculateByEnum.VALUE)
                                        .withContextCoverage(3)
                                        .withMaxBid(10000000L)
                                        .withScope(ScopeEnum.SEARCH)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                path(BidSetAutoItemMap.AD_GROUP_ID),
                                archiveAdGroupId))
                ));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1508")
    public void trySetAutoBidsForDeletedAdGroupID() {
        //testplan: string №73
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withBids(
                                new BidSetAutoItemMap()
                                        .withAdGroupId(deletedAdGroupId)
                                        .withPosition(PositionEnum.FOOTERFIRST)
                                        .withIncreasePercent(50)
                                        .withCalculateBy(CalculateByEnum.VALUE)
                                        .withContextCoverage(3)
                                        .withMaxBid(10000000L)
                                        .withScope(ScopeEnum.SEARCH)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                path(BidSetAutoItemMap.AD_GROUP_ID),
                                deletedAdGroupId))
                ));
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1509")
    public void trySetAutoBidsForArchivedKeywordID() {
        //testplan: string №74
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withBids(
                                new BidSetAutoItemMap()
                                        .withKeywordId(archivekeywordId)
                                        .withPosition(PositionEnum.FOOTERFIRST)
                                        .withIncreasePercent(50)
                                        .withCalculateBy(CalculateByEnum.VALUE)
                                        .withContextCoverage(3)
                                        .withMaxBid(10000000L)
                                        .withScope(ScopeEnum.SEARCH)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                path(BidSetAutoItemMap.KEYWORD_ID),
                                archivekeywordId))
                ));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1510")
    public void trySetAutoBidsForDeletedKeywordID() {
        //testplan: string №74
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withBids(
                                new BidSetAutoItemMap()
                                        .withKeywordId(deletedkeywordId)
                                        .withPosition(PositionEnum.FOOTERFIRST)
                                        .withIncreasePercent(50)
                                        .withCalculateBy(CalculateByEnum.VALUE)
                                        .withContextCoverage(3)
                                        .withMaxBid(10000000L)
                                        .withScope(ScopeEnum.SEARCH)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                path(BidSetAutoItemMap.KEYWORD_ID),
                                deletedkeywordId))
                ));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1511")
    public void trySetAutoBidsWithAdGroupIDAndKeywordID() {
        //testplan: string №76
        api.userSteps.bidsSteps().shouldGetErrorOnBidsSetAuto(
                new SetAutoRequestMap()
                        .withBids(
                                new BidSetAutoItemMap()
                                        .withKeywordId(keywordId1)
                                        .withPosition(PositionEnum.FOOTERFIRST)
                                        .withIncreasePercent(50)
                                        .withCalculateBy(CalculateByEnum.VALUE)
                                        .withContextCoverage(3)
                                        .withMaxBid(10000000L)
                                        .withScope(ScopeEnum.SEARCH),
                                new BidSetAutoItemMap()
                                        .withAdGroupId(adGroupId)
                                        .withPosition(PositionEnum.FOOTERFIRST)
                                        .withIncreasePercent(50)
                                        .withCalculateBy(CalculateByEnum.VALUE)
                                        .withContextCoverage(3)
                                        .withMaxBid(10000000L)
                                        .withScope(ScopeEnum.SEARCH)
                        ),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(4005,
                        Api5ErrorDetails.NULL_STRING));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1512")
    public void trySetAutoBidsWithAdGroupIDAndCampaignID() {
        //testplan: string №76
        api.userSteps.bidsSteps().shouldGetErrorOnBidsSetAuto(
                new SetAutoRequestMap()
                        .withBids(
                                new BidSetAutoItemMap()
                                        .withCampaignId(campaignId)
                                        .withPosition(PositionEnum.FOOTERFIRST)
                                        .withIncreasePercent(50)
                                        .withCalculateBy(CalculateByEnum.VALUE)
                                        .withContextCoverage(3)
                                        .withMaxBid(10000000L)
                                        .withScope(ScopeEnum.SEARCH),
                                new BidSetAutoItemMap()
                                        .withAdGroupId(adGroupId)
                                        .withPosition(PositionEnum.FOOTERFIRST)
                                        .withIncreasePercent(50)
                                        .withCalculateBy(CalculateByEnum.VALUE)
                                        .withContextCoverage(3)
                                        .withMaxBid(10000000L)
                                        .withScope(ScopeEnum.SEARCH)
                        ),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(4005,
                        Api5ErrorDetails.NULL_STRING));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1513")
    public void trySetAutoBidsWithKeywordIDAndCampaignID() {
        //testplan: string №76
        api.userSteps.bidsSteps().shouldGetErrorOnBidsSetAuto(
                new SetAutoRequestMap()
                        .withBids(
                                new BidSetAutoItemMap()
                                        .withKeywordId(keywordId1)
                                        .withPosition(PositionEnum.FOOTERFIRST)
                                        .withIncreasePercent(50)
                                        .withCalculateBy(CalculateByEnum.VALUE)
                                        .withContextCoverage(3)
                                        .withMaxBid(10000000L)
                                        .withScope(ScopeEnum.SEARCH),
                                new BidSetAutoItemMap()
                                        .withCampaignId(campaignId)
                                        .withPosition(PositionEnum.FOOTERFIRST)
                                        .withIncreasePercent(50)
                                        .withCalculateBy(CalculateByEnum.VALUE)
                                        .withContextCoverage(3)
                                        .withMaxBid(10000000L)
                                        .withScope(ScopeEnum.SEARCH)
                        ),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(4005,
                        Api5ErrorDetails.NULL_STRING));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1514")
    public void trySetAutoBidsWithAdGroupIDAndKeywordIDAndCampaignID() {
        //testplan: string №76
        api.userSteps.bidsSteps().shouldGetErrorOnBidsSetAuto(
                new SetAutoRequestMap()
                        .withBids(
                                new BidSetAutoItemMap()
                                        .withKeywordId(keywordId1)
                                        .withPosition(PositionEnum.FOOTERFIRST)
                                        .withIncreasePercent(50)
                                        .withCalculateBy(CalculateByEnum.VALUE)
                                        .withContextCoverage(3)
                                        .withMaxBid(10000000L)
                                        .withScope(ScopeEnum.SEARCH),
                                new BidSetAutoItemMap()
                                        .withAdGroupId(adGroupId)
                                        .withPosition(PositionEnum.FOOTERFIRST)
                                        .withIncreasePercent(50)
                                        .withCalculateBy(CalculateByEnum.VALUE)
                                        .withContextCoverage(3)
                                        .withMaxBid(10000000L)
                                        .withScope(ScopeEnum.SEARCH),
                                new BidSetAutoItemMap()
                                        .withCampaignId(campaignId)
                                        .withPosition(PositionEnum.FOOTERFIRST)
                                        .withIncreasePercent(50)
                                        .withCalculateBy(CalculateByEnum.VALUE)
                                        .withContextCoverage(3)
                                        .withMaxBid(10000000L)
                                        .withScope(ScopeEnum.SEARCH)
                        ),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(4005,
                        Api5ErrorDetails.NULL_STRING));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1515")
    public void trySetAutoBidsWithAdGroupIDAndKeywordIDAndCampaignIDInOneElement() {
        //testplan: string №75
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withBids(
                                new BidSetAutoItemMap()
                                        .withKeywordId(keywordId1)
                                        .withCampaignId(campaignId)
                                        .withAdGroupId(adGroupId)
                                        .withPosition(PositionEnum.FOOTERFIRST)
                                        .withIncreasePercent(50)
                                        .withCalculateBy(CalculateByEnum.VALUE)
                                        .withContextCoverage(3)
                                        .withMaxBid(10000000L)
                                        .withScope(ScopeEnum.SEARCH)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        (new Notification(5009, Api5ErrorDetailsJava.ONLY_ONE_OF_FIELDS_SHOULD_BE_SPECIFIED,
                                Joiner.on(", ").join(
                                        path(BidSetAutoItemMap.KEYWORD_ID),
                                        path(BidSetAutoItemMap.AD_GROUP_ID),
                                        path(BidSetAutoItemMap.CAMPAIGN_ID))))
                ));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1516")
    public void trySetAutoBidsWithInvalidMaxBid() {
        //testplan: string №79
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withBids(
                                new BidSetAutoItemMap()
                                        .withKeywordId(keywordId1)
                                        .withPosition(PositionEnum.FOOTERFIRST)
                                        .withIncreasePercent(50)
                                        .withCalculateBy(CalculateByEnum.VALUE)
                                        .withContextCoverage(3)
                                        .withMaxBid(-1000000L)
                                        .withScope(ScopeEnum.SEARCH)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        (new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_LESS,
                                path(BidSetAutoItemMap.MAX_BID),
                                (MoneyCurrency.get(Currency.RUB).getNamePluralI(api.locale())),
                                MoneyCurrency.get(Currency.RUB).getLongMinPrice().stringValue(MoneyFormat.INTEGER))
                        )));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1517")
    public void trySetAutoBidsWithMaxBidEqual0() {
        //testplan: string №79
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withBids(
                                new BidSetAutoItemMap()
                                        .withKeywordId(keywordId1)
                                        .withPosition(PositionEnum.FOOTERFIRST)
                                        .withIncreasePercent(50)
                                        .withCalculateBy(CalculateByEnum.VALUE)
                                        .withContextCoverage(3)
                                        .withMaxBid(0L)
                                        .withScope(ScopeEnum.SEARCH)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        (new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_LESS,
                                path(BidSetAutoItemMap.MAX_BID),
                                (MoneyCurrency.get(Currency.RUB).getNamePluralI(api.locale())),
                                MoneyCurrency.get(Currency.RUB).getLongMinPrice().stringValue(MoneyFormat.INTEGER)))
                ));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1518")
    public void trySetAutoBidsWithMaxBidMoreThanMax() {
        //testplan: string №79
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withBids(
                                new BidSetAutoItemMap()
                                        .withKeywordId(keywordId1)
                                        .withPosition(PositionEnum.FOOTERFIRST)
                                        .withIncreasePercent(50)
                                        .withCalculateBy(CalculateByEnum.VALUE)
                                        .withContextCoverage(3)
                                        .withMaxBid(25000100000L)
                                        .withScope(ScopeEnum.SEARCH)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        (new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_MORE,
                                path(BidSetAutoItemMap.MAX_BID),
                                (MoneyCurrency.get(Currency.RUB).getNamePluralI(api.locale())),
                                MoneyCurrency.get(Currency.RUB).getLongMaxPrice().stringValue(MoneyFormat.INTEGER)))
                ));
    }


    @Test
    @Issue("https://st.yandex-team.ru/DIRECT-43385")
    @ru.yandex.qatools.allure.annotations.TestCaseId("1519")
    public void trySetAutoWithIncreasePercentLess0() {
        //testplans string №88
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withAdGroupId(adGroupId)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(3)
                                .withMaxBid(10000000L)
                                .withScope(ScopeEnum.SEARCH)
                                .withIncreasePercent(-1)
                                .withPosition(PositionEnum.FOOTERBLOCK)
                ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        (new Notification(5005, Api5ErrorDetailsJava.FIELD_MUST_BE_IN_RANGE_FROM_TO,
                                path(BidSetAutoItemMap.INCREASE_PERCENT), 0, 1000))
                ));
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1520")
    public void trySetAutoWithInvalidIncreasePercent() {
        //testplans string №88
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withAdGroupId(adGroupId)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(3)
                                .withMaxBid(10000000L)
                                .withScope(ScopeEnum.SEARCH)
                                .withIncreasePercent(1001)
                                .withPosition(PositionEnum.FOOTERBLOCK)
                ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        (new Notification(5005, Api5ErrorDetailsJava.FIELD_MUST_BE_IN_RANGE_FROM_TO,
                                path(BidSetAutoItemMap.INCREASE_PERCENT),
                                0, 1000))
                ));
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1521")
    public void trySetAutoWithContextCoverageLess0() {
        //testplans string №97
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withAdGroupId(keywordId1)
                                .withIncreasePercent(50)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(-3)
                                .withMaxBid(10000000L)
                                .withScope(ScopeEnum.SEARCH)
                                .withPosition(PositionEnum.FOOTERBLOCK)
                ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        (new Notification(5005, Api5ErrorDetailsJava.FIELD_MUST_BE_IN_RANGE_FROM_TO,
                                path(BidSetAutoItemMap.CONTEXT_COVERAGE),
                                1,
                                100))
                ));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1522")
    public void trySetAutoWithContextCoverageEqual0() {
        //testplans string №97
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withAdGroupId(adGroupId)
                                .withIncreasePercent(50)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(0)
                                .withMaxBid(10000000L)
                                .withScope(ScopeEnum.SEARCH)
                                .withPosition(PositionEnum.FOOTERBLOCK)
                ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        (new Notification(5005, Api5ErrorDetailsJava.FIELD_MUST_BE_IN_RANGE_FROM_TO,
                                path(BidSetAutoItemMap.CONTEXT_COVERAGE),
                                1,
                                100))
                ));
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1523")
    public void trySetAutoWithInvalidContextCoverage() {
        //testplans string №97
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withAdGroupId(adGroupId)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(101)
                                .withMaxBid(10000000L)
                                .withScope(ScopeEnum.SEARCH)
                                .withIncreasePercent(1000)
                                .withPosition(PositionEnum.FOOTERBLOCK)
                ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        (new Notification(5005, Api5ErrorDetailsJava.FIELD_MUST_BE_IN_RANGE_FROM_TO,
                                path(BidSetAutoItemMap.CONTEXT_COVERAGE),
                                1,
                                100))
                ));
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1524")
    public void trySetAutoInvalidAndValidBids() {
        //testplan: string №66
        //DIRECT-35841
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withBids(
                                new BidSetAutoItemMap()
                                        .withKeywordId(-1L)
                                        .withPosition(PositionEnum.FOOTERBLOCK)
                                        .withContextCoverage(10)
                                        .withCalculateBy(CalculateByEnum.DIFF)
                                        .withScope(ScopeEnum.SEARCH),
                                new BidSetAutoItemMap()
                                        .withKeywordId(keywordId2)
                                        .withPosition(PositionEnum.FOOTERFIRST)
                                        .withIncreasePercent(50)
                                        .withCalculateBy(CalculateByEnum.VALUE)
                                        .withContextCoverage(3)
                                        .withMaxBid(10000000L)
                                        .withScope(ScopeEnum.SEARCH)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        (new Notification(5005, Api5ErrorDetailsJava.FIELD_MUST_BE_POSITIVE_INTEGER,
                                path(BidSetAutoItemMap.KEYWORD_ID)))
                ),
                BidExpectedResult.successWithKeywordId());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1525")
    public void trySetAutoOneValidAndOneWithoutRequiredFieldsBidsTest() {
        api.userSteps.bidsSteps().shouldGetErrorOnBidsSetAuto(
                new SetAutoRequestMap()
                        .withBids(
                                new BidSetAutoItemMap()
                                        .withKeywordId(keywordId2)
                                        .withPosition(PositionEnum.FOOTERFIRST)
                                        .withIncreasePercent(50)
                                        .withCalculateBy(CalculateByEnum.VALUE)
                                        .withContextCoverage(3)
                                        .withMaxBid(10000000L)
                                        .withScope(ScopeEnum.SEARCH),
                                new BidSetAutoItemMap()
                                        .withScope(ScopeEnum.SEARCH)
                                        .withPosition(PositionEnum.FOOTERBLOCK)
                                        .withContextCoverage(10)
                                        .withCalculateBy(CalculateByEnum.DIFF)
                        ),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(4005, Api5ErrorDetails.NULL_STRING));
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1526")
    public void trySetAutoBidsForAnotherClientAdGroupID() {
        //testplan: string №73
        //https://st.yandex-team.ru/DIRECT-35621
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withBids(
                                new BidSetAutoItemMap()
                                        .withAdGroupId(anotherAdGroupId)
                                        .withPosition(PositionEnum.FOOTERFIRST)
                                        .withIncreasePercent(50)
                                        .withCalculateBy(CalculateByEnum.VALUE)
                                        .withContextCoverage(3)
                                        .withMaxBid(10000000L)
                                        .withScope(ScopeEnum.SEARCH)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                path(BidSetAutoItemMap.AD_GROUP_ID),
                                anotherAdGroupId))
                ));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1527")
    public void trySetAutoBidsForAnotherClientKeywordID() {
        //testplan: string №74
        // https://st.yandex-team.ru/DIRECT-35621
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withBids(
                                new BidSetAutoItemMap()
                                        .withKeywordId(anotherkeywordId)
                                        .withPosition(PositionEnum.FOOTERFIRST)
                                        .withIncreasePercent(50)
                                        .withCalculateBy(CalculateByEnum.VALUE)
                                        .withContextCoverage(3)
                                        .withMaxBid(10000000L)
                                        .withScope(ScopeEnum.SEARCH)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                path(BidSetAutoItemMap.KEYWORD_ID),
                                anotherkeywordId))
                ));
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1528")
    public void trySetAutoBidsForAnotherClientCampaignID() {
        //testplan: string №72
        // https://st.yandex-team.ru/DIRECT-35621
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withBids(
                                new BidSetAutoItemMap()
                                        .withCampaignId(anotherCampaignId)
                                        .withPosition(PositionEnum.FOOTERFIRST)
                                        .withIncreasePercent(50)
                                        .withCalculateBy(CalculateByEnum.VALUE)
                                        .withContextCoverage(3)
                                        .withMaxBid(10000000L)
                                        .withScope(ScopeEnum.SEARCH)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                path(BidSetAutoItemMap.CAMPAIGN_ID),
                                anotherCampaignId))
                ));
    }

    @Test
    @TestCaseId("3029")
    public void setAutoWithDuplicateAdGroupId() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withAdGroupId(adGroupId)
                                .withPosition(PositionEnum.P_12)
                                .withCalculateBy(CalculateByEnum.DIFF)
                                .withIncreasePercent(2)
                                .withMaxBid(60_000_000L)
                                .withScope(ScopeEnum.SEARCH),
                        new BidSetAutoItemMap()
                                .withAdGroupId(adGroupId)
                                .withPosition(PositionEnum.P_12)
                                .withCalculateBy(CalculateByEnum.DIFF)
                                .withIncreasePercent(2)
                                .withMaxBid(150_000_000L)
                                .withScope(ScopeEnum.SEARCH)
                ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(new Notification(9800, Api5ErrorDetailsJava.DUPLICATED_OBJECT)),
                BidExpectedResult.errors(new Notification(9800, Api5ErrorDetailsJava.DUPLICATED_OBJECT))
        );
    }

    @Test
    @TestCaseId("3030")
    public void setAutoWithDuplicateKeywordId() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withKeywordId(keywordId1)
                                .withPosition(PositionEnum.P_12)
                                .withCalculateBy(CalculateByEnum.DIFF)
                                .withIncreasePercent(2)
                                .withMaxBid(60_000_000L)
                                .withScope(ScopeEnum.SEARCH),
                        new BidSetAutoItemMap()
                                .withKeywordId(keywordId1)
                                .withPosition(PositionEnum.P_12)
                                .withCalculateBy(CalculateByEnum.DIFF)
                                .withIncreasePercent(2)
                                .withMaxBid(150_000_000L)
                                .withScope(ScopeEnum.SEARCH)
                ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(new Notification(9800, Api5ErrorDetailsJava.DUPLICATED_OBJECT)),
                BidExpectedResult.errors(new Notification(9800, Api5ErrorDetailsJava.DUPLICATED_OBJECT))
        );
    }

    @Test
    @TestCaseId("3031")
    public void setAutoWithDuplicateCampaignId() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withCampaignId(campaignId)
                                .withPosition(PositionEnum.P_12)
                                .withCalculateBy(CalculateByEnum.DIFF)
                                .withIncreasePercent(2)
                                .withMaxBid(60_000_000L)
                                .withScope(ScopeEnum.SEARCH),
                        new BidSetAutoItemMap()
                                .withCampaignId(campaignId)
                                .withPosition(PositionEnum.P_12)
                                .withCalculateBy(CalculateByEnum.DIFF)
                                .withIncreasePercent(2)
                                .withMaxBid(150_000_000L)
                                .withScope(ScopeEnum.SEARCH)
                ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(new Notification(9800, Api5ErrorDetailsJava.DUPLICATED_OBJECT)),
                BidExpectedResult.errors(new Notification(9800, Api5ErrorDetailsJava.DUPLICATED_OBJECT))
        );
    }

    @Test
    @TestCaseId("3032")
    public void setAutoWithDuplicateKeywordIdAndOneNonDuplicate() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withKeywordId(keywordId1)
                                .withPosition(PositionEnum.P_12)
                                .withCalculateBy(CalculateByEnum.DIFF)
                                .withIncreasePercent(2)
                                .withMaxBid(60_000_000L)
                                .withScope(ScopeEnum.SEARCH),
                        new BidSetAutoItemMap()
                                .withKeywordId(keywordId1)
                                .withPosition(PositionEnum.P_12)
                                .withCalculateBy(CalculateByEnum.DIFF)
                                .withIncreasePercent(2)
                                .withMaxBid(150_000_000L)
                                .withScope(ScopeEnum.SEARCH),
                        new BidSetAutoItemMap()
                                .withKeywordId(keywordId2)
                                .withPosition(PositionEnum.P_12)
                                .withCalculateBy(CalculateByEnum.DIFF)
                                .withIncreasePercent(2)
                                .withMaxBid(150_000_000L)
                                .withScope(ScopeEnum.SEARCH)
                ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(new Notification(9800, Api5ErrorDetailsJava.DUPLICATED_OBJECT)),
                BidExpectedResult.errors(new Notification(9800, Api5ErrorDetailsJava.DUPLICATED_OBJECT)),
                BidExpectedResult.successWithKeywordId()
        );
    }

    @Test
    @TestCaseId("3033")
    public void setAutoRequestsWithDuplicatesNoServerErrorOccurs() {

        // Тест представляет собой серию запросов, описанную в https://st.yandex-team.ru/DIRECT-80303
        // Проверяется, что больше нет падений с ошибкой 1000.

        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withAdGroupId(adGroupId)
                                .withPosition(PositionEnum.P_12)
                                .withCalculateBy(CalculateByEnum.DIFF)
                                .withIncreasePercent(2)
                                .withMaxBid(60_000_000L)
                                .withScope(ScopeEnum.SEARCH),
                        new BidSetAutoItemMap()
                                .withAdGroupId(adGroupId)
                                .withPosition(PositionEnum.P_12)
                                .withCalculateBy(CalculateByEnum.DIFF)
                                .withIncreasePercent(2)
                                .withMaxBid(150_000_000L)
                                .withScope(ScopeEnum.SEARCH)
                ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(new Notification(9800, Api5ErrorDetailsJava.DUPLICATED_OBJECT)),
                BidExpectedResult.errors(new Notification(9800, Api5ErrorDetailsJava.DUPLICATED_OBJECT))
        );

        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withAdGroupId(adGroupId)
                                .withPosition(PositionEnum.P_14)
                                .withCalculateBy(CalculateByEnum.DIFF)
                                .withIncreasePercent(2)
                                .withMaxBid(150_000_000L)
                                .withScope(ScopeEnum.SEARCH),
                        new BidSetAutoItemMap()
                                .withAdGroupId(adGroupId)
                                .withPosition(PositionEnum.P_14)
                                .withCalculateBy(CalculateByEnum.DIFF)
                                .withIncreasePercent(2)
                                .withMaxBid(60_000_000L)
                                .withScope(ScopeEnum.SEARCH)
                ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(new Notification(9800, Api5ErrorDetailsJava.DUPLICATED_OBJECT)),
                BidExpectedResult.errors(new Notification(9800, Api5ErrorDetailsJava.DUPLICATED_OBJECT))
        );
    }
}
