package ru.yandex.autotests.direct.api.bids.setauto;

import com.yandex.direct.api.v5.bids.CalculateByEnum;
import com.yandex.direct.api.v5.general.PositionEnum;
import com.yandex.direct.api.v5.general.ScopeEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bids.BidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetAutoItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetAutoRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by ginger on 14.08.14.
 */
@Aqua.Test
@Features(BidsFeatures.SET_AUTO)
@Tag(TagDictionary.TRUNK)
public class SetAutoPositiveTest {

    private static Long adGroupId;
    private static long keywordId1;
    private static long keywordId2;
    private static Long campaignId;
    protected LogSteps log = LogSteps.getLogger(this.getClass());
    private static String login = BidsLogins.SUPER;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    @Step("Подготовка данных для теста")
    public static void readBanner(){
        api.userSteps.clientFakeSteps().setAPIUnits(BidsLogins.BIDS_CLIENT, 12000000);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(BidsLogins.BIDS_CLIENT);
        api.userSteps.clientFakeSteps().enableAPI(BidsLogins.BIDS_CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaignWithStrategies(
                new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                BidsLogins.BIDS_CLIENT
        );
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, BidsLogins.BIDS_CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, BidsLogins.BIDS_CLIENT);
        keywordId1 = api.userSteps.keywordsSteps().addDefaultKeyword(BidsLogins.BIDS_CLIENT, adGroupId);
        keywordId2 = api.userSteps.keywordsSteps().addDefaultKeyword(BidsLogins.BIDS_CLIENT, adGroupId);
    }

    @Test
        @ru.yandex.qatools.allure.annotations.TestCaseId("1529")
        public void setAutoOneValidBidWithAllFieldsInRequest(){
            //testplans string №64, 87, 100
            //https://st.yandex-team.ru/DIRECT-33878
            //https://st.yandex-team.ru/DIRECT-34287
            api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                    new SetAutoRequestMap().withBids(
                            new BidSetAutoItemMap()
                                    .withAdGroupId(adGroupId)
                                    .withPosition(PositionEnum.FOOTERFIRST)
                                    .withIncreasePercent(50)
                                    .withCalculateBy(CalculateByEnum.VALUE)
                                    .withContextCoverage(3)
                                    .withMaxBid(10000000L)
                                    .withScope(ScopeEnum.SEARCH,ScopeEnum.NETWORK)
                    ),
                    BidsLogins.BIDS_CLIENT,
                    BidExpectedResult.successWithAdGroupId()
            );
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1530")
    public void setAutoWithValidCampaignId(){
        //testplans string №69
        //https://st.yandex-team.ru/DIRECT-33878
        //https://st.yandex-team.ru/DIRECT-34287
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withCampaignId(campaignId)
                                .withPosition(PositionEnum.PREMIUMBLOCK)
                                .withIncreasePercent(30)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(4)
                                .withMaxBid(10000000L)
                                .withScope(ScopeEnum.SEARCH)
                ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.successWithCampaignId()
        );
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1531")
    public void setAutoWithValidAdGroupId(){
        //testplans string №70
        //https://st.yandex-team.ru/DIRECT-34287
        //https://st.yandex-team.ru/DIRECT-33878
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withAdGroupId(adGroupId)
                                .withPosition(PositionEnum.PREMIUMFIRST)
                                .withIncreasePercent(60)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(3)
                                .withMaxBid(10000000L)
                                .withScope(ScopeEnum.SEARCH)
                ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.successWithAdGroupId()
        );
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1532")
    public void setAutoWithValidKeywordId(){
        //testplans string №71
        // https://st.yandex-team.ru/DIRECT-33878
        //https://st.yandex-team.ru/DIRECT-34287
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withKeywordId(keywordId1)
                                .withPosition(PositionEnum.FOOTERFIRST)
                                .withIncreasePercent(50)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(3)
                                .withMaxBid(10000000L)
                                .withScope(ScopeEnum.SEARCH)
                ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.successWithKeywordId()
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1533")
    public void setAutoBidsWithoutMaxBid(){
        //testplan: string №77
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withBids(
                                new BidSetAutoItemMap()
                                        .withKeywordId(keywordId1)
                                        .withPosition(PositionEnum.FOOTERFIRST)
                                        .withIncreasePercent(50)
                                        .withCalculateBy(CalculateByEnum.VALUE)
                                        .withContextCoverage(3)
                                        .withScope(ScopeEnum.SEARCH)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.successWithKeywordId());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1534")
    public void setAutoWithMinIncreasePercent(){
        //testplans string №89
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withKeywordId(keywordId1)
                                .withPosition(PositionEnum.FOOTERFIRST)
                                .withIncreasePercent(0)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(3)
                                .withMaxBid(10000000L)
                                .withScope(ScopeEnum.SEARCH)
                ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.successWithKeywordId()
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1535")
    public void setAutoWithMaxIncreasePercent(){
        //testplans string №89
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withKeywordId(keywordId1)
                                .withPosition(PositionEnum.FOOTERFIRST)
                                .withIncreasePercent(1000)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(3)
                                .withMaxBid(10000000L)
                                .withScope(ScopeEnum.SEARCH)
                ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.successWithKeywordId()
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1536")
    public void setAutoWithoutIncreasePercent(){
        //testplans string №86
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withKeywordId(keywordId1)
                                .withPosition(PositionEnum.FOOTERFIRST)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(3)
                                .withMaxBid(10000000L)
                                .withScope(ScopeEnum.SEARCH)
                ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.successWithKeywordId()
        );
    }

    @Test
    @TestCaseId("3034")
    public void setAutoWithSeveralItems() {
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withKeywordId(keywordId1)
                                .withPosition(PositionEnum.P_12)
                                .withCalculateBy(CalculateByEnum.DIFF)
                                .withIncreasePercent(2)
                                .withMaxBid(60_000_000L)
                                .withScope(ScopeEnum.SEARCH),
                        new BidSetAutoItemMap()
                                .withKeywordId(keywordId2)
                                .withPosition(PositionEnum.P_12)
                                .withCalculateBy(CalculateByEnum.DIFF)
                                .withIncreasePercent(2)
                                .withMaxBid(150_000_000L)
                                .withScope(ScopeEnum.SEARCH)
                ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.successWithKeywordId(), BidExpectedResult.successWithKeywordId()
        );
    }
}
