package ru.yandex.autotests.direct.api.bids.setauto;

import com.yandex.direct.api.v5.bids.BidFieldEnum;
import com.yandex.direct.api.v5.bids.CalculateByEnum;
import com.yandex.direct.api.v5.bids.GetResponse;
import com.yandex.direct.api.v5.general.PositionEnum;
import com.yandex.direct.api.v5.general.ScopeEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetAutoItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetAutoRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.junit.Assert.assertThat;

/**
 * Created by ginger on 04.08.14.
 */
@Aqua.Test
@Features(BidsFeatures.SMOKE)
public class SetAutoSmokeTest {

    public static final String login = BidsLogins.BIDS_CLIENT;
    private static Long campaignId;
    private Long adGroupId;
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);


    @BeforeClass
    @Step("Создание кампании")
    public static void prepareCampaign() {
        api.userSteps.clientFakeSteps().enableAPI(login);
        campaignId = api.userSteps.campaignSteps()
                .addDefaultTextCampaignWithStrategies(
                        new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                        new TextCampaignNetworkStrategyAddMap().defaultServingOff()
                );
    }

    @Before
    @Step("Создание группы")
    public void prepareAdGroup() {
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, login);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, login);
        api.userSteps.keywordsSteps().addDefaultKeywords(login, adGroupId, 2);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1543")
    public void setAutoValidBids() {
        //DIRECT-34287
        SetAutoRequestMap params = new SetAutoRequestMap();
        params.withBids(
                new BidSetAutoItemMap()
                        .withAdGroupId(adGroupId)
                        .withPosition(PositionEnum.FOOTERFIRST)
                        .withIncreasePercent(50)
                        .withCalculateBy(CalculateByEnum.VALUE)
                        .withContextCoverage(3)
                        .withMaxBid(10000000L)
                        .withScope(ScopeEnum.SEARCH)
        );
        api.userSteps.bidsSteps().bidsSetAuto(params, login);
    }


    @Test
    @TestCaseId("2788")
    public void setAutoValidBidsNotEligibleGroup(){
        api.as(login);
        int shard = api.userSteps.clientFakeSteps().getUserShard(login);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps().setBsRarelyLoaded(adGroupId, true);
        final GetResponse getResponseBefore = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap().withSelectionCriteria(new BidsSelectionCriteriaMap().withAdGroupIds(adGroupId))
                        .withFieldNames(BidFieldEnum.BID, BidFieldEnum.CONTEXT_BID, BidFieldEnum.STRATEGY_PRIORITY, BidFieldEnum.SERVING_STATUS));
        SetAutoRequestMap params = new SetAutoRequestMap();
        params.withBids(
                new BidSetAutoItemMap()
                        .withAdGroupId(adGroupId)
                        .withPosition(PositionEnum.FOOTERFIRST)
                        .withIncreasePercent(50)
                        .withCalculateBy(CalculateByEnum.VALUE)
                        .withContextCoverage(3)
                        .withMaxBid(10000000L)
                        .withScope(ScopeEnum.SEARCH)
        );
        api.userSteps.bidsSteps().bidsSetAuto(params, login);
        final GetResponse getResponseAfter = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap().withSelectionCriteria(new BidsSelectionCriteriaMap().withAdGroupIds(adGroupId))
                        .withFieldNames(BidFieldEnum.BID, BidFieldEnum.CONTEXT_BID, BidFieldEnum.STRATEGY_PRIORITY, BidFieldEnum.SERVING_STATUS));
        assertThat("Ставка через setAuto, для группы в статусе \"мало показов\" не поменялась", getResponseBefore.getBids().get(0).getBid(), equalTo(getResponseAfter.getBids().get(0).getBid()));
    }

}
