package ru.yandex.autotests.direct.api.bids.setauto;

import com.yandex.direct.api.v5.bids.CalculateByEnum;
import com.yandex.direct.api.v5.general.PositionEnum;
import com.yandex.direct.api.v5.general.ScopeEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.bids.BidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetAutoItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetAutoRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by ginger on 16.10.14.
 */
@Aqua.Test
@Features(BidsFeatures.SET_AUTO)
@Tag(TagDictionary.TRUNK)
public class SetAutoValidFieldsValueTest {

    private static Long campaignId;
    private static Long adGroupId;
    private static long keywordId;
    protected LogSteps log = LogSteps.getLogger(this.getClass());
    private static String login = BidsLogins.SUPER;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    @Step("Подготовка данных для теста")
    public static void readBanner(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(BidsLogins.BIDS_CLIENT);
        api.userSteps.clientFakeSteps().enableAPI(BidsLogins.BIDS_CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaignWithStrategies(
                new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                BidsLogins.BIDS_CLIENT
        );
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, BidsLogins.BIDS_CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, BidsLogins.BIDS_CLIENT);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(BidsLogins.BIDS_CLIENT, adGroupId);

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1544")
    public void setAutoWithPositionEqualFooterfirstTest(){
        //testplans string №83
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withAdGroupId(adGroupId)
                                .withPosition(PositionEnum.FOOTERFIRST)
                                .withIncreasePercent(50)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(3)
                                .withMaxBid(10000000L)
                                .withScope(ScopeEnum.SEARCH,ScopeEnum.NETWORK)
                ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.successWithAdGroupId()
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1545")
    public void setAutoWithPositionEqualFooterblockTest(){
        //testplans string №83
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withAdGroupId(adGroupId)
                                .withPosition(PositionEnum.FOOTERBLOCK)
                                .withIncreasePercent(50)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(3)
                                .withMaxBid(10000000L)
                                .withScope(ScopeEnum.SEARCH,ScopeEnum.NETWORK)
                ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.successWithAdGroupId()
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1546")
    public void setAutoWithPositionEqualPremiumfirstTest(){
        //testplans string №83
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withAdGroupId(adGroupId)
                                .withPosition(PositionEnum.PREMIUMFIRST)
                                .withIncreasePercent(50)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(3)
                                .withMaxBid(10000000L)
                                .withScope(ScopeEnum.SEARCH,ScopeEnum.NETWORK)
                ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.successWithAdGroupId()
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1547")
    public void setAutoWithPositionEqualPremiumblockTest(){
        //testplans string №83
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withAdGroupId(adGroupId)
                                .withPosition(PositionEnum.PREMIUMBLOCK)
                                .withIncreasePercent(50)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(3)
                                .withMaxBid(10000000L)
                                .withScope(ScopeEnum.SEARCH,ScopeEnum.NETWORK)
                ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.successWithAdGroupId()
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1548")
    public void setAutoWithValidIncreasePercentTest(){
        //testplans string №87
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withCampaignId(campaignId)
                                .withPosition(PositionEnum.PREMIUMFIRST)
                                .withIncreasePercent(999)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(2)
                                .withMaxBid(10000000L)
                                .withScope(ScopeEnum.SEARCH,ScopeEnum.NETWORK)
                ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.successWithCampaignId()
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1549")
    public void setAutoWithCalculateByEqualValueTest(){
        //testplans string №92
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withCampaignId(campaignId)
                                .withPosition(PositionEnum.PREMIUMFIRST)
                                .withIncreasePercent(666)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(3)
                                .withMaxBid(10000000L)
                                .withScope(ScopeEnum.SEARCH,ScopeEnum.NETWORK)
                ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.successWithCampaignId()
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1550")
    public void setAutoWithCalculateByEqualDiffTest(){
        //testplans string №92
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withCampaignId(campaignId)
                                .withPosition(PositionEnum.PREMIUMFIRST)
                                .withIncreasePercent(666)
                                .withCalculateBy(CalculateByEnum.DIFF)
                                .withContextCoverage(3)
                                .withMaxBid(10000000L)
                                .withScope(ScopeEnum.SEARCH,ScopeEnum.NETWORK)
                ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.successWithCampaignId()
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1551")
    public void setAutoWithValidContextCoverageTest(){
        //testplans string №96
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withCampaignId(campaignId)
                                .withPosition(PositionEnum.PREMIUMFIRST)
                                .withIncreasePercent(2)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(99)
                                .withMaxBid(10000000L)
                                .withScope(ScopeEnum.SEARCH,ScopeEnum.NETWORK)
                ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.successWithCampaignId()
        );
    }

}
