package ru.yandex.autotests.direct.api.bids.setauto;

import com.yandex.direct.api.v5.bids.CalculateByEnum;
import com.yandex.direct.api.v5.general.PositionEnum;
import com.yandex.direct.api.v5.general.ScopeEnum;
import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetAutoItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetAutoRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang.StringUtils.capitalize;

/**
 * Created by ginger on 10.12.14.
 */
@Aqua.Test
@Features(BidsFeatures.SET_AUTO)
@Stories(ApiStories.JSON5)
public class UnknownFieldSetAutoRequestTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(Logins.SUPER_LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static long keywordId;

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void prepareData(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(BidsLogins.BIDS_CLIENT);
        api.userSteps.clientFakeSteps().enableAPI(BidsLogins.BIDS_CLIENT);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign(BidsLogins.BIDS_CLIENT);
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, BidsLogins.BIDS_CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, BidsLogins.BIDS_CLIENT);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(BidsLogins.BIDS_CLIENT, adGroupId);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1552")
    public void unknownFieldInRequest(){
        JSONObject params = new JSONObject();
        JSONObject bids = new JSONObject();
        bids.put(capitalize(BidSetAutoItemMap.KEYWORD_ID), keywordId);
        bids.put(capitalize(BidSetAutoItemMap.SCOPE), new Object[]{ScopeEnum.SEARCH});
        bids.put(capitalize(BidSetAutoItemMap.POSITION), PositionEnum.FOOTERFIRST);
        bids.put(capitalize(BidSetAutoItemMap.INCREASE_PERCENT),50);
        bids.put(capitalize(BidSetAutoItemMap.CALCULATE_BY), CalculateByEnum.VALUE);
        bids.put(capitalize(BidSetAutoItemMap.CONTEXT_COVERAGE),3);
        bids.put(capitalize(BidSetAutoItemMap.MAX_BID),10000000L);
        params.put("gingerField",":)");
        params.put(capitalize(SetAutoRequestMap.BIDS),new Object[]{bids});
        api.userSteps.bidsSteps().shouldGetJSONErrorOnBidsSetAuto(
                params,
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.UNKNOWN_PARAMETER,
                        "gingerField"
                )
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1553")
    public void unknownFieldInSelectionCriteria(){
        JSONObject params = new JSONObject();
        JSONObject bids = new JSONObject();
        bids.put(capitalize(BidSetAutoItemMap.KEYWORD_ID), keywordId);
        bids.put(capitalize(BidSetAutoItemMap.SCOPE), new Object[]{ScopeEnum.SEARCH});
        bids.put(capitalize(BidSetAutoItemMap.POSITION), PositionEnum.FOOTERFIRST);
        bids.put(capitalize(BidSetAutoItemMap.INCREASE_PERCENT),50);
        bids.put(capitalize(BidSetAutoItemMap.CALCULATE_BY), CalculateByEnum.VALUE);
        bids.put(capitalize(BidSetAutoItemMap.CONTEXT_COVERAGE),3);
        bids.put(capitalize(BidSetAutoItemMap.MAX_BID),10000000L);
        bids.put("gingerField",":)");
        params.put(capitalize(SetAutoRequestMap.BIDS),new Object[]{bids});
        api.userSteps.bidsSteps().shouldGetJSONErrorOnBidsSetAuto(
                params,
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.ELEMENT_OF_ARRAY_CONTAIN_UNKNOWN_FIELD,
                        // don't use path(..) because we don't want to capitalize wrong field name
                        capitalize(SetAutoRequestMap.BIDS), "gingerField"
                )
        );
    }
}
