package ru.yandex.autotests.direct.api.bids.setauto;

import com.yandex.direct.api.v5.bids.BidFieldEnum;
import com.yandex.direct.api.v5.bids.CalculateByEnum;
import com.yandex.direct.api.v5.bids.GetResponse;
import com.yandex.direct.api.v5.general.PositionEnum;
import com.yandex.direct.api.v5.general.ScopeEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerPhraseFakeInfo;
import ru.yandex.autotests.directapi.model.api5.bids.BidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetAutoItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.BidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.bids.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetAutoRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.core.IsEqual.equalTo;

/**
 * Created by ginger on 16.10.14.
 */

@Aqua.Test
@Features(BidsFeatures.SET_AUTO)
@Tag(TagDictionary.TRUNK)
public class UpdatingStatusBsSyncAfterSetAutoRequestTest {


    private static Long campaignId;
    private static Long adGroupId;
    private static long keywordId1;
    private static long keywordId2;
    protected LogSteps log = LogSteps.getLogger(this.getClass());
    private static String login = BidsLogins.SUPER;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);


    @BeforeClass
    @Step("Подготовка данных для теста")
    public static void readBanner(){
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(BidsLogins.BIDS_CLIENT);
        api.userSteps.clientFakeSteps().enableAPI(BidsLogins.BIDS_CLIENT);

        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaignWithStrategies(
                new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                BidsLogins.BIDS_CLIENT
        );
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, BidsLogins.BIDS_CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, BidsLogins.BIDS_CLIENT);
        keywordId1 = api.userSteps.keywordsSteps().addDefaultKeyword(BidsLogins.BIDS_CLIENT, adGroupId);
        keywordId2 = api.userSteps.keywordsSteps().addDefaultKeyword(BidsLogins.BIDS_CLIENT, adGroupId);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1554")
    public void statusBsSyncAfterSetAutoBidsTest(){
        //testplans string №67
        api.userSteps.phrasesFakeSteps().setPhraseStatusBsSyncedYes(adGroupId);
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap().withBids(
                        new BidSetAutoItemMap()
                                .withKeywordId(keywordId1)
                                .withPosition(PositionEnum.FOOTERFIRST)
                                .withIncreasePercent(600)
                                .withCalculateBy(CalculateByEnum.VALUE)
                                .withContextCoverage(80)
                                .withMaxBid(10000000L)
                                .withScope(ScopeEnum.SEARCH,ScopeEnum.NETWORK)
                ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.successWithKeywordId()
        );
        GetResponse getResponse = api.userSteps.bidsSteps().bidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new BidsSelectionCriteriaMap().withKeywordIds(
                                        keywordId1,
                                        keywordId2
                                )
                        )
                        .withFieldNames(
                                BidFieldEnum.CONTEXT_BID,
                                BidFieldEnum.BID,
                                BidFieldEnum.KEYWORD_ID),
                BidsLogins.BIDS_CLIENT
        );
        Long expectedBid = 300000L;
        assertThat("ставка поменялась",getResponse.getBids().get(0).getBid(),not(equalTo(expectedBid)));
        BannerPhraseFakeInfo phraseFakeInfo1 = api.userSteps.phrasesFakeSteps().getPhrasesParamsById(keywordId1)[0];
        BannerPhraseFakeInfo phraseFakeInfo2 = api.userSteps.phrasesFakeSteps().getPhrasesParamsById(keywordId2)[0];
        assertThat("у первой фразы должен сброситьтся statusBsSync",
                phraseFakeInfo1.getStatusBsSynced(),equalTo(Value.NO));
        assertThat("у второй фразы не должен сброситься statusBsSync",
                phraseFakeInfo2.getStatusBsSynced(),equalTo(Value.YES));

    }
}
