package ru.yandex.autotests.direct.api.bids.setauto.limit;

import java.util.Arrays;

import com.yandex.direct.api.v5.bids.CalculateByEnum;
import com.yandex.direct.api.v5.general.PositionEnum;
import com.yandex.direct.api.v5.general.ScopeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.bids.BidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetAutoItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetAutoRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by ginger on 15.09.14.
 */
@Aqua.Test
@Features(BidsFeatures.NOT_REGRESSION_YET)
@Issue("https://st.yandex-team.ru/DIRECT-35103")
public class SetAutoLimitTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());
    private static String login = BidsLogins.SUPER;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);
    private long keywordId;
    private Long adGroupId;
    private Long campaignId;

    @Before
    public void readBanner() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(BidsLogins.BIDS_CLIENT);
        api.userSteps.clientFakeSteps().enableAPI(BidsLogins.BIDS_CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(BidsLogins.BIDS_CLIENT);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, BidsLogins.BIDS_CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, BidsLogins.BIDS_CLIENT);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(BidsLogins.BIDS_CLIENT, adGroupId);

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1556")
    public void trySetAutoForMoreThanMaxAmountCampaignID() {
        //testplan: string №68
        //https://st.yandex-team.ru/DIRECT-35103
        BidSetAutoItemMap[] bidsWithCampaignID = new BidSetAutoItemMap[11];
        Arrays.fill(bidsWithCampaignID,
                new BidSetAutoItemMap()
                        .withCampaignId(campaignId)
                        .withPosition(PositionEnum.FOOTERFIRST)
                        .withIncreasePercent(50)
                        .withCalculateBy(CalculateByEnum.VALUE)
                        .withContextCoverage(3)
                        .withMaxBid(10000000L)
                        .withScope(ScopeEnum.NETWORK)
        );
        api.userSteps.bidsSteps().shouldGetErrorOnBidsSetAuto(
                new SetAutoRequestMap()
                        .withBids(bidsWithCampaignID),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(9300, Api5ErrorDetails.BIDS_SET_NO_MORE_THAN, 10, "campaigns"));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1557")
    public void trySetAutoForMoreThanMaxAmountAdGroupID() {
        //testplan: string №68
        //https://st.yandex-team.ru/DIRECT-35103
        BidSetAutoItemMap[] bidsWithAdGroupID = new BidSetAutoItemMap[1001];
        Arrays.fill(bidsWithAdGroupID, new BidSetAutoItemMap()
                .withAdGroupId(adGroupId)
                .withPosition(PositionEnum.FOOTERFIRST)
                .withIncreasePercent(50)
                .withCalculateBy(CalculateByEnum.VALUE)
                .withContextCoverage(3)
                .withMaxBid(10000000L)
                .withScope(ScopeEnum.NETWORK));
        api.userSteps.bidsSteps().shouldGetErrorOnBidsSetAuto(
                new SetAutoRequestMap()
                        .withBids(bidsWithAdGroupID),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(9300, Api5ErrorDetails.BIDS_SET_NO_MORE_THAN, 1000, "ad groups"));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1558")
    public void trySetAutoForMoreThanMaxAmountKeywordID() {
        //testplan: string №68
        //https://st.yandex-team.ru/DIRECT-35103
        BidSetAutoItemMap[] bidsWithKeywordID = new BidSetAutoItemMap[10001];
        Arrays.fill(bidsWithKeywordID, new BidSetAutoItemMap()
                .withKeywordId(keywordId)
                .withPosition(PositionEnum.FOOTERFIRST)
                .withIncreasePercent(50)
                .withCalculateBy(CalculateByEnum.VALUE)
                .withContextCoverage(3)
                .withMaxBid(10000000L)
                .withScope(ScopeEnum.NETWORK));
        api.userSteps.bidsSteps().shouldGetErrorOnBidsSetAuto(
                new SetAutoRequestMap()
                        .withBids(bidsWithKeywordID),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(9300, Api5ErrorDetails.BIDS_SET_NO_MORE_THAN, 10000, "keywords"));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1559")
    public void successSetAutoForMaxAmountCampaignID() {
        //testplan: string №68
        //https://st.yandex-team.ru/DIRECT-35103
        BidSetAutoItemMap[] bidsWithCampaignID = new BidSetAutoItemMap[10];
        Arrays.fill(bidsWithCampaignID, new BidSetAutoItemMap()
                .withCampaignId(campaignId)
                .withPosition(PositionEnum.FOOTERFIRST)
                .withIncreasePercent(50)
                .withCalculateBy(CalculateByEnum.VALUE)
                .withContextCoverage(3)
                .withMaxBid(10000000L)
                .withScope(ScopeEnum.NETWORK));
        BidExpectedResult[] expectedResults = new BidExpectedResult[10];
        Arrays.fill(expectedResults, BidExpectedResult.errors(
                new Notification(9800)
        ));
        api.as(BidsLogins.BIDS_CLIENT).userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withBids(bidsWithCampaignID),
                BidsLogins.BIDS_CLIENT,
                expectedResults);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1560")
    public void successSetAutoForMaxAmountAdGroupID() {
        //testplan: string №68
        //https://st.yandex-team.ru/DIRECT-35103
        BidSetAutoItemMap[] bidsWithAdGroupID = new BidSetAutoItemMap[1000];
        Arrays.fill(bidsWithAdGroupID,
                new BidSetAutoItemMap()
                        .withAdGroupId(adGroupId)
                        .withPosition(PositionEnum.FOOTERFIRST)
                        .withIncreasePercent(50)
                        .withCalculateBy(CalculateByEnum.VALUE)
                        .withContextCoverage(3)
                        .withMaxBid(10000000L)
                        .withScope(ScopeEnum.NETWORK)
        );
        BidExpectedResult[] expectedResults = new BidExpectedResult[1000];
        Arrays.fill(expectedResults, BidExpectedResult.errors(
                new Notification(9800)
        ));
        api.as(BidsLogins.BIDS_CLIENT).userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withBids(bidsWithAdGroupID),
                BidsLogins.BIDS_CLIENT,
                expectedResults);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1561")
    public void successSetAutoForMaxAmountKeywordID() {
        //testplan: string №68
        //https://st.yandex-team.ru/DIRECT-35103
        BidSetAutoItemMap[] bidsWithKeywordID = new BidSetAutoItemMap[10000];
        Arrays.fill(bidsWithKeywordID, new BidSetAutoItemMap()
                .withKeywordId(keywordId)
                .withPosition(PositionEnum.FOOTERFIRST)
                .withIncreasePercent(50)
                .withCalculateBy(CalculateByEnum.VALUE)
                .withContextCoverage(3)
                .withMaxBid(10000000L)
                .withScope(ScopeEnum.NETWORK));
        BidExpectedResult[] expectedResults = new BidExpectedResult[10000];
        Arrays.fill(expectedResults, BidExpectedResult.errors(
                new Notification(9800)
        ));
        api.as(BidsLogins.BIDS_CLIENT).userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withBids(bidsWithKeywordID),
                BidsLogins.BIDS_CLIENT,
                expectedResults);
    }
}
