package ru.yandex.autotests.direct.api.bids.setauto.strategy;

import com.yandex.direct.api.v5.bids.CalculateByEnum;
import com.yandex.direct.api.v5.general.PositionEnum;
import com.yandex.direct.api.v5.general.ScopeEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.bids.BidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.bids.BidSetAutoItemMap;
import ru.yandex.autotests.directapi.model.api5.bids.SetAutoRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by ginger on 07.09.14.
 */
@Aqua.Test
@Features(BidsFeatures.SET_AUTO)
@Tag(TagDictionary.TRUNK)
public class SetAutoBidsShowsDisabledOnSearchAndMaximumOnContextTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long campaignID;
    private Long adGroupId;

    @Before
    @Step("Подготовка данных для теста")
    public void createData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(BidsLogins.BIDS_CLIENT);
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaignWithStrategies(
                new TextCampaignSearchStrategyAddMap().defaultServingOff(),
                new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                BidsLogins.BIDS_CLIENT
        );
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, BidsLogins.BIDS_CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, BidsLogins.BIDS_CLIENT);
        api.userSteps.keywordsSteps().addDefaultKeyword(BidsLogins.BIDS_CLIENT, adGroupId);
        api.protocol(ProtocolType.SOAP);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1570")
    public void trySetAutoWithSearchScopeTest(){
        //DIRECT-35871
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withBids(
                                new BidSetAutoItemMap()
                                        .withAdGroupId(adGroupId)
                                        .withPosition(PositionEnum.FOOTERFIRST)
                                        .withIncreasePercent(50)
                                        .withCalculateBy(CalculateByEnum.VALUE)
                                        .withContextCoverage(3)
                                        .withMaxBid(10000000L)
                                        .withScope(ScopeEnum.SEARCH)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.errors(
                        new Notification(9601,
                                Api5ErrorDetails.BIDS_WILL_NOT_APPLIED_BECAUSE_OF_SHOWS_DISABLED_ON_SEARCH)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1568")
    public void trySetAutoWithNetworkScopeTest(){
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withBids(
                                new BidSetAutoItemMap()
                                        .withAdGroupId(adGroupId)
                                        .withPosition(PositionEnum.FOOTERFIRST)
                                        .withIncreasePercent(50)
                                        .withCalculateBy(CalculateByEnum.VALUE)
                                        .withContextCoverage(3)
                                        .withMaxBid(10000000L)
                                        .withScope(ScopeEnum.NETWORK)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.successWithAdGroupId());
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1569")
    public void trySetAutoWithBothScopeTest(){
        api.userSteps.bidsSteps().shouldGetBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withBids(
                                new BidSetAutoItemMap()
                                        .withAdGroupId(adGroupId)
                                        .withPosition(PositionEnum.FOOTERFIRST)
                                        .withIncreasePercent(50)
                                        .withCalculateBy(CalculateByEnum.VALUE)
                                        .withContextCoverage(3)
                                        .withMaxBid(10000000L)
                                        .withScope(ScopeEnum.SEARCH, ScopeEnum.NETWORK)
                        ),
                BidsLogins.BIDS_CLIENT,
                BidExpectedResult.warningsWithAdGroupID(
                        new Notification(10160,
                                Api5ErrorDetails.CHANGE_BIDS_ON_SEARCH_NOT_ALLOWED_BECAUSE_SHOWS_DISABLED)));
    }
}
