package ru.yandex.autotests.direct.api.keywordbids.get;

import java.math.BigDecimal;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import com.yandex.direct.api.v5.general.PriorityEnum;
import com.yandex.direct.api.v5.keywordbids.GetResponse;
import com.yandex.direct.api.v5.keywordbids.KeywordBidFieldEnum;
import com.yandex.direct.api.v5.keywordbids.KeywordBidNetworkFieldEnum;
import com.yandex.direct.api.v5.keywordbids.KeywordBidSearchFieldEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsFeatures;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5;
import ru.yandex.autotests.directapi.model.api5.keywordbids.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidsGetItemMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Collections.singletonList;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(BidsFeatures.GET)
@Description("Проверка чтения нулевых ставок")
@Issue("https://st.yandex-team.ru/DIRECT-85695")
public class KeywordBidsGetZeroPricesTest {
    private static final String CLIENT = BidsLogins.CLIENT_FOR_RUB;
    private static long adGroupId;
    private static long keywordId;
    private static long campaignId;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static DirectJooqDbSteps dbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT);

    @BeforeClass
    public static void prepare() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
    }

    @Test
    @TestCaseId("3085")
    public void testDefaultBidsForCPC() {
        long defaultBid = MoneyCurrency.get(Currency.RUB).getMinPrice().bidLong().longValue();

        BidsRecord bidsRecord = dbSteps.bidsSteps().getBidById(keywordId);
        bidsRecord.setPrice(BigDecimal.ZERO).setPriceContext(BigDecimal.ZERO);
        dbSteps.bidsSteps().updateBids(bidsRecord);

        GetResponse response = api.userSteps.keywordBidsSteps().keywordBidsGet(
                new GetRequestMap().withSelectionCriteria(
                        new KeywordBidsSelectionCriteriaMap()
                                .withKeywordIds(keywordId))
                        .withFieldNames(KeywordBidFieldEnum.STRATEGY_PRIORITY)
                        .withSearchFieldNames(KeywordBidSearchFieldEnum.BID)
                        .withNetworkFieldNames(KeywordBidNetworkFieldEnum.BID));

        assertThat("ставки по умолчанию установились верно", response.getKeywordBids(),
                BeanDifferMatcherV5.beanDifferV5(singletonList(
                        new KeywordBidsGetItemMap()
                                .withSearchBid(defaultBid)
                                .withNetworkBid(defaultBid)
                                .withStrategyPriority(PriorityEnum.NORMAL)
                                .getBean()
                )));
    }
}
