package ru.yandex.autotests.direct.api.keywordbids.set;

import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.api.keywordbids.KeywordBidsFeatures;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsArchived;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidsSetItemMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.SetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by gerdler on 27.01.17.
 */
@Aqua.Test
@Features(KeywordBidsFeatures.SET)
@Issue("https://st.yandex-team.ru/DIRECT-55967")
public class BidsSetForAbnormalArchivedCampaignNegativeTest {

    private static final String CLIENT = BidsLogins.BIDS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    private static final DirectJooqDbSteps JOOQ_DB_STEPS =
            api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT);
    private static final Long BID = MoneyCurrency.get(Currency.RUB).getLongMinPrice().longValue();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long campaignId;
    private static Long adGroupId;
    private static Long keywordId;
    private static Long autotargetingId;

    @BeforeClass
    @Step("Подготовка данных для теста")
    public static void createKeyword() {
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        autotargetingId = api.userSteps.keywordsSteps().addAutotargeting(adGroupId);
        CampaignsRecord campaignsRecord = JOOQ_DB_STEPS.campaignsSteps().getCampaignById(campaignId);
        JOOQ_DB_STEPS.campaignsSteps().updateCampaigns(campaignsRecord.setArchived(CampaignsArchived.Yes));
    }

    @AfterClass
    public static void fixCampaign() {
        CampaignsRecord campaignsRecord = JOOQ_DB_STEPS.campaignsSteps().getCampaignById(campaignId);
        JOOQ_DB_STEPS.campaignsSteps().updateCampaigns(campaignsRecord.setArchived(CampaignsArchived.No));
    }

    @Test
    @TestCaseId("2831")
    public void checkRightsToSetByCid() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetItemMap()
                                        .withCampaignId(campaignId)
                                        .withSearchBid(BID)
                        ),
                KeywordBidExpectedResult.errors(
                        new Notification(8300, Api5ErrorDetails.UNABLE_UPDATE_ARCHIVED_CAMPAGN)
                )
        );
    }

    @Test
    @TestCaseId("2832")
    public void checkRightsToSetByAdGroupId() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetItemMap()
                                        .withAdGroupId(adGroupId)
                                        .withSearchBid(BID)
                        ),
                KeywordBidExpectedResult.errors(
                        new Notification(8300, Api5ErrorDetails.UNABLE_UPDATE_ARCHIVED_CAMPAGN)
                )
        );
    }

    @Test
    @TestCaseId("2833")
    public void checkRightsToSetByKeywordId() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetItemMap()
                                        .withKeywordId(keywordId)
                                        .withSearchBid(BID)
                        ),
                KeywordBidExpectedResult.errors(
                        new Notification(8300, Api5ErrorDetails.UNABLE_UPDATE_ARCHIVED_CAMPAGN)
                )
        );
    }

    @Test
    @TestCaseId("2834")
    public void checkRightsToSetForAutotargetingByKeywordId() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetItemMap()
                                        .withKeywordId(autotargetingId)
                                        .withSearchBid(BID)
                        ),
                KeywordBidExpectedResult.errors(
                        new Notification(8300, Api5ErrorDetails.UNABLE_UPDATE_ARCHIVED_CAMPAGN)
                )
        );
    }
}
