package ru.yandex.autotests.direct.api.keywordbids.set;

import com.yandex.direct.api.v5.general.PriorityEnum;
import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.api.keywordbids.KeywordBidsFeatures;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidsSetItemMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.SetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by ginger on 10.12.14.
 */
@Aqua.Test
@Features(KeywordBidsFeatures.SET)
@Stories(ApiStories.JSON5)
public class InvalidFieldTypeSetRequestTest {
    private static LogSteps log = LogSteps.getLogger(
            ru.yandex.autotests.direct.api.bids.set.InvalidFieldTypeSetRequestTest.class);

    @ClassRule
    public static ApiSteps api = new ApiSteps().protocol(ProtocolType.JSON).version(104).as(Logins.SUPER_LOGIN);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static long keywordId;
    private static Long adGroupId;
    private static Long campaignID;

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    public static void prepareData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(BidsLogins.BIDS_CLIENT);
        api.userSteps.clientFakeSteps().enableAPI(BidsLogins.BIDS_CLIENT);
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaignWithStrategies(
                new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                BidsLogins.BIDS_CLIENT
        );
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, BidsLogins.BIDS_CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, BidsLogins.BIDS_CLIENT);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(BidsLogins.BIDS_CLIENT, adGroupId);
    }

    @Test
    @TestCaseId("2868")
    public void trySetBidsNotArray() {
        JSONObject bids = new JSONObject();
        bids.put(capitalize(KeywordBidsSetItemMap.KEYWORD_ID), keywordId);
        bids.put(capitalize(KeywordBidsSetItemMap.SEARCH_BID), 13l);
        bids.put(capitalize(KeywordBidsSetItemMap.NETWORK_BID), 12l);
        bids.put(capitalize(KeywordBidsSetItemMap.STRATEGY_PRIORITY), PriorityEnum.NORMAL);
        JSONObject params = new JSONObject();
        params.put(capitalize(SetRequestMap.KEYWORD_BIDS), bids);
        api.userSteps.keywordBidsSteps().shouldGetJSONErrorOnBidsSet(
                params,
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetails.FIELD_MUST_CONTAIN_ARRAY,
                        capitalize(SetRequestMap.KEYWORD_BIDS)
                )
        );
    }

    @Test
    @TestCaseId("2857")
    public void trySetKeywordIdWithQuotes() {
        JSONObject bids = new JSONObject();
        bids.put(capitalize(KeywordBidsSetItemMap.KEYWORD_ID), String.valueOf(keywordId));
        bids.put(capitalize(KeywordBidsSetItemMap.SEARCH_BID), 13000000l);
        JSONObject params = new JSONObject();
        params.put(capitalize(SetRequestMap.KEYWORD_BIDS), new Object[]{bids});
        api.userSteps.keywordBidsSteps().shouldGetBidResultOnJson(
                Action.SET,
                BidsLogins.BIDS_CLIENT,
                params,
                KeywordBidExpectedResult.successWithKeywordId()
        );
    }

    @Test
    @TestCaseId("2858")
    public void trySetKeywordIdStringValue() {
        JSONObject bids = new JSONObject();
        bids.put(capitalize(KeywordBidsSetItemMap.KEYWORD_ID), "gingerValue");
        bids.put(capitalize(KeywordBidsSetItemMap.SEARCH_BID), 13l);
        bids.put(capitalize(KeywordBidsSetItemMap.NETWORK_BID), 12l);
        bids.put(capitalize(KeywordBidsSetItemMap.STRATEGY_PRIORITY), PriorityEnum.NORMAL);
        JSONObject params = new JSONObject();
        params.put(capitalize(SetRequestMap.KEYWORD_BIDS), new Object[]{bids});
        api.userSteps.keywordBidsSteps().shouldGetJSONErrorOnBidsSet(
                params,
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetails.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                        path(SetRequestMap.KEYWORD_BIDS, KeywordBidsSetItemMap.KEYWORD_ID)
                )
        );
    }

    @Test
    @TestCaseId("2859")
    public void trySetAdGroupIdWithQuotes() {
        JSONObject bids = new JSONObject();
        bids.put(capitalize(KeywordBidsSetItemMap.AD_GROUP_ID), String.valueOf(adGroupId));
        bids.put(capitalize(KeywordBidsSetItemMap.SEARCH_BID), 13000000l);
        JSONObject params = new JSONObject();
        params.put(capitalize(SetRequestMap.KEYWORD_BIDS), new Object[]{bids});
        api.userSteps.keywordBidsSteps().shouldGetBidResultOnJson(
                Action.SET,
                BidsLogins.BIDS_CLIENT,
                params,
                KeywordBidExpectedResult.successWithAdGroupId()
        );
    }

    @Test
    @TestCaseId("2860")
    public void trySetAdGroupIdStringValue() {
        JSONObject bids = new JSONObject();
        bids.put(capitalize(KeywordBidsSetItemMap.AD_GROUP_ID), "gingerValue");
        bids.put(capitalize(KeywordBidsSetItemMap.SEARCH_BID), 13000000l);
        JSONObject params = new JSONObject();
        params.put(capitalize(SetRequestMap.KEYWORD_BIDS), new Object[]{bids});
        api.userSteps.keywordBidsSteps().shouldGetJSONErrorOnBidsSet(
                params,
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetails.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                        path(SetRequestMap.KEYWORD_BIDS, KeywordBidsSetItemMap.AD_GROUP_ID)
                )
        );
    }

    @Test
    @TestCaseId("2861")
    public void trySetCampaignIdWithQuotes() {
        JSONObject bids = new JSONObject();
        bids.put(capitalize(KeywordBidsSetItemMap.CAMPAIGN_ID), String.valueOf(campaignID));
        bids.put(capitalize(KeywordBidsSetItemMap.SEARCH_BID), 13000000l);
        JSONObject params = new JSONObject();
        params.put(capitalize(SetRequestMap.KEYWORD_BIDS), new Object[]{bids});
        api.userSteps.keywordBidsSteps().shouldGetBidResultOnJson(
                Action.SET,
                BidsLogins.BIDS_CLIENT,
                params,
                KeywordBidExpectedResult.successWithCampaignId()
        );
    }

    @Test
    @TestCaseId("2862")
    public void trySetCampaignIdStringValue() {
        JSONObject bids = new JSONObject();
        bids.put(capitalize(KeywordBidsSetItemMap.CAMPAIGN_ID), "gingerValue");
        bids.put(capitalize(KeywordBidsSetItemMap.SEARCH_BID), 13000000l);
        JSONObject params = new JSONObject();
        params.put(capitalize(SetRequestMap.KEYWORD_BIDS), new Object[]{bids});
        api.userSteps.keywordBidsSteps().shouldGetJSONErrorOnBidsSet(
                params,
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetails.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                        path(SetRequestMap.KEYWORD_BIDS, KeywordBidsSetItemMap.CAMPAIGN_ID)
                )
        );
    }

    @Test
    @TestCaseId("2863")
    public void trySetBidNotLongValue() {
        JSONObject bids = new JSONObject();
        bids.put(capitalize(KeywordBidsSetItemMap.KEYWORD_ID), keywordId);
        bids.put(capitalize(KeywordBidsSetItemMap.SEARCH_BID), 13.9f);
        JSONObject params = new JSONObject();
        params.put(capitalize(SetRequestMap.KEYWORD_BIDS), new Object[]{bids});
        api.userSteps.keywordBidsSteps().shouldGetJSONErrorOnBidsSet(
                params,
                BidsLogins.BIDS_CLIENT,
                // TODO DIRECT-73215
                new Api5Error(8000,
                        Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD2,
                        "KeywordBids.SearchBid"
                )
        );
    }

    @Test
    @TestCaseId("2864")
    public void trySetBidLongWithQuotes() {
        JSONObject bids = new JSONObject();
        bids.put(capitalize(KeywordBidsSetItemMap.KEYWORD_ID), keywordId);
        bids.put(capitalize(KeywordBidsSetItemMap.SEARCH_BID), "13000000");
        JSONObject params = new JSONObject();
        params.put(capitalize(SetRequestMap.KEYWORD_BIDS), new Object[]{bids});
        api.userSteps.keywordBidsSteps().shouldGetBidResultOnJson(
                Action.SET,
                BidsLogins.BIDS_CLIENT,
                params,
                KeywordBidExpectedResult.successWithKeywordId()
        );
    }

    @Test
    @TestCaseId("2865")
    public void trySetContextBidNotLongValue() {
        JSONObject bids = new JSONObject();
        bids.put(capitalize(KeywordBidsSetItemMap.KEYWORD_ID), keywordId);
        bids.put(capitalize(KeywordBidsSetItemMap.NETWORK_BID), 12.6f);
        JSONObject params = new JSONObject();
        params.put(capitalize(SetRequestMap.KEYWORD_BIDS), new Object[]{bids});
        api.userSteps.keywordBidsSteps().shouldGetJSONErrorOnBidsSet(
                params,
                BidsLogins.BIDS_CLIENT,
                // TODO DIRECT-73215
                new Api5Error(8000,
                        Api5ErrorDetailsJava.INVALID_VALUE_IN_FIELD2,
                        "KeywordBids.NetworkBid"
                )
        );
    }

    @Test
    @TestCaseId("2866")
    public void trySetContextBidLongWithQuotes() {
        JSONObject bids = new JSONObject();
        bids.put(capitalize(KeywordBidsSetItemMap.KEYWORD_ID), keywordId);
        bids.put(capitalize(KeywordBidsSetItemMap.NETWORK_BID), "13000000");
        JSONObject params = new JSONObject();
        params.put(capitalize(SetRequestMap.KEYWORD_BIDS), new Object[]{bids});
        api.userSteps.keywordBidsSteps().shouldGetBidResultOnJson(
                Action.SET,
                BidsLogins.BIDS_CLIENT,
                params,
                KeywordBidExpectedResult.successWithKeywordId()
        );
    }

    @Test
    @TestCaseId("2867")
    public void trySetStrategyPriorityInvalidValue() {
        JSONObject bids = new JSONObject();
        bids.put(capitalize(KeywordBidsSetItemMap.KEYWORD_ID), keywordId);
        bids.put(capitalize(KeywordBidsSetItemMap.STRATEGY_PRIORITY), "gingerValue");
        JSONObject params = new JSONObject();
        params.put(capitalize(SetRequestMap.KEYWORD_BIDS), new Object[]{bids});
        api.userSteps.keywordBidsSteps().shouldGetJSONErrorOnBidsSet(
                params,
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.INCORRECT_ENUMERATE_VALUE,
                        path(SetRequestMap.KEYWORD_BIDS, KeywordBidsSetItemMap.STRATEGY_PRIORITY),
                        Api5Error.enumAsParam(PriorityEnum.class)
                )
        );
    }

}
