package ru.yandex.autotests.direct.api.keywordbids.set;


import com.yandex.direct.api.v5.keywordbids.GetResponse;
import com.yandex.direct.api.v5.keywordbids.KeywordBidFieldEnum;
import com.yandex.direct.api.v5.keywordbids.KeywordBidGetItem;
import com.yandex.direct.api.v5.keywordbids.KeywordBidNetworkFieldEnum;
import com.yandex.direct.api.v5.keywordbids.KeywordBidSearchFieldEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.api.keywordbids.KeywordBidsFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidsSetItemMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.SetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.is;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(KeywordBidsFeatures.SET)
@Description("Тесты на проверку округления ставок")
public class SetBidRoundingTest {

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    private static final String LOGIN = BidsLogins.SUPER;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static long keywordId;

    @BeforeClass
    @Step("Подготовка данных для теста")
    @SuppressWarnings("Duplicates")
    public static void readBanner() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(BidsLogins.BIDS_CLIENT);
        Long campaignId = api.as(BidsLogins.BIDS_CLIENT).userSteps.campaignSteps().addDefaultTextCampaignWithStrategies(
                new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage()
        );
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
    }

    @Test
    @TestCaseId("3093")
    public void setSearchBidRoundUpTest() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap().withKeywordBids(
                        new KeywordBidsSetItemMap()
                                .withKeywordId(keywordId)
                                .withSearchBid(143845000L)
                ),
                KeywordBidExpectedResult.successWithKeywordId()
        );
        GetResponse response = api.userSteps.keywordBidsSteps().keywordBidsGet(
                new GetRequestMap()
                        .withFieldNames(KeywordBidFieldEnum.KEYWORD_ID)
                        .withSearchFieldNames(KeywordBidSearchFieldEnum.BID)
                        .withSelectionCriteria(
                                new KeywordBidsSelectionCriteriaMap().withKeywordIds(keywordId)));

        assumeThat("Должен вернуться один элемент", response.getKeywordBids(), hasSize(1));
        KeywordBidGetItem responseItem = response.getKeywordBids().get(0);

        assertThat("Ставка должна округлиться вверх",
                responseItem.getSearch().getBid(), is(143850000L));
    }

    @Test
    @TestCaseId("3094")
    public void setNetworkBidRoundUpTest() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap().withKeywordBids(
                        new KeywordBidsSetItemMap()
                                .withKeywordId(keywordId)
                                .withNetworkBid(143845000L)
                ),
                KeywordBidExpectedResult.successWithKeywordId()
        );
        GetResponse response = api.userSteps.keywordBidsSteps().keywordBidsGet(
                new GetRequestMap()
                        .withFieldNames(KeywordBidFieldEnum.KEYWORD_ID)
                        .withNetworkFieldNames(KeywordBidNetworkFieldEnum.BID)
                        .withSelectionCriteria(
                                new KeywordBidsSelectionCriteriaMap().withKeywordIds(keywordId)));

        assumeThat("Должен вернуться один элемент", response.getKeywordBids(), hasSize(1));
        KeywordBidGetItem responseItem = response.getKeywordBids().get(0);

        assertThat("Ставка должна округлиться вверх",
                responseItem.getNetwork().getBid(), is(143850000L));
    }

    @Test
    @TestCaseId("3095")
    public void setSearchBidRoundDownTest() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap().withKeywordBids(
                        new KeywordBidsSetItemMap()
                                .withKeywordId(keywordId)
                                .withSearchBid(143844999L)
                ),
                KeywordBidExpectedResult.successWithKeywordId()
        );
        GetResponse response = api.userSteps.keywordBidsSteps().keywordBidsGet(
                new GetRequestMap()
                        .withFieldNames(KeywordBidFieldEnum.KEYWORD_ID)
                        .withSearchFieldNames(KeywordBidSearchFieldEnum.BID)
                        .withSelectionCriteria(
                                new KeywordBidsSelectionCriteriaMap().withKeywordIds(keywordId)));

        assumeThat("Должен вернуться один элемент", response.getKeywordBids(), hasSize(1));
        KeywordBidGetItem responseItem = response.getKeywordBids().get(0);

        assertThat("Ставка должна округлиться вниз",
                responseItem.getSearch().getBid(), is(143840000L));
    }

    @Test
    @TestCaseId("3096")
    public void setNetworkBidRoundDownTest() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap().withKeywordBids(
                        new KeywordBidsSetItemMap()
                                .withKeywordId(keywordId)
                                .withNetworkBid(143844999L)
                ),
                KeywordBidExpectedResult.successWithKeywordId()
        );
        GetResponse response = api.userSteps.keywordBidsSteps().keywordBidsGet(
                new GetRequestMap()
                        .withFieldNames(KeywordBidFieldEnum.KEYWORD_ID)
                        .withNetworkFieldNames(KeywordBidNetworkFieldEnum.BID)
                        .withSelectionCriteria(
                                new KeywordBidsSelectionCriteriaMap().withKeywordIds(keywordId)));

        assumeThat("Должен вернуться один элемент", response.getKeywordBids(), hasSize(1));
        KeywordBidGetItem responseItem = response.getKeywordBids().get(0);

        assertThat("Ставка должна округлиться вниз",
                responseItem.getNetwork().getBid(), is(143840000L));
    }
}
