package ru.yandex.autotests.direct.api.keywordbids.set;

import java.util.Arrays;
import java.util.Collection;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.api.keywordbids.KeywordBidsFeatures;
import ru.yandex.autotests.direct.utils.model.ShardNumbers;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidsSetItemMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.SetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by ginger on 22.09.14.
 */
@Aqua.Test
@Features(KeywordBidsFeatures.SET)
@RunWith(Parameterized.class)
public class SetByRolesWithAccessTest {

    private static final Long BID = MoneyCurrency.get(Currency.RUB).getLongMinPrice().longValue();

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static Long campaignId;

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String loginForAuthorization;

    @Parameterized.Parameter(1)
    public String loginForHeader;

    @Parameterized.Parameter(2)
    public String loginForCreateCampaign;

    @Parameterized.Parameters(name = "loginForAuthorization = {0}, loginForHeader = {1}, loginForCreateCampaign = {2}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {BidsLogins.BIDS_AGENCY, BidsLogins.BIDS_SUBCLIENT, BidsLogins.BIDS_AGENCY},
                {BidsLogins.BIDS_REP_ADMIN_AGENCY, BidsLogins.BIDS_SUBCLIENT, BidsLogins.BIDS_AGENCY},
                {BidsLogins.BIDS_CLIENT, BidsLogins.BIDS_CLIENT, BidsLogins.BIDS_CLIENT},
                {BidsLogins.BIDS_REP_CLIENT, BidsLogins.BIDS_CLIENT, BidsLogins.BIDS_CLIENT}
        };
        return Arrays.asList(data);
    }

    private Long adGroupId;

    @BeforeClass
    public static void reshardUsers() {
        api.userSteps.clientFakeSteps().reshardUserWithLock(BidsLogins.BIDS_SUBCLIENT, ShardNumbers.EXTRA_SHARD);
    }

    @Before
    @Step("Подготовка данных для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(loginForAuthorization);
        campaignId = api.as(loginForCreateCampaign).protocol(ProtocolType.SOAP).userSteps.campaignSteps()
                .addDefaultTextCampaign(loginForHeader);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, loginForHeader);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, loginForHeader);
    }


    @Test
    @TestCaseId("2869")
    public void callBidsSet() {
        //testplan: string № 24

        long keywordId =
                api.as(loginForCreateCampaign).userSteps.keywordsSteps().addDefaultKeyword(loginForHeader, adGroupId);
        api.as(loginForAuthorization).userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetItemMap()
                                        .withKeywordId(keywordId)
                                        .withSearchBid(BID)
                        ),
                loginForHeader,
                KeywordBidExpectedResult.successWithKeywordId());
    }

    @Test
    @TestCaseId("2870")
    public void callBidsSetForAutotargeting() {
        Long autotargetingId =
                api.as(loginForCreateCampaign).userSteps.keywordsSteps().addAutotargeting(loginForHeader, adGroupId);
        api.as(loginForAuthorization).userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap().withKeywordBids(
                        new KeywordBidsSetItemMap().withKeywordId(autotargetingId).withSearchBid(BID)
                ),
                loginForHeader,
                KeywordBidExpectedResult.successWithKeywordId()
        );
    }
}
