package ru.yandex.autotests.direct.api.keywordbids.set;

import com.google.common.base.Joiner;
import com.yandex.direct.api.v5.general.PriorityEnum;
import com.yandex.direct.api.v5.keywordbids.GetResponse;
import com.yandex.direct.api.v5.keywordbids.KeywordBidFieldEnum;
import com.yandex.direct.api.v5.keywordbids.KeywordBidSearchFieldEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.api.keywordbids.KeywordBidsFeatures;
import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.utils.matchers.IsApiBeanCollectionContaining;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.money.MoneyFormat;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.apiclient.errors.Path;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.keywordbids.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidsGetItemMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidsSetItemMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.SetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

@Aqua.Test
@Features(KeywordBidsFeatures.SET)
@Tag(TagDictionary.TRUNK)
public class SetNegativeTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());
    private static final String SUPER = BidsLogins.SUPER;
    private static final String CLIENT = BidsLogins.BIDS_CLIENT;
    private static final String ANOTHER_CLIENT = BidsLogins.BIDS_ANOTHER_CLIENT;
    private static final MoneyCurrency CURRENCY_RUB = MoneyCurrency.get(Currency.RUB);
    private static final Long MAX_BID = CURRENCY_RUB.getLongMaxPrice().longValue();

    private static final Notification BID_MUST_NOT_BE_LESS_NOTIFICATION = new Notification(
            5005,
            Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_LESS,
            capitalize(KeywordBidsSetItemMap.SEARCH_BID),
            CURRENCY_RUB.getNamePluralI(DirectTestRunProperties.getInstance().getDirectAPILocale().toLowerCase()),
            CURRENCY_RUB.getLongMinPrice().stringValue(MoneyFormat.INTEGER)
    );

    private static final Notification CONTEXT_BID_MUST_NOT_BE_LESS_NOTIFICATION = new Notification(
            5005,
            Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_LESS,
            capitalize(KeywordBidsSetItemMap.NETWORK_BID),
            CURRENCY_RUB.getNamePluralI(DirectTestRunProperties.getInstance().getDirectAPILocale().toLowerCase()),
            CURRENCY_RUB.getLongMinPrice().stringValue(MoneyFormat.INTEGER)
    );

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(SUPER);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static Long negativeLong = -1L;
    private static Long adGroupId11;
    private static long keywordId11;
    private static Long autotargetingId;
    private static Long adGroupId12;
    private static Long adGroupId21;
    private static long keywordId21;
    private static Long anotherAdGroupId;
    private static long anotherkeywordId;
    private static Long anotherAutotargetingId;
    private static Long archiveAdGroupId;
    private static long archivekeywordId;
    private static Long archiveAutotargetingId;
    private static Long deletedAdGroupId;
    private static long deletedkeywordId;
    private static Long deletedAutotargetingId;
    private static Long deletedCampaignAutotargetingId;
    private static Long campaignId1;
    private static Long campaignId2;
    private static Long anotherCampaignId;
    private static Long deletedCampaignId;
    private static Long archiveCampaignId;
    private static long keywordId12;


    @BeforeClass
    @Step("Подготовка данных для теста")
    public static void readBanner() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        api.userSteps.clientFakeSteps().enableAPI(CLIENT);
        campaignId1 = api.userSteps.campaignSteps().addDefaultTextCampaignWithStrategies(
                new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                CLIENT
        );
        adGroupId11 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId1, CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId11, CLIENT);
        keywordId11 = api.userSteps.keywordsSteps().addDefaultKeyword(CLIENT, adGroupId11);
        autotargetingId = api.userSteps.keywordsSteps().addAutotargeting(CLIENT, adGroupId11);

        adGroupId12 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId1, CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId12, CLIENT);
        keywordId12 = api.userSteps.keywordsSteps().addDefaultKeyword(CLIENT, adGroupId12);
        deletedAutotargetingId = api.userSteps.keywordsSteps().addAutotargeting(CLIENT, adGroupId12);
        api.userSteps.keywordsSteps().keywordsDelete(CLIENT, deletedAutotargetingId);
        //Вторая кампания клиента с одной фразой
        campaignId2 = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
        adGroupId21 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId2, CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId21, CLIENT);
        keywordId21 = api.userSteps.keywordsSteps().addDefaultKeyword(CLIENT, adGroupId21);

        //Чужая кампания
        anotherCampaignId =
                api.as(Logins.SUPER_LOGIN).userSteps.campaignSteps().addDefaultTextCampaign(ANOTHER_CLIENT);
        anotherAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(anotherCampaignId, ANOTHER_CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(anotherAdGroupId, ANOTHER_CLIENT);
        anotherkeywordId = api.userSteps.keywordsSteps().addDefaultKeyword(ANOTHER_CLIENT, anotherAdGroupId);
        anotherAutotargetingId = api.userSteps.keywordsSteps().addAutotargeting(ANOTHER_CLIENT, anotherAdGroupId);

        //Архивная кампания
        archiveCampaignId =
                api.as(Logins.SUPER_LOGIN).userSteps.campaignSteps().addDefaultTextCampaign(ANOTHER_CLIENT);
        archiveAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(archiveCampaignId, ANOTHER_CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(archiveAdGroupId, ANOTHER_CLIENT);
        archivekeywordId = api.userSteps.keywordsSteps().addDefaultKeyword(ANOTHER_CLIENT, archiveAdGroupId);
        archiveAutotargetingId = api.userSteps.keywordsSteps().addAutotargeting(ANOTHER_CLIENT, archiveAdGroupId);
        api.userSteps.campaignSteps().campaignsSuspend(ANOTHER_CLIENT, archiveCampaignId);
        api.userSteps.campaignSteps().campaignsArchive(ANOTHER_CLIENT, archiveCampaignId);

        //Удаленная кампания
        deletedCampaignId =
                api.as(Logins.SUPER_LOGIN).userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
        deletedAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(deletedCampaignId, CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(deletedAdGroupId, CLIENT);
        deletedkeywordId = api.userSteps.keywordsSteps().addDefaultKeyword(CLIENT, deletedAdGroupId);
        deletedCampaignAutotargetingId = api.userSteps.keywordsSteps().addAutotargeting(CLIENT, deletedAdGroupId);
        api.userSteps.campaignSteps().campaignsDelete(CLIENT, deletedCampaignId);
        api.protocol(ProtocolType.SOAP);

    }

    @Test
    @TestCaseId("2873")
    public void trySetNullParams() {
        //testplan: string №25
        api.userSteps.keywordBidsSteps().shouldGetErrorOnKeywordBidsSet(
                new SetRequestMap(),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(SetRequestMap.KEYWORD_BIDS))
        );
    }


    @Test
    @TestCaseId("2874")
    public void trySetValidAndInvalidBids() {
        //testplan: string №29
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap().withKeywordBids(
                        new KeywordBidsSetItemMap()
                                .withKeywordId(keywordId11)
                                .withSearchBid(MAX_BID)
                                .withNetworkBid(MAX_BID),
                        new KeywordBidsSetItemMap()
                                .withKeywordId(1L)
                                .withSearchBid(MAX_BID)),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.successWithKeywordId(),
                KeywordBidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                capitalize(KeywordBidsSetItemMap.KEYWORD_ID),
                                1)
                        ))
        );

    }

    @Test
    @TestCaseId("2875")
    public void trySetOneInvalidBids() {
        //testplan: string №31
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetItemMap()
                                        .withKeywordId(negativeLong)
                                        .withNetworkBid(MAX_BID)
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(5005, Api5ErrorDetailsJava.FIELD_MUST_BE_POSITIVE_INTEGER,
                                capitalize(KeywordBidsSetItemMap.KEYWORD_ID)))
                ));
    }

    @Test
    @TestCaseId("2876")
    public void trySetBidsForArchivedCampaignID() {
        //testplan: string №35
        // https://st.yandex-team.ru/DIRECT-34097
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetItemMap()
                                        .withCampaignId(archiveCampaignId)
                                        .withSearchBid(MAX_BID)
                                        .withNetworkBid(MAX_BID)
                                        .withStrategyPriority(PriorityEnum.LOW)
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                capitalize(KeywordBidsSetItemMap.CAMPAIGN_ID),
                                archiveCampaignId))
                ));
    }

    @Test
    @TestCaseId("2877")
    public void trySetBidsForDeletedCampaignID() {
        //testplan: string №35
        // https://st.yandex-team.ru/DIRECT-34097
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetItemMap()
                                        .withCampaignId(deletedCampaignId)
                                        .withSearchBid(MAX_BID)
                                        .withNetworkBid(MAX_BID)
                                        .withStrategyPriority(PriorityEnum.LOW)
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                capitalize(KeywordBidsSetItemMap.CAMPAIGN_ID),
                                deletedCampaignId))
                ));
    }

    @Test
    @TestCaseId("2878")
    public void trySetBidsForArchivedAdGroupID() {
        //testplan: string №36
        // https://st.yandex-team.ru/DIRECT-34097
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetItemMap()
                                        .withAdGroupId(archiveAdGroupId)
                                        .withSearchBid(MAX_BID)
                                        .withNetworkBid(MAX_BID)
                                        .withStrategyPriority(PriorityEnum.LOW)
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                capitalize(KeywordBidsSetItemMap.AD_GROUP_ID),
                                archiveAdGroupId))
                ));
    }

    @Test
    @TestCaseId("2879")
    public void trySetBidsForDeletedAdGroupID() {
        //testplan: string №36
        // https://st.yandex-team.ru/DIRECT-34097
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetItemMap()
                                        .withAdGroupId(deletedAdGroupId)
                                        .withSearchBid(MAX_BID)
                                        .withNetworkBid(MAX_BID)
                                        .withStrategyPriority(PriorityEnum.LOW)
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                capitalize(KeywordBidsSetItemMap.AD_GROUP_ID),
                                deletedAdGroupId))
                ));
    }


    @Test
    @TestCaseId("2880")
    public void trySetBidsForArchivedKeywordID() {
        //testplan: string №37
        // https://st.yandex-team.ru/DIRECT-34097
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetItemMap()
                                        .withKeywordId(archivekeywordId)
                                        .withSearchBid(MAX_BID)
                                        .withNetworkBid(MAX_BID)
                                        .withStrategyPriority(PriorityEnum.LOW)
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                capitalize(KeywordBidsSetItemMap.KEYWORD_ID),
                                archivekeywordId))
                ));
    }

    @Test
    @TestCaseId("2881")
    public void trySetBidsForArchivedAutotargetingId() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetItemMap()
                                        .withKeywordId(archiveAutotargetingId)
                                        .withSearchBid(MAX_BID)
                                        .withStrategyPriority(PriorityEnum.LOW)
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                capitalize(KeywordBidsSetItemMap.KEYWORD_ID),
                                archiveAutotargetingId))
                ));
    }

    @Test
    @TestCaseId("2882")
    public void trySetBidsForDeletedKeywordID() {
        //testplan: string №37
        // https://st.yandex-team.ru/DIRECT-34097
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetItemMap()
                                        .withKeywordId(deletedkeywordId)
                                        .withSearchBid(MAX_BID)
                                        .withNetworkBid(MAX_BID)
                                        .withStrategyPriority(PriorityEnum.LOW)
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                capitalize(KeywordBidsSetItemMap.KEYWORD_ID),
                                deletedkeywordId)))
        );
    }

    @Test
    @TestCaseId("2883")
    public void trySetBidsForDeletedAutotargetingId() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetItemMap()
                                        .withKeywordId(deletedAutotargetingId)
                                        .withSearchBid(MAX_BID)
                                        .withStrategyPriority(PriorityEnum.LOW)
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                capitalize(KeywordBidsSetItemMap.KEYWORD_ID),
                                deletedAutotargetingId)))
        );
    }

    @Test
    @TestCaseId("2884")
    public void trySetBidsForDeletedCampaignAutotargetingId() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetItemMap()
                                        .withKeywordId(deletedCampaignAutotargetingId)
                                        .withSearchBid(MAX_BID)
                                        .withStrategyPriority(PriorityEnum.LOW)
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                capitalize(KeywordBidsSetItemMap.KEYWORD_ID),
                                deletedCampaignAutotargetingId)))
        );
    }

    @Test
    @TestCaseId("2885")
    public void trySetBidsWithAdGroupIDAndKeywordID() {
        //testplan: string №34
        //DIRECT-35062
        api.userSteps.keywordBidsSteps().shouldGetErrorOnKeywordBidsSet(
                new SetRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetItemMap()
                                        .withAdGroupId(adGroupId21)
                                        .withSearchBid(MAX_BID),
                                new KeywordBidsSetItemMap()
                                        .withKeywordId(keywordId21)
                                        .withSearchBid(MAX_BID)
                        ),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(4005,
                        Api5ErrorDetails.NULL_STRING));
    }

    @Test
    @TestCaseId("2886")
    public void trySetBidsWithAdGroupIDAndCampaignID() {
        //testplan: string №34
        //DIRECT-35062
        api.userSteps.keywordBidsSteps().shouldGetErrorOnKeywordBidsSet(
                new SetRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetItemMap()
                                        .withCampaignId(campaignId2)
                                        .withSearchBid(MAX_BID),
                                new KeywordBidsSetItemMap()
                                        .withAdGroupId(adGroupId21)
                                        .withSearchBid(MAX_BID)
                        ),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(4005, Api5ErrorDetails.NULL_STRING));
    }

    @Test
    @TestCaseId("2887")
    public void trySetBidsWithKeywordIDAndCampaignID() {
        //testplan: string №34
        //DIRECT-35062
        api.userSteps.keywordBidsSteps().shouldGetErrorOnKeywordBidsSet(
                new SetRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetItemMap()
                                        .withKeywordId(keywordId21)
                                        .withSearchBid(MAX_BID),
                                new KeywordBidsSetItemMap()
                                        .withCampaignId(campaignId2)
                                        .withSearchBid(MAX_BID)
                        ),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(4005, Api5ErrorDetails.NULL_STRING));
    }

    @Test
    @TestCaseId("2888")
    public void trySetBidsWithAdGroupIDAndKeywordIDAndCampaignID() {
        //testplan: string №34
        //DIRECT-35062
        api.userSteps.keywordBidsSteps().shouldGetErrorOnKeywordBidsSet(
                new SetRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetItemMap()
                                        .withKeywordId(keywordId21)
                                        .withSearchBid(MAX_BID),
                                new KeywordBidsSetItemMap()
                                        .withAdGroupId(adGroupId21)
                                        .withSearchBid(MAX_BID),
                                new KeywordBidsSetItemMap()
                                        .withCampaignId(campaignId2)
                                        .withSearchBid(MAX_BID)
                        ),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(4005,
                        Api5ErrorDetails.NULL_STRING));
    }

    @Test
    @TestCaseId("2889")
    public void trySetBidsWithAdGroupIDAndKeywordIDAndCampaignIDInOneElement() {
        //testplan: string №32
        //DIRECT-35062 ,DIRECT-33872
        //   https://st.yandex-team.ru/DIRECT-35104
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetItemMap()
                                        .withKeywordId(keywordId21)
                                        .withSearchBid(MAX_BID)
                                        .withCampaignId(campaignId2)
                                        .withAdGroupId(adGroupId21)
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(5009, Api5ErrorDetailsJava.ONLY_ONE_OF_FIELDS_SHOULD_BE_SPECIFIED,
                                joinWithComma(
                                        path(KeywordBidsSetItemMap.KEYWORD_ID),
                                        path(KeywordBidsSetItemMap.AD_GROUP_ID),
                                        path(KeywordBidsSetItemMap.CAMPAIGN_ID))))
                ));
    }

    @Test
    @TestCaseId("2890")
    public void trySetWithoutStrategyPriorityAndBidAndContextBid() {
        //testplan: string №57
        //https://st.yandex-team.ru/DIRECT-33874
        api.as(BidsLogins.BIDS_CLIENT).userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetItemMap()
                                        .withKeywordId(keywordId11)
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(5008, Api5ErrorDetails.AT_LEAST_ONE_OF_FIELDS_SHOULD_BE_SPECIFIED,
                                joinWithComma(
                                        path(KeywordBidsSetItemMap.SEARCH_BID),
                                        path(KeywordBidsSetItemMap.NETWORK_BID),
                                        path(KeywordBidsSetItemMap.STRATEGY_PRIORITY))))
                ));
    }

    @Test
    @TestCaseId("2891")
    public void trySetBidEqual0() {
        //testplan: string №42
        // https://st.yandex-team.ru/DIRECT-33873
        api.as(BidsLogins.BIDS_CLIENT).userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetItemMap()
                                        .withKeywordId(keywordId11)
                                        .withSearchBid(0L)
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(BID_MUST_NOT_BE_LESS_NOTIFICATION));
    }

    @Test
    @TestCaseId("2892")
    public void trySetBidEqual0ForAutotargeting() {
        api.as(BidsLogins.BIDS_CLIENT).userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetItemMap()
                                        .withKeywordId(autotargetingId)
                                        .withSearchBid(0L)
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(BID_MUST_NOT_BE_LESS_NOTIFICATION));
    }

    @Test
    @TestCaseId("2893")
    public void trySetEmptyArrayOfBids() {
        //testplan: string №27
        //https://st.yandex-team.ru/DIRECT-33677
        api.userSteps.keywordBidsSteps().shouldGetErrorOnKeywordBidsSet(
                new SetRequestMap().withKeywordBids(new KeywordBidsSetItemMap(), new KeywordBidsSetItemMap()),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(5008, Api5ErrorDetailsJava.ONE_OF_FIELDS_SHOULD_BE_SPECIFIED,
                        capitalize(KeywordBidsGetItemMap.KEYWORD_ID) + ", " +
                                capitalize(KeywordBidsGetItemMap.CAMPAIGN_ID) + ", " +
                                capitalize(KeywordBidsGetItemMap.AD_GROUP_ID)));
    }


    @Test
    @TestCaseId("2894")
    public void trySetSomeValidBidsForSameKeywordId() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap().withKeywordBids(
                        new KeywordBidsSetItemMap()
                                .withKeywordId(keywordId12)
                                .withSearchBid(MAX_BID),
                        new KeywordBidsSetItemMap()
                                .withKeywordId(keywordId11)
                                .withSearchBid(MAX_BID),
                        new KeywordBidsSetItemMap()
                                .withKeywordId(keywordId11)
                                .withNetworkBid(MAX_BID)),
                BidsLogins.BIDS_CLIENT,
                new KeywordBidExpectedResult().successWithKeywordId(),
                new KeywordBidExpectedResult().errors(new Notification(9800, Api5ErrorDetailsJava.DUPLICATED_OBJECT)),
                new KeywordBidExpectedResult().errors(new Notification(9800, Api5ErrorDetailsJava.DUPLICATED_OBJECT))
        );
        GetResponse getResponse = api.userSteps.keywordBidsSteps().keywordBidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new KeywordBidsSelectionCriteriaMap().withKeywordIds(keywordId12)
                        )
                        .withFieldNames(
                                KeywordBidFieldEnum.KEYWORD_ID)
                        .withSearchFieldNames(KeywordBidSearchFieldEnum.BID),
                BidsLogins.BIDS_CLIENT
        );
        KeywordBidsGetItemMap expectedElement = new KeywordBidsGetItemMap()
                .withSearchBid(MAX_BID)
                .withKeywordId(keywordId12);
        assertThat("вернулась правильная ставка", getResponse.getKeywordBids().toArray(),
                IsApiBeanCollectionContaining.hasItems(beanDiffer(expectedElement.getBean())));
    }

    @Test
    @TestCaseId("2895")
    public void trySetBidLessThen0() {
        //testplan: string №42
        // https://st.yandex-team.ru/DIRECT-33873
        api.as(BidsLogins.BIDS_CLIENT).userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetItemMap()
                                        .withKeywordId(keywordId11)
                                        .withSearchBid(-3L)
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(BID_MUST_NOT_BE_LESS_NOTIFICATION));
    }

    @Test
    @TestCaseId("2896")
    public void trySetBidLessThen0ForAutotargeting() {
        api.as(BidsLogins.BIDS_CLIENT).userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetItemMap()
                                        .withKeywordId(autotargetingId)
                                        .withSearchBid(-3L)
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(BID_MUST_NOT_BE_LESS_NOTIFICATION));
    }

    @Test
    @TestCaseId("2897")
    public void trySetContextBidLessThen0() {
        //testplan: string №48
        // https://st.yandex-team.ru/DIRECT-33873
        api.as(BidsLogins.BIDS_CLIENT).userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetItemMap()
                                        .withKeywordId(keywordId11)
                                        .withNetworkBid(-3L)
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(CONTEXT_BID_MUST_NOT_BE_LESS_NOTIFICATION));
    }

    @Test
    @TestCaseId("2898")
    public void trySetContextBidLessThen0ForAutotargeting() {
        api.as(BidsLogins.BIDS_CLIENT).userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetItemMap()
                                        .withKeywordId(autotargetingId)
                                        .withNetworkBid(-3L)
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(CONTEXT_BID_MUST_NOT_BE_LESS_NOTIFICATION)
        );
    }

    @Test
    @TestCaseId("2899")
    public void trySetBidsNull() {
        //testplan: string №26
        //https://st.yandex-team.ru/DIRECT-33677
        api.userSteps.keywordBidsSteps().shouldGetErrorOnKeywordBidsSet(
                new SetRequestMap().withKeywordBids(new KeywordBidsSetItemMap()),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(5008, Api5ErrorDetailsJava.ONE_OF_FIELDS_SHOULD_BE_SPECIFIED,
                        capitalize(KeywordBidsGetItemMap.KEYWORD_ID) + ", " +
                                capitalize(KeywordBidsGetItemMap.CAMPAIGN_ID) + ", " +
                                capitalize(KeywordBidsGetItemMap.AD_GROUP_ID)));
    }

    @Test
    @TestCaseId("2900")
    public void trySetContextBidEqual0() {
        //testplan: string №48
        // https://st.yandex-team.ru/DIRECT-33873
        api.as(BidsLogins.BIDS_CLIENT).userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetItemMap()
                                        .withKeywordId(keywordId11)
                                        .withNetworkBid(0L)
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(CONTEXT_BID_MUST_NOT_BE_LESS_NOTIFICATION));
    }

    @Test
    @TestCaseId("2901")
    public void trySetContextBidEqual0ForAutotargeting() {
        api.as(BidsLogins.BIDS_CLIENT).userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetItemMap()
                                        .withKeywordId(autotargetingId)
                                        .withNetworkBid(0L)
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(CONTEXT_BID_MUST_NOT_BE_LESS_NOTIFICATION));
    }

    @Test
    @TestCaseId("2902")
    public void trySetOneValidAndOneWithoutRequiredFieldsBidsTest() {
        api.userSteps.keywordBidsSteps().shouldGetErrorOnBidsSet(
                new SetRequestMap().withKeywordBids(
                        new KeywordBidsSetItemMap()
                                .withKeywordId(keywordId11)
                                .withSearchBid(MAX_BID),
                        new KeywordBidsSetItemMap()
                                .withAdGroupId(adGroupId11)),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(4005, Api5ErrorDetails.NULL_STRING)
        );
    }

    @Test
    @TestCaseId("2903")
    public void trySetBidsForAnotherClientCampaignID() {
        //testplan: string №35
        // https://st.yandex-team.ru/DIRECT-34097
        // https://st.yandex-team.ru/DIRECT-35621
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetItemMap()
                                        .withCampaignId(anotherCampaignId)
                                        .withSearchBid(MAX_BID)
                                        .withNetworkBid(MAX_BID)
                                        .withStrategyPriority(PriorityEnum.LOW)
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                capitalize(KeywordBidsSetItemMap.CAMPAIGN_ID),
                                anotherCampaignId))
                ));
    }

    @Test
    @TestCaseId("2904")
    public void trySetBidsForAnotherClientAdGroupID() {
        //testplan: string №36
        // https://st.yandex-team.ru/DIRECT-34097
        // https://st.yandex-team.ru/DIRECT-35621
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetItemMap()
                                        .withAdGroupId(anotherAdGroupId)
                                        .withSearchBid(MAX_BID)
                                        .withNetworkBid(MAX_BID)
                                        .withStrategyPriority(PriorityEnum.LOW)
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                capitalize(KeywordBidsSetItemMap.AD_GROUP_ID),
                                anotherAdGroupId))
                ));
    }

    @Test
    @TestCaseId("2905")
    public void trySetBidsForAnotherClientKeywordID() {
        //testplan: string №37
        // https://st.yandex-team.ru/DIRECT-34097
        // https://st.yandex-team.ru/DIRECT-35621
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetItemMap()
                                        .withKeywordId(anotherkeywordId)
                                        .withSearchBid(MAX_BID)
                                        .withNetworkBid(MAX_BID)
                                        .withStrategyPriority(PriorityEnum.LOW)
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                capitalize(KeywordBidsSetItemMap.KEYWORD_ID),
                                anotherkeywordId))
                ));
    }

    @Test
    @TestCaseId("2906")
    public void trySetBidsForAnotherClientAutotargetingId() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetItemMap()
                                        .withKeywordId(anotherAutotargetingId)
                                        .withSearchBid(MAX_BID)
                                        .withStrategyPriority(PriorityEnum.LOW)
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                capitalize(KeywordBidsSetItemMap.KEYWORD_ID),
                                anotherAutotargetingId))
                ));
    }

    private static String joinWithComma(Path... paths) {
        return Joiner.on(", ").join(paths);
    }

}
