package ru.yandex.autotests.direct.api.keywordbids.set;

import com.yandex.direct.api.v5.keywordbids.GetResponse;
import com.yandex.direct.api.v5.keywordbids.KeywordBidFieldEnum;
import com.yandex.direct.api.v5.keywordbids.KeywordBidGetItem;
import com.yandex.direct.api.v5.keywordbids.KeywordBidNetworkFieldEnum;
import com.yandex.direct.api.v5.keywordbids.KeywordBidSearchFieldEnum;
import com.yandex.direct.api.v5.keywordbids.Network;
import com.yandex.direct.api.v5.keywordbids.Search;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.utils.matchers.IsApiBeanCollectionContaining;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidsSetItemMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.SetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by ginger on 28.07.14.
 */
@Aqua.Test
@Features(ApiFeatures.SMOKE)
public class SetSmokeTest {

    private static Long adGroupId;
    private static long keywordId;
    protected LogSteps log = LogSteps.getLogger(this.getClass());
    private static String login = BidsLogins.SUPER;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);


    @BeforeClass
    @Step("Подготовка данных для теста")
    public static void readBanner() {
        api.userSteps.clientFakeSteps().enableAPI(BidsLogins.BIDS_CLIENT);
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaignWithStrategies(
                new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                BidsLogins.BIDS_CLIENT
        );

        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, BidsLogins.BIDS_CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, BidsLogins.BIDS_CLIENT);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(BidsLogins.BIDS_CLIENT, adGroupId);
    }

    @Test
    @TestCaseId("2919")
    public void setOneValidBids() {
        //testplan: string №30
        //  https://st.yandex-team.ru/DIRECT-33871
        api.protocol(ProtocolType.SOAP).userSteps.keywordBidsSteps().keywordBidsSet(
                new SetRequestMap().withKeywordBids(
                        new KeywordBidsSetItemMap()
                                .withKeywordId(keywordId)
                                .withSearchBid(1110000L)
                                .withNetworkBid(1110000L)),
                BidsLogins.BIDS_CLIENT
        );
        GetResponse getResponse = api.userSteps.keywordBidsSteps().keywordBidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new KeywordBidsSelectionCriteriaMap().withKeywordIds(keywordId)
                        ).withFieldNames(KeywordBidFieldEnum.KEYWORD_ID)
                        .withSearchFieldNames(KeywordBidSearchFieldEnum.BID)
                        .withNetworkFieldNames(KeywordBidNetworkFieldEnum.BID),
                BidsLogins.BIDS_CLIENT
        );
        Long expectedBid = 1110000L;
        Long expectedContextBid = 1110000L;
        KeywordBidGetItem expectedElement = new KeywordBidGetItem();
        Search search = new Search();
        search.setBid(expectedBid);
        Network network = new Network();
        network.setBid(expectedContextBid);
        expectedElement.setKeywordId(keywordId);
        expectedElement.setNetwork(network);
        expectedElement.setSearch(search);
        assertThat("вернулась правильная ставка", getResponse.getKeywordBids().toArray(),
                IsApiBeanCollectionContaining.hasItems(beanDiffer(expectedElement)));

    }


}
