package ru.yandex.autotests.direct.api.keywordbids.set;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import com.yandex.direct.api.v5.general.PriorityEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.api.keywordbids.KeywordBidsFeatures;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.PhrasesStatusbssynced;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BidsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PhrasesRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidsSetItemMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.SetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.greaterThan;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by ginger on 16.10.14.
 */

@Aqua.Test
@Features(KeywordBidsFeatures.SET)
@Tag(TagDictionary.TRUNK)
@Description("Проверка изменения статусов группы и фразы после изменения ставки на поиске")
public class UpdatingStatusBsSyncAfterChangeBidTest {

    private static final Long BID1 = MoneyCurrency.get(Currency.RUB).getLongMinPrice().longValue() * 2L;
    private static final Long BID2 = BID1 * 2L;
    private static final Timestamp YESTERDAY = Timestamp.valueOf(LocalDateTime.now().minusDays(1).withNano(0));

    private static final String LOGIN = BidsLogins.BIDS_CLIENT;
    private static Long adGroupId;
    private static BidsRecord actualBidRecord;
    private static DirectJooqDbSteps dbSteps;
    private static PhrasesRecord adGroupRecord;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void addUnitsToClient() {
        dbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaignWithStrategies(
                new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                new TextCampaignNetworkStrategyAddMap().defaultServingOff()
        );
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        Long keywordId = api.userSteps.keywordsSteps()
                .addDefaultKeywordWithBidsAndStrategyPriority(adGroupId, BID1, BID1, PriorityEnum.NORMAL);

        adGroupRecord = dbSteps.adGroupsSteps().getPhrases(adGroupId)
                .setLastchange(YESTERDAY).setStatusbssynced(PhrasesStatusbssynced.Yes);
        dbSteps.adGroupsSteps().updatePhrases(adGroupRecord);
        assumeThat("группе установились ожидаемые параметры",
                dbSteps.adGroupsSteps().getPhrases(adGroupId),
                equalTo(adGroupRecord)
        );

        BidsRecord originalBidRecord = dbSteps.bidsSteps().getBidById(keywordId).setModtime(YESTERDAY);
        dbSteps.bidsSteps().updateBids(originalBidRecord);
        assumeThat("фразе установились ожидаемые параметры",
                dbSteps.bidsSteps().getBidById(keywordId),
                equalTo(originalBidRecord)
        );

        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap().withKeywordBids(
                        new KeywordBidsSetItemMap().withKeywordId(keywordId).withSearchBid(BID2)
                ),
                KeywordBidExpectedResult.successWithKeywordId()
        );

        actualBidRecord = dbSteps.bidsSteps().getBidById(keywordId);

    }

    @Test
    @TestCaseId("2923")
    public void checkAdGroups() {
        assertThat("параметры группы не обновились", dbSteps.adGroupsSteps().getPhrases(adGroupId),
                equalTo(adGroupRecord));
    }

    @Test
    @TestCaseId("2925")
    public void checkBidsModtime() {
        assertThat("у фразы обновился modtime", actualBidRecord.getModtime(), greaterThan(YESTERDAY));
    }
}
