package ru.yandex.autotests.direct.api.keywordbids.set.limit;

import java.util.Arrays;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.api.keywordbids.KeywordBidsFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidsSetItemMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.SetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by ginger on 15.09.14.
 */
@Aqua.Test
@Features(KeywordBidsFeatures.SET)
@Issue("https://st.yandex-team.ru/DIRECT-35103")
public class SetNegativeLimitTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());
    private static String login = BidsLogins.SUPER;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);
    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);
    private long keywordId;
    private Long campaignId;
    private Long adGroupId;
    private String campaignsText;
    private String adGroupsText;
    private String keywordsText;

    @Before
    @Step("Подготовка данных для теста")
    public void readBanner() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(BidsLogins.BIDS_CLIENT);
        api.userSteps.clientFakeSteps().enableAPI(BidsLogins.BIDS_CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(BidsLogins.BIDS_CLIENT);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, BidsLogins.BIDS_CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, BidsLogins.BIDS_CLIENT);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(BidsLogins.BIDS_CLIENT, adGroupId);
        // Поддержка двух локалей ru/en вручную, без ресурсов из Рукояточника
        if ("ru".equals(api.locale())) {
            campaignsText = "кампаний";
            adGroupsText = "групп объявлений";
            keywordsText = "ключевых слов";
        } else {
            campaignsText = "campaigns";
            adGroupsText = "ad groups";
            keywordsText = "keywords";
        }
    }

    @Test
    @TestCaseId("2935")
    public void trySetForMoreThanMaxAmountCampaignID() {
        //testplan: string №33
        //https://st.yandex-team.ru/DIRECT-35103
        KeywordBidsSetItemMap[] bids = new KeywordBidsSetItemMap[11];
        Arrays.fill(bids,
                new KeywordBidsSetItemMap()
                        .withCampaignId(campaignId)
                        .withSearchBid(1110000L)
        );
        api.userSteps.keywordBidsSteps().shouldGetErrorOnBidsSet(
                new SetRequestMap()
                        .withKeywordBids(bids),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(9300, Api5ErrorDetails.BIDS_SET_NO_MORE_THAN, 10, campaignsText)
        );
    }

    @Test
    @TestCaseId("2936")
    public void trySetForMoreThanMaxAmountAdGroupID() {
        //testplan: string №33
        //https://st.yandex-team.ru/DIRECT-35103
        KeywordBidsSetItemMap[] bids = new KeywordBidsSetItemMap[1001];
        Arrays.fill(bids,
                new KeywordBidsSetItemMap()
                        .withAdGroupId(adGroupId)
                        .withSearchBid(1110000L)
        );
        api.userSteps.keywordBidsSteps().shouldGetErrorOnBidsSet(
                new SetRequestMap()
                        .withKeywordBids(bids),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(9300, Api5ErrorDetails.BIDS_SET_NO_MORE_THAN, 1000, adGroupsText)
        );
    }

    @Test
    @TestCaseId("2937")
    public void trySetForMoreThanMaxAmountKeywordID() {
        //testplan: string №28
        //https://st.yandex-team.ru/DIRECT-35103
        KeywordBidsSetItemMap[] bids = new KeywordBidsSetItemMap[10001];
        Arrays.fill(bids,
                new KeywordBidsSetItemMap()
                        .withKeywordId(keywordId)
                        .withSearchBid(1110000L)
        );
        api.userSteps.keywordBidsSteps().shouldGetErrorOnBidsSet(
                new SetRequestMap()
                        .withKeywordBids(bids),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(9300, Api5ErrorDetails.BIDS_SET_NO_MORE_THAN, 10000, keywordsText)
        );
    }
}
