package ru.yandex.autotests.direct.api.keywordbids.set.limit;

import java.util.Arrays;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidsSetItemMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.SetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by ginger on 18.02.15.
 */
@Aqua.Test
@Features(ApiFeatures.NOT_REGRESSION_YET)
@Issue("https://st.yandex-team.ru/DIRECT-35103")
public class SetPositiveLimitTest {
    protected LogSteps log = LogSteps.getLogger(this.getClass());
    private static String login = BidsLogins.SUPER;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);
    private long keywordId;
    private Long campaignId;
    private Long adGroupId;

    @Before
    @Step("Подготовка данных для теста")
    public void readBanner() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(BidsLogins.BIDS_CLIENT);
        api.userSteps.clientFakeSteps().enableAPI(BidsLogins.BIDS_CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(BidsLogins.BIDS_CLIENT);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, BidsLogins.BIDS_CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, BidsLogins.BIDS_CLIENT);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(BidsLogins.BIDS_CLIENT, adGroupId);
    }

    @Test
    @TestCaseId("2938")
    public void successSetMaxAmountCampaignID() {
        //testplan: string №33
        //https://st.yandex-team.ru/DIRECT-35103
        KeywordBidsSetItemMap[] bidsWithCampaignID = new KeywordBidsSetItemMap[10];
        Arrays.fill(bidsWithCampaignID, new KeywordBidsSetItemMap()
                .withCampaignId(campaignId)
                .withSearchBid(111000L)
        );
        KeywordBidExpectedResult[] expectedResults = new KeywordBidExpectedResult[10];
        Arrays.fill(expectedResults, KeywordBidExpectedResult.errors(
                new Notification(9800, Api5ErrorDetailsJava.DUPLICATED_OBJECT)
        ));
        api.as(BidsLogins.BIDS_CLIENT).userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap()
                        .withKeywordBids(bidsWithCampaignID),
                BidsLogins.BIDS_CLIENT,
                expectedResults);
    }

    @Test
    @TestCaseId("2939")
    public void successSetMaxAmountAdGroupID() {
        //testplan: string №33
        //https://st.yandex-team.ru/DIRECT-35103
        KeywordBidsSetItemMap[] bidsWithAdGroupID = new KeywordBidsSetItemMap[1000];
        Arrays.fill(bidsWithAdGroupID, new KeywordBidsSetItemMap()
                .withAdGroupId(adGroupId)
                .withSearchBid(111000L)
        );
        KeywordBidExpectedResult[] expectedResults = new KeywordBidExpectedResult[1000];
        Arrays.fill(expectedResults, KeywordBidExpectedResult.errors(
                new Notification(9800, Api5ErrorDetailsJava.DUPLICATED_OBJECT)
        ));
        api.as(BidsLogins.BIDS_CLIENT).userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap()
                        .withKeywordBids(bidsWithAdGroupID),
                BidsLogins.BIDS_CLIENT,
                expectedResults);
    }


    @Test
    @TestCaseId("2940")
    public void successForMaxAmountKeywordID() {
        //testplan: string №33
        //https://st.yandex-team.ru/DIRECT-35103
        KeywordBidsSetItemMap[] bidsWithKeywordID = new KeywordBidsSetItemMap[10000];
        Arrays.fill(bidsWithKeywordID, new KeywordBidsSetItemMap()
                .withKeywordId(keywordId)
                .withSearchBid(1110000L));
        KeywordBidExpectedResult[] expectedResults = new KeywordBidExpectedResult[10000];
        Arrays.fill(expectedResults, KeywordBidExpectedResult.errors(
                new Notification(9800, Api5ErrorDetailsJava.DUPLICATED_OBJECT)
        ));
        api.as(BidsLogins.BIDS_CLIENT).userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap()
                        .withKeywordBids(bidsWithKeywordID),
                BidsLogins.BIDS_CLIENT,
                expectedResults);
    }
}
