package ru.yandex.autotests.direct.api.keywordbids.set.strategy;

import java.util.Arrays;
import java.util.Collection;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import com.yandex.direct.api.v5.keywordbids.GetResponse;
import com.yandex.direct.api.v5.keywordbids.KeywordBidFieldEnum;
import com.yandex.direct.api.v5.keywordbids.KeywordBidNetworkFieldEnum;
import com.yandex.direct.api.v5.keywordbids.KeywordBidSearchFieldEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.api.keywordbids.KeywordBidsFeatures;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidsGetItemMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidsSetItemMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.SetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beandiffer2.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 01.10.14.
 */

@Aqua.Test
@Features(KeywordBidsFeatures.SET)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class SetBidsManualOnSearchAndMaximumCoverageOnContextStrategyTest {

    private static final String CLIENT = BidsLogins.BIDS_CLIENT;
    private static final Long BID = MoneyCurrency.get(Currency.RUB).getLongMinPrice().longValue() * 2L;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public TextCampaignSearchStrategyAddMap searchStrategy;

    private Long campaignID;
    private long keywordId;
    private Long autoTargetingId;

    @Parameterized.Parameters(name = "{0}")
    public static Collection data() {
        return Arrays.asList(new Object[][]{
                {"HIGHEST_POSITION + MAXIMUM_COVERAGE",
                        new TextCampaignSearchStrategyAddMap().defaultHighestPosition()},
        });
    }


    @Before
    @Step("Подготовка данных для теста")
    public void createData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaignWithStrategies(
                searchStrategy,
                new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage()
        );
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        autoTargetingId = api.userSteps.keywordsSteps().addAutotargeting(adGroupId);
        api.protocol(ProtocolType.SOAP);
    }

    @Test
    @TestCaseId("2943")
    public void setBidTest() {
        api.as(BidsLogins.BIDS_CLIENT).userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetItemMap()
                                        .withCampaignId(campaignID)
                                        .withSearchBid(BID)
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.successWithCampaignId()
        );

        GetResponse getResponse = api.userSteps.keywordBidsSteps().keywordBidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new KeywordBidsSelectionCriteriaMap().withCampaignIds(campaignID)
                        )
                        .withFieldNames(KeywordBidFieldEnum.KEYWORD_ID)
                        .withSearchFieldNames(KeywordBidSearchFieldEnum.BID)
        );
        assertThat("получили правильные значения Bid",
                getResponse.getKeywordBids(),
                beanDifferV5(
                        Arrays.asList(
                                new KeywordBidsGetItemMap().withKeywordId(keywordId).withSearchBid(BID).getBean(),
                                new KeywordBidsGetItemMap().withKeywordId(autoTargetingId).withSearchBid(BID).getBean()
                        )
                )
        );
    }

    @Test
    @TestCaseId("2944")
    public void setContextBidTest() {
        api.as(BidsLogins.BIDS_CLIENT).userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSet(
                new SetRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetItemMap()
                                        .withCampaignId(campaignID)
                                        .withNetworkBid(BID)
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.successWithCampaignId()
        );
        GetResponse getResponse = api.userSteps.keywordBidsSteps().keywordBidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new KeywordBidsSelectionCriteriaMap().withCampaignIds(campaignID)
                        )
                        .withFieldNames(KeywordBidFieldEnum.KEYWORD_ID).withNetworkFieldNames(
                        KeywordBidNetworkFieldEnum.BID)
        );
        assertThat("получили правильные значения Bid",
                getResponse.getKeywordBids(),
                beanDifferV5(
                        Arrays.asList(
                                new KeywordBidsGetItemMap().withKeywordId(keywordId).withNetworkBid(BID).getBean(),
                                new KeywordBidsGetItemMap().withKeywordId(autoTargetingId).withNetworkBid(BID).getBean()
                        )
                )
        );
    }

}
