package ru.yandex.autotests.direct.api.keywordbids.setauto;

import com.yandex.direct.api.v5.keywordbids.GetResponse;
import com.yandex.direct.api.v5.keywordbids.KeywordBidFieldEnum;
import com.yandex.direct.api.v5.keywordbids.KeywordBidGetItem;
import com.yandex.direct.api.v5.keywordbids.KeywordBidNetworkFieldEnum;
import com.yandex.direct.api.v5.keywordbids.KeywordBidSearchFieldEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import ru.yandex.qatools.allure.annotations.TestCaseId;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.api.keywordbids.KeywordBidsFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidsSetAutoItemMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.NetworkByCoverageBiddingRule;
import ru.yandex.autotests.directapi.model.api5.keywordbids.SearchByTrafficVolumeBiddingRule;
import ru.yandex.autotests.directapi.model.api5.keywordbids.SetAutoBiddingRule;
import ru.yandex.autotests.directapi.model.api5.keywordbids.SetAutoRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(KeywordBidsFeatures.SET_AUTO)
@Description("Тесты на проверку округления ставок")
public class SetAutoBidRoundingTest {

    protected LogSteps log = LogSteps.getLogger(this.getClass());

    private static final String LOGIN = BidsLogins.SUPER;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    private static long keywordId;

    @BeforeClass
    @Step("Подготовка данных для теста")
    @SuppressWarnings("Duplicates")
    public static void readBanner() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(BidsLogins.BIDS_CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaignWithStrategies(
                new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                BidsLogins.BIDS_CLIENT
        );
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, BidsLogins.BIDS_CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, BidsLogins.BIDS_CLIENT);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(BidsLogins.BIDS_CLIENT, adGroupId);
    }

    @Test
    @TestCaseId("3097")
    public void setAutoNetworkBidRoundUpTest() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new SetAutoRequestMap().withKeywordBids(
                        new KeywordBidsSetAutoItemMap()
                                .withKeywordId(keywordId)
                                .withBiddingRule(new SetAutoBiddingRule()
                                        .withNetworkByCoverage(new NetworkByCoverageBiddingRule()
                                                .withTargetCoverage(100)
                                                .withBidCeiling(305000L)))
                ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.successWithKeywordId()
        );

        GetResponse response = api.clientLogin(BidsLogins.BIDS_CLIENT).userSteps.keywordBidsSteps().keywordBidsGet(
                new GetRequestMap().withSelectionCriteria(
                        new KeywordBidsSelectionCriteriaMap().withKeywordIds(keywordId))
                        .withFieldNames(KeywordBidFieldEnum.KEYWORD_ID)
                        .withNetworkFieldNames(KeywordBidNetworkFieldEnum.BID));

        assumeThat("Должен вернуться один элемент", response.getKeywordBids(), hasSize(1));
        KeywordBidGetItem responseItem = response.getKeywordBids().get(0);

        assertThat("Ставка должна округлиться вверх", responseItem.getNetwork().getBid(), is(310000L));
    }

    @Test
    @TestCaseId("3098")
    public void setAutoNetworkBidRoundDownTest() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new SetAutoRequestMap().withKeywordBids(
                        new KeywordBidsSetAutoItemMap()
                                .withKeywordId(keywordId)
                                .withBiddingRule(new SetAutoBiddingRule()
                                        .withNetworkByCoverage(new NetworkByCoverageBiddingRule()
                                                .withTargetCoverage(100)
                                                .withBidCeiling(304999L)))
                ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.successWithKeywordId()
        );

        GetResponse response = api.clientLogin(BidsLogins.BIDS_CLIENT).userSteps.keywordBidsSteps().keywordBidsGet(
                new GetRequestMap().withSelectionCriteria(
                        new KeywordBidsSelectionCriteriaMap().withKeywordIds(keywordId))
                        .withFieldNames(KeywordBidFieldEnum.KEYWORD_ID)
                        .withNetworkFieldNames(KeywordBidNetworkFieldEnum.BID));

        assumeThat("Должен вернуться один элемент", response.getKeywordBids(), hasSize(1));
        KeywordBidGetItem responseItem = response.getKeywordBids().get(0);

        assertThat("Ставка должна округлиться вниз", responseItem.getNetwork().getBid(), is(300000L));
    }

    @Test
    @TestCaseId("3099")
    public void setAutoSearchBidRoundUpTest() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new SetAutoRequestMap().withKeywordBids(
                        new KeywordBidsSetAutoItemMap()
                                .withKeywordId(keywordId)
                                .withBiddingRule(new SetAutoBiddingRule()
                                        .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                .withBidCeiling(305000L)
                                                .withTargetTrafficVolume(100)))
                ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.successWithKeywordId()
        );

        GetResponse response = api.clientLogin(BidsLogins.BIDS_CLIENT).userSteps.keywordBidsSteps().keywordBidsGet(
                new GetRequestMap().withSelectionCriteria(
                        new KeywordBidsSelectionCriteriaMap().withKeywordIds(keywordId))
                        .withFieldNames(KeywordBidFieldEnum.KEYWORD_ID)
                        .withSearchFieldNames(KeywordBidSearchFieldEnum.BID));

        assumeThat("Должен вернуться один элемент", response.getKeywordBids(), hasSize(1));
        KeywordBidGetItem responseItem = response.getKeywordBids().get(0);

        assertThat("Ставка должна округлиться вверх", responseItem.getSearch().getBid(), is(310000L));
    }

    @Test
    @TestCaseId("3100")
    public void setAutoSearchBidRoundDownTest() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new SetAutoRequestMap().withKeywordBids(
                        new KeywordBidsSetAutoItemMap()
                                .withKeywordId(keywordId)
                                .withBiddingRule(new SetAutoBiddingRule()
                                        .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                .withBidCeiling(304999L)
                                                .withTargetTrafficVolume(100)))
                ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.successWithKeywordId()
        );

        GetResponse response = api.clientLogin(BidsLogins.BIDS_CLIENT).userSteps.keywordBidsSteps().keywordBidsGet(
                new GetRequestMap().withSelectionCriteria(
                        new KeywordBidsSelectionCriteriaMap().withKeywordIds(keywordId))
                        .withFieldNames(KeywordBidFieldEnum.KEYWORD_ID)
                        .withSearchFieldNames(KeywordBidSearchFieldEnum.BID));

        assumeThat("Должен вернуться один элемент", response.getKeywordBids(), hasSize(1));
        KeywordBidGetItem responseItem = response.getKeywordBids().get(0);

        assertThat("Ставка должна округлиться вниз", responseItem.getSearch().getBid(), is(300000L));
    }
}
