package ru.yandex.autotests.direct.api.keywordbids.setauto;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import com.yandex.direct.api.v5.keywordbids.GetResponse;
import com.yandex.direct.api.v5.keywordbids.KeywordBidFieldEnum;
import com.yandex.direct.api.v5.keywordbids.KeywordBidNetworkFieldEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.api.bids.setauto.SetAutoFormulaForComputationContextBidText;
import ru.yandex.autotests.direct.api.keywordbids.KeywordBidsFeatures;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidsSetAutoItemMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.NetworkByCoverageBiddingRule;
import ru.yandex.autotests.directapi.model.api5.keywordbids.SetAutoBiddingRule;
import ru.yandex.autotests.directapi.model.api5.keywordbids.SetAutoRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.TestSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ch.lambdaj.Lambda.on;
import static ch.lambdaj.Lambda.sort;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Повторение тестов на установку ставки в сетях из Bids.setAuto
 *
 * @see SetAutoFormulaForComputationContextBidText
 */
@Aqua.Test
@Features(KeywordBidsFeatures.SET_AUTO)
@Tag(TagDictionary.TRUNK)
public class SetAutoFormulaForComputationContextBidTest {
    private static final Long MAX_BID = MoneyCurrency.get(Currency.RUB).getLongMaxPrice().longValue();
    private static final Long MAX_SET_AUTO_BID = MAX_BID / 2L;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static long keywordId;

    @Rule
    public Trashman trasher = new Trashman(api);

    private static List<Integer> contextCoverages = Arrays.asList(1, 50, 100);
    private static List<Integer> increasePercents = Arrays.asList(0, 500, 1000);

    @BeforeClass
    @Step("Подготовка данных для теста")
    public static void readBanner() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(BidsLogins.BIDS_CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaignWithStrategies(
                new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                BidsLogins.BIDS_CLIENT
        );
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, BidsLogins.BIDS_CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, BidsLogins.BIDS_CLIENT);
        keywordId = api.userSteps.keywordsSteps().addDefaultKeyword(BidsLogins.BIDS_CLIENT, adGroupId);
    }

    @Test
    @TestCaseId("2964")
    public void computationContextBidChangingContextCoverageTest() {
        List<Long> contextBids = new ArrayList<>();
        for (int contextCoverage : contextCoverages) {
            api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                    new SetAutoRequestMap()
                            .withKeywordBids(
                                    new KeywordBidsSetAutoItemMap()
                                            .withKeywordId(keywordId)
                                            .withBiddingRule(new SetAutoBiddingRule()
                                                    .withNetworkByCoverage(new NetworkByCoverageBiddingRule()
                                                            .withTargetCoverage(contextCoverage)
                                                            .withIncreasePercent(350)
                                                            .withBidCeiling(MAX_SET_AUTO_BID)))
                            ),
                    BidsLogins.BIDS_CLIENT,
                    KeywordBidExpectedResult.successWithKeywordId());
            GetResponse getResponse = api.userSteps.keywordBidsSteps().keywordBidsGet(
                    new GetRequestMap()
                            .withSelectionCriteria(new KeywordBidsSelectionCriteriaMap()
                                    .withKeywordIds(keywordId))
                            .withFieldNames(KeywordBidFieldEnum.KEYWORD_ID)
                            .withNetworkFieldNames(KeywordBidNetworkFieldEnum.BID),
                    BidsLogins.BIDS_CLIENT
            );
            contextBids.add(getResponse.getKeywordBids().get(0).getNetwork().getBid());
        }
        List<Long> sortedContextBids = sort(contextBids, on(Long.class));
        assertThat("Функция расчёта ContextBid по параметру ContextCoverage не убывает",
                contextBids, equalTo(sortedContextBids));
    }

    @Test
    @TestCaseId("2965")
    public void computationContextBidChangingIncreasePercentTest() {
        List<Long> contextBids = new ArrayList<>();
        for (int increasePercent : increasePercents) {
            api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                    new SetAutoRequestMap()
                            .withKeywordBids(
                                    new KeywordBidsSetAutoItemMap()
                                            .withKeywordId(keywordId)
                                            .withBiddingRule(new SetAutoBiddingRule()
                                                    .withNetworkByCoverage(new NetworkByCoverageBiddingRule()
                                                            .withTargetCoverage(35)
                                                            .withIncreasePercent(increasePercent)
                                                            .withBidCeiling(MAX_SET_AUTO_BID)))
                            ),
                    BidsLogins.BIDS_CLIENT,
                    KeywordBidExpectedResult.successWithKeywordId());
            GetResponse getResponse = api.userSteps.keywordBidsSteps().keywordBidsGet(
                    new GetRequestMap()
                            .withSelectionCriteria(new KeywordBidsSelectionCriteriaMap()
                                    .withKeywordIds(keywordId))
                            .withFieldNames(KeywordBidFieldEnum.KEYWORD_ID)
                            .withNetworkFieldNames(KeywordBidNetworkFieldEnum.BID),
                    BidsLogins.BIDS_CLIENT
            );
            contextBids.add(getResponse.getKeywordBids().get(0).getNetwork().getBid());
        }
        List<Long> sortedContextBids = sort(contextBids, on(Long.class));
        TestSteps.assertThat("функция расчёта ContextBid по параметру IncreasePercent не убывает",
                contextBids, equalTo(sortedContextBids));
    }

}
