package ru.yandex.autotests.direct.api.keywordbids.setauto;

import com.google.common.base.Joiner;
import org.apache.commons.lang3.StringUtils;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.api.keywordbids.KeywordBidsFeatures;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.money.MoneyFormat;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidsSetAutoItemMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.NetworkByCoverageBiddingRule;
import ru.yandex.autotests.directapi.model.api5.keywordbids.SearchByTrafficVolumeBiddingRule;
import ru.yandex.autotests.directapi.model.api5.keywordbids.SetAutoBiddingRule;
import ru.yandex.autotests.directapi.model.api5.keywordbids.SetAutoRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;
import static ru.yandex.autotests.directapi.model.Logins.SUPER_LOGIN;
import static ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidsSetAutoItemMap.BIDDING_RULE;

@Aqua.Test
@Features(KeywordBidsFeatures.SET_AUTO)
@Tag(TagDictionary.TRUNK)
public class SetAutoNegativeTest {

    private static Long campaignId;
    private static Long adGroupId;
    private static long keywordId1;
    private static long keywordId2;
    private static Long anotherCampaignId;
    private static Long anotherAdGroupId;
    private static long anotherKeywordId;
    private static Long archiveCampaignId;
    private static long deletedKeywordId;
    private static Long deletedCampaignId;
    private static Long archiveAdGroupId;
    private static long archiveKeywordId;
    private static Long deletedAdGroupId;

    private static final String CLIENT = BidsLogins.BIDS_CLIENT;
    private static final String ANOTHER_CLIENT = BidsLogins.BIDS_ANOTHER_CLIENT;
    private static final Long MAX_BID = MoneyCurrency.get(Currency.RUB).getLongMaxPrice().longValue();
    private static final Long MAX_SET_AUTO_BID = MAX_BID / 2L;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(SUPER_LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);


    @BeforeClass
    @Step("Подготовка данных для теста")
    public static void readBanner() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(BidsLogins.BIDS_CLIENT);
        api.userSteps.clientFakeSteps().enableAPI(BidsLogins.BIDS_CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, CLIENT);
        keywordId1 = api.userSteps.keywordsSteps().addDefaultKeyword(CLIENT, adGroupId);
        keywordId2 = api.userSteps.keywordsSteps().addDefaultKeyword(CLIENT, adGroupId);

        //Чужая кампания
        anotherCampaignId =
                api.as(Logins.SUPER_LOGIN).userSteps.campaignSteps().addDefaultTextCampaign(ANOTHER_CLIENT);
        anotherAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(anotherCampaignId, ANOTHER_CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(anotherAdGroupId, ANOTHER_CLIENT);
        anotherKeywordId = api.userSteps.keywordsSteps().addDefaultKeyword(ANOTHER_CLIENT, anotherAdGroupId);

        //Архивная кампания
        archiveCampaignId =
                api.as(Logins.SUPER_LOGIN).userSteps.campaignSteps().addDefaultTextCampaign(ANOTHER_CLIENT);
        archiveAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(archiveCampaignId, ANOTHER_CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(archiveAdGroupId, ANOTHER_CLIENT);
        archiveKeywordId = api.userSteps.keywordsSteps().addDefaultKeyword(ANOTHER_CLIENT, archiveAdGroupId);
        api.userSteps.campaignSteps().campaignsSuspend(ANOTHER_CLIENT, archiveCampaignId);
        api.userSteps.campaignSteps().campaignsArchive(ANOTHER_CLIENT, archiveCampaignId);

        //Удаленная кампания
        deletedCampaignId =
                api.as(Logins.SUPER_LOGIN).userSteps.campaignSteps().addDefaultTextCampaign(CLIENT);
        deletedAdGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(deletedCampaignId, CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(deletedAdGroupId, CLIENT);
        deletedKeywordId = api.userSteps.keywordsSteps().addDefaultKeyword(CLIENT, deletedAdGroupId);
        api.userSteps.campaignSteps().campaignsDelete(CLIENT, deletedCampaignId);
        api.protocol(ProtocolType.SOAP);
    }

    @Test
    @TestCaseId("2968")
    public void trySetAutoNullParams() {
        api.userSteps.keywordBidsSteps().shouldGetErrorOnBidsSetAuto(
                new SetAutoRequestMap(),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        path(SetAutoRequestMap.KEYWORD_BIDS))
        );

    }

    @Test
    @TestCaseId("2999")
    public void trySetAutoNullBiddingRule() {
        api.userSteps.keywordBidsSteps().shouldGetErrorOnBidsSetAuto(
                new SetAutoRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetAutoItemMap()
                        ),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.IN_ELEMENT_OF_ARRAY_MISSING_REQUIRED_FIELD,
                        path(SetAutoRequestMap.KEYWORD_BIDS),
                        path(KeywordBidsSetAutoItemMap.BIDDING_RULE))
        );
    }

    @Test
    @TestCaseId("3000")
    public void trySetAutoEmptyBiddingRule() {
        api.userSteps.keywordBidsSteps().shouldGetErrorOnBidsSetAuto(
                new SetAutoRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetAutoItemMap()
                        ),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.IN_ELEMENT_OF_ARRAY_MISSING_REQUIRED_FIELD,
                        path(SetAutoRequestMap.KEYWORD_BIDS),
                        path(KeywordBidsSetAutoItemMap.BIDDING_RULE))
        );
    }

    @Test
    @TestCaseId("2969")
    public void trySetAutoWithEmptyArray() {
        api.userSteps.keywordBidsSteps().shouldGetErrorOnBidsSetAuto(
                new SetAutoRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetAutoItemMap(),
                                new KeywordBidsSetAutoItemMap(),
                                new KeywordBidsSetAutoItemMap()
                        ),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.IN_ELEMENT_OF_ARRAY_MISSING_REQUIRED_FIELD,
                        path(SetAutoRequestMap.KEYWORD_BIDS),
                        path(KeywordBidsSetAutoItemMap.BIDDING_RULE))
        );
    }

    @Test
    @TestCaseId("2970")
    public void trySetAutoOneInvalidBids() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetAutoItemMap()
                                        .withKeywordId(-1L)
                                        .withBiddingRule(new SetAutoBiddingRule()
                                                .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                        .withTargetTrafficVolume(10)))
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(5005, Api5ErrorDetailsJava.FIELD_MUST_BE_POSITIVE_INTEGER,
                                path(KeywordBidsSetAutoItemMap.KEYWORD_ID)))
                ));
    }

    @Test
    @TestCaseId("2971")
    public void trySetAutoBidsForArchivedCampaignID() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetAutoItemMap()
                                        .withCampaignId(archiveCampaignId)
                                        .withBiddingRule(new SetAutoBiddingRule()
                                                .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                        .withTargetTrafficVolume(10)
                                                        .withIncreasePercent(50)
                                                        .withBidCeiling(MAX_SET_AUTO_BID)))
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                path(KeywordBidsSetAutoItemMap.CAMPAIGN_ID),
                                archiveCampaignId))
                ));
    }

    @Test
    @TestCaseId("2972")
    public void trySetAutoBidsForDeletedCampaignID() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetAutoItemMap()
                                        .withCampaignId(deletedCampaignId)
                                        .withBiddingRule(new SetAutoBiddingRule()
                                                .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                        .withTargetTrafficVolume(10)
                                                        .withIncreasePercent(50)
                                                        .withBidCeiling(MAX_SET_AUTO_BID)))
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                path(KeywordBidsSetAutoItemMap.CAMPAIGN_ID),
                                deletedCampaignId))
                ));
    }

    @Test
    @TestCaseId("2973")
    public void trySetAutoBidsForArchivedAdGroupID() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetAutoItemMap()
                                        .withAdGroupId(archiveAdGroupId)
                                        .withBiddingRule(new SetAutoBiddingRule()
                                                .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                        .withTargetTrafficVolume(10)
                                                        .withIncreasePercent(50)
                                                        .withBidCeiling(MAX_SET_AUTO_BID)))
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                path(KeywordBidsSetAutoItemMap.AD_GROUP_ID),
                                archiveAdGroupId))
                ));
    }

    @Test
    @TestCaseId("2974")
    public void trySetAutoBidsForDeletedAdGroupID() {
        //testplan: string №73
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetAutoItemMap()
                                        .withAdGroupId(deletedAdGroupId)
                                        .withBiddingRule(new SetAutoBiddingRule()
                                                .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                        .withTargetTrafficVolume(10)
                                                        .withIncreasePercent(50)
                                                        .withBidCeiling(MAX_SET_AUTO_BID)))
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                path(KeywordBidsSetAutoItemMap.AD_GROUP_ID),
                                deletedAdGroupId))
                ));
    }


    @Test
    @TestCaseId("2975")
    public void trySetAutoBidsForArchivedKeywordID() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetAutoItemMap()
                                        .withKeywordId(archiveKeywordId)
                                        .withBiddingRule(new SetAutoBiddingRule()
                                                .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                        .withTargetTrafficVolume(10)
                                                        .withIncreasePercent(50)
                                                        .withBidCeiling(MAX_SET_AUTO_BID)))
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                path(KeywordBidsSetAutoItemMap.KEYWORD_ID),
                                archiveKeywordId))
                ));
    }

    @Test
    @TestCaseId("2976")
    public void trySetAutoBidsForDeletedKeywordID() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetAutoItemMap()
                                        .withKeywordId(deletedKeywordId)
                                        .withBiddingRule(new SetAutoBiddingRule()
                                                .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                        .withTargetTrafficVolume(10)
                                                        .withIncreasePercent(50)
                                                        .withBidCeiling(MAX_SET_AUTO_BID)))
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                path(KeywordBidsSetAutoItemMap.KEYWORD_ID),
                                deletedKeywordId))
                ));
    }

    @Test
    @TestCaseId("2977")
    public void trySetAutoBidsWithAdGroupIDAndKeywordID() {
        api.userSteps.keywordBidsSteps().shouldGetErrorOnBidsSetAuto(
                new SetAutoRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetAutoItemMap()
                                        .withKeywordId(keywordId1)
                                        .withBiddingRule(new SetAutoBiddingRule()
                                                .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                        .withTargetTrafficVolume(10)
                                                        .withIncreasePercent(50)
                                                        .withBidCeiling(MAX_SET_AUTO_BID))),
                                new KeywordBidsSetAutoItemMap()
                                        .withAdGroupId(adGroupId)
                                        .withBiddingRule(new SetAutoBiddingRule()
                                                .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                        .withTargetTrafficVolume(10)
                                                        .withIncreasePercent(50)
                                                        .withBidCeiling(MAX_SET_AUTO_BID)))
                        ),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(4005,
                        Api5ErrorDetails.NULL_STRING));
    }

    @Test
    @TestCaseId("2978")
    public void trySetAutoBidsWithAdGroupIDAndCampaignID() {
        api.userSteps.keywordBidsSteps().shouldGetErrorOnBidsSetAuto(
                new SetAutoRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetAutoItemMap()
                                        .withCampaignId(campaignId)
                                        .withBiddingRule(new SetAutoBiddingRule()
                                                .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                        .withTargetTrafficVolume(10)
                                                        .withIncreasePercent(50)
                                                        .withBidCeiling(MAX_SET_AUTO_BID))),
                                new KeywordBidsSetAutoItemMap()
                                        .withAdGroupId(adGroupId)
                                        .withBiddingRule(new SetAutoBiddingRule()
                                                .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                        .withTargetTrafficVolume(10)
                                                        .withIncreasePercent(50)
                                                        .withBidCeiling(MAX_SET_AUTO_BID)))
                        ),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(4005,
                        Api5ErrorDetails.NULL_STRING));
    }

    @Test
    @TestCaseId("2979")
    public void trySetAutoBidsWithKeywordIDAndCampaignID() {
        api.userSteps.keywordBidsSteps().shouldGetErrorOnBidsSetAuto(
                new SetAutoRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetAutoItemMap()
                                        .withKeywordId(keywordId1)
                                        .withBiddingRule(new SetAutoBiddingRule()
                                                .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                        .withTargetTrafficVolume(10)
                                                        .withIncreasePercent(50)
                                                        .withBidCeiling(MAX_SET_AUTO_BID))),
                                new KeywordBidsSetAutoItemMap()
                                        .withCampaignId(campaignId)
                                        .withBiddingRule(new SetAutoBiddingRule()
                                                .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                        .withTargetTrafficVolume(10)
                                                        .withIncreasePercent(50)
                                                        .withBidCeiling(MAX_SET_AUTO_BID)))
                        ),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(4005,
                        Api5ErrorDetails.NULL_STRING));
    }

    @Test
    @TestCaseId("2980")
    public void trySetAutoBidsWithAdGroupIDAndKeywordIDAndCampaignID() {
        api.userSteps.keywordBidsSteps().shouldGetErrorOnBidsSetAuto(
                new SetAutoRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetAutoItemMap()
                                        .withKeywordId(keywordId1)
                                        .withBiddingRule(new SetAutoBiddingRule()
                                                .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                        .withTargetTrafficVolume(10)
                                                        .withIncreasePercent(50)
                                                        .withBidCeiling(MAX_SET_AUTO_BID))),
                                new KeywordBidsSetAutoItemMap()
                                        .withAdGroupId(adGroupId)
                                        .withBiddingRule(new SetAutoBiddingRule()
                                                .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                        .withTargetTrafficVolume(10)
                                                        .withIncreasePercent(50)
                                                        .withBidCeiling(MAX_SET_AUTO_BID))),
                                new KeywordBidsSetAutoItemMap()
                                        .withCampaignId(campaignId)
                                        .withBiddingRule(new SetAutoBiddingRule()
                                                .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                        .withTargetTrafficVolume(10)
                                                        .withIncreasePercent(50)
                                                        .withBidCeiling(MAX_SET_AUTO_BID)))
                        ),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(4005,
                        Api5ErrorDetails.NULL_STRING));
    }

    @Test
    @TestCaseId("2981")
    public void trySetAutoBidsWithAdGroupIDAndKeywordIDAndCampaignIDInOneElement() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetAutoItemMap()
                                        .withKeywordId(keywordId1)
                                        .withCampaignId(campaignId)
                                        .withAdGroupId(adGroupId)
                                        .withBiddingRule(new SetAutoBiddingRule()
                                                .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                        .withTargetTrafficVolume(10)
                                                        .withIncreasePercent(50)
                                                        .withBidCeiling(MAX_SET_AUTO_BID)))
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(5009, Api5ErrorDetailsJava.ONLY_ONE_OF_FIELDS_SHOULD_BE_SPECIFIED,
                                Joiner.on(", ").join(
                                        path(KeywordBidsSetAutoItemMap.KEYWORD_ID),
                                        path(KeywordBidsSetAutoItemMap.AD_GROUP_ID),
                                        path(KeywordBidsSetAutoItemMap.CAMPAIGN_ID))))
                ));
    }

    @Test
    @TestCaseId("2982")
    public void trySetAutoBidsWithInvalidMaxBid() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetAutoItemMap()
                                        .withKeywordId(keywordId1)
                                        .withBiddingRule(new SetAutoBiddingRule()
                                                .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                        .withTargetTrafficVolume(10)
                                                        .withIncreasePercent(50)
                                                        .withBidCeiling(-1000000L)))
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_LESS,
                                path(SearchByTrafficVolumeBiddingRule.BID_CEILING),
                                (MoneyCurrency.get(Currency.RUB).getNamePluralI(api.locale())),
                                MoneyCurrency.get(Currency.RUB).getLongMinPrice().stringValue(MoneyFormat.INTEGER))
                        )));
    }

    @Test
    @TestCaseId("3025")
    public void trySetAutoBidsWithInvalidMaxBidForNetwork() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetAutoItemMap()
                                        .withKeywordId(keywordId1)
                                        .withBiddingRule(new SetAutoBiddingRule()
                                                .withNetworkByCoverage(new NetworkByCoverageBiddingRule()
                                                        .withTargetCoverage(3)
                                                        .withIncreasePercent(50)
                                                        .withBidCeiling(-1000000L)))
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_LESS,
                                path(NetworkByCoverageBiddingRule.BID_CEILING),
                                (MoneyCurrency.get(Currency.RUB).getNamePluralI(api.locale())),
                                MoneyCurrency.get(Currency.RUB).getLongMinPrice().stringValue(MoneyFormat.INTEGER))
                        )));
    }

    @Test
    @TestCaseId("2983")
    public void trySetAutoBidsWithMaxBidEqual0() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetAutoItemMap()
                                        .withKeywordId(keywordId1)
                                        .withBiddingRule(new SetAutoBiddingRule()
                                                .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                        .withTargetTrafficVolume(10)
                                                        .withIncreasePercent(50)
                                                        .withBidCeiling(0L)))
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_LESS,
                                path(SearchByTrafficVolumeBiddingRule.BID_CEILING),
                                (MoneyCurrency.get(Currency.RUB).getNamePluralI(api.locale())),
                                MoneyCurrency.get(Currency.RUB).getLongMinPrice().stringValue(MoneyFormat.INTEGER)))
                ));
    }

    @Test
    @TestCaseId("3026")
    public void trySetAutoBidsWithMaxBidEqual0ForNetwork() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetAutoItemMap()
                                        .withKeywordId(keywordId1)
                                        .withBiddingRule(new SetAutoBiddingRule()
                                                .withNetworkByCoverage(new NetworkByCoverageBiddingRule()
                                                        .withTargetCoverage(3)
                                                        .withIncreasePercent(50)
                                                        .withBidCeiling(0L)))
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_LESS,
                                path(NetworkByCoverageBiddingRule.BID_CEILING),
                                (MoneyCurrency.get(Currency.RUB).getNamePluralI(api.locale())),
                                MoneyCurrency.get(Currency.RUB).getLongMinPrice().stringValue(MoneyFormat.INTEGER)))
                ));
    }

    @Test
    @TestCaseId("2984")
    public void trySetAutoBidsWithMaxBidMoreThanMax() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetAutoItemMap()
                                        .withKeywordId(keywordId1)
                                        .withBiddingRule(new SetAutoBiddingRule()
                                                .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                        .withTargetTrafficVolume(10)
                                                        .withIncreasePercent(50)
                                                        .withBidCeiling(MAX_BID + 100000L)))
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(5005, Api5ErrorDetails.BID_VALUE_IN_FIELD_MUST_NOT_BE_MORE,
                                path(SearchByTrafficVolumeBiddingRule.BID_CEILING),
                                (MoneyCurrency.get(Currency.RUB).getNamePluralI(api.locale())),
                                MoneyCurrency.get(Currency.RUB).getLongMaxPrice().stringValue(MoneyFormat.INTEGER)))
                ));
    }

    @Test
    @TestCaseId("2995")
    public void trySetAutoWithSearchIncreasePercentLess0() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new SetAutoRequestMap().withKeywordBids(
                        new KeywordBidsSetAutoItemMap()
                                .withAdGroupId(adGroupId)
                                .withBiddingRule(new SetAutoBiddingRule()
                                        .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                .withTargetTrafficVolume(10)
                                                .withIncreasePercent(-1)
                                                .withBidCeiling(MAX_SET_AUTO_BID)))
                ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(5005, Api5ErrorDetailsJava.FIELD_MUST_BE_IN_RANGE_FROM_TO,
                                path(KeywordBidsSetAutoItemMap.BIDDING_RULE,
                                        SetAutoBiddingRule.SEARCH_BY_TRAFFIC_VOLUME,
                                        SearchByTrafficVolumeBiddingRule.INCREASE_PERCENT),
                                0, 1000))
                ));
    }

    @Test
    @TestCaseId("2996")
    public void trySetAutoWithNetworkIncreasePercentLess0() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new SetAutoRequestMap().withKeywordBids(
                        new KeywordBidsSetAutoItemMap()
                                .withAdGroupId(adGroupId)
                                .withBiddingRule(new SetAutoBiddingRule()
                                        .withNetworkByCoverage(new NetworkByCoverageBiddingRule()
                                                .withTargetCoverage(3)
                                                .withIncreasePercent(-1)
                                                .withBidCeiling(MAX_SET_AUTO_BID)))
                ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(5005, Api5ErrorDetailsJava.FIELD_MUST_BE_IN_RANGE_FROM_TO,
                                path(KeywordBidsSetAutoItemMap.BIDDING_RULE,
                                        SetAutoBiddingRule.NETWORK_BY_COVERAGE,
                                        NetworkByCoverageBiddingRule.INCREASE_PERCENT),
                                0, 1000))
                ));
    }

    @Test
    @TestCaseId("2997")
    public void trySetAutoWithInvalidSearchIncreasePercent() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new SetAutoRequestMap().withKeywordBids(
                        new KeywordBidsSetAutoItemMap()
                                .withAdGroupId(adGroupId)
                                .withBiddingRule(new SetAutoBiddingRule()
                                        .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                .withTargetTrafficVolume(10)
                                                .withIncreasePercent(1001)
                                                .withBidCeiling(MAX_SET_AUTO_BID)))
                ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(5005, Api5ErrorDetailsJava.FIELD_MUST_BE_IN_RANGE_FROM_TO,
                                path(KeywordBidsSetAutoItemMap.BIDDING_RULE,
                                        SetAutoBiddingRule.SEARCH_BY_TRAFFIC_VOLUME,
                                        SearchByTrafficVolumeBiddingRule.INCREASE_PERCENT),
                                0, 1000))
                ));
    }

    @Test
    @TestCaseId("2998")
    public void trySetAutoWithInvalidNetworkIncreasePercent() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new SetAutoRequestMap().withKeywordBids(
                        new KeywordBidsSetAutoItemMap()
                                .withAdGroupId(adGroupId)
                                .withBiddingRule(new SetAutoBiddingRule()
                                        .withNetworkByCoverage(new NetworkByCoverageBiddingRule()
                                                .withTargetCoverage(3)
                                                .withIncreasePercent(1001)
                                                .withBidCeiling(MAX_SET_AUTO_BID)))
                ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(5005, Api5ErrorDetailsJava.FIELD_MUST_BE_IN_RANGE_FROM_TO,
                                path(KeywordBidsSetAutoItemMap.BIDDING_RULE,
                                        SetAutoBiddingRule.NETWORK_BY_COVERAGE,
                                        NetworkByCoverageBiddingRule.INCREASE_PERCENT),
                                0, 1000))
                ));
    }

    @Test
    @TestCaseId("2992")
    public void trySetAutoWithSearchTrafficVolumeLess5() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new SetAutoRequestMap().withKeywordBids(
                        new KeywordBidsSetAutoItemMap()
                                .withAdGroupId(keywordId1)
                                .withBiddingRule(new SetAutoBiddingRule()
                                        .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                .withTargetTrafficVolume(4)
                                                .withIncreasePercent(50)
                                                .withBidCeiling(MAX_SET_AUTO_BID)))
                ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(5005, Api5ErrorDetailsJava.FIELD_MUST_BE_IN_RANGE_FROM_TO,
                                path(KeywordBidsSetAutoItemMap.BIDDING_RULE,
                                        SetAutoBiddingRule.SEARCH_BY_TRAFFIC_VOLUME,
                                        SearchByTrafficVolumeBiddingRule.TARGET_TRAFFIC_VOLUME),
                                5, 100))
                ));
    }

    @Test
    @TestCaseId("2993")
    public void trySetAutoWithSearchTrafficVolumeMore100() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new SetAutoRequestMap().withKeywordBids(
                        new KeywordBidsSetAutoItemMap()
                                .withAdGroupId(keywordId1)
                                .withBiddingRule(new SetAutoBiddingRule()
                                        .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                .withTargetTrafficVolume(101)
                                                .withIncreasePercent(50)
                                                .withBidCeiling(MAX_SET_AUTO_BID)))
                ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(5005, Api5ErrorDetailsJava.FIELD_MUST_BE_IN_RANGE_FROM_TO,
                                path(KeywordBidsSetAutoItemMap.BIDDING_RULE,
                                        SetAutoBiddingRule.SEARCH_BY_TRAFFIC_VOLUME,
                                        SearchByTrafficVolumeBiddingRule.TARGET_TRAFFIC_VOLUME),
                                5, 100))
                ));
    }

    @Test
    @TestCaseId("2994")
    public void trySetAutoWithNetworkContextCoverageLess0() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new SetAutoRequestMap().withKeywordBids(
                        new KeywordBidsSetAutoItemMap()
                                .withAdGroupId(keywordId1)
                                .withBiddingRule(new SetAutoBiddingRule()
                                        .withNetworkByCoverage(new NetworkByCoverageBiddingRule()
                                                .withTargetCoverage(-3)
                                                .withIncreasePercent(50)
                                                .withBidCeiling(MAX_SET_AUTO_BID)))
                ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(5005, Api5ErrorDetailsJava.FIELD_MUST_BE_IN_RANGE_FROM_TO,
                                path(KeywordBidsSetAutoItemMap.BIDDING_RULE,
                                        SetAutoBiddingRule.NETWORK_BY_COVERAGE,
                                        NetworkByCoverageBiddingRule.TARGET_COVERAGE),
                                1, 100))
                ));
    }

    @Test
    @TestCaseId("2985")
    public void trySetAutoWithContextCoverageEqual0() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new SetAutoRequestMap().withKeywordBids(
                        new KeywordBidsSetAutoItemMap()
                                .withAdGroupId(adGroupId)
                                .withBiddingRule(new SetAutoBiddingRule()
                                        .withNetworkByCoverage(new NetworkByCoverageBiddingRule()
                                                .withTargetCoverage(0)
                                                .withIncreasePercent(50)
                                                .withBidCeiling(MAX_SET_AUTO_BID)))
                ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(5005, Api5ErrorDetailsJava.FIELD_MUST_BE_IN_RANGE_FROM_TO,
                                path(KeywordBidsSetAutoItemMap.BIDDING_RULE,
                                        SetAutoBiddingRule.NETWORK_BY_COVERAGE,
                                        NetworkByCoverageBiddingRule.TARGET_COVERAGE),
                                1, 100))
                ));
    }

    @Test
    @TestCaseId("2986")
    public void trySetAutoWithInvalidContextCoverage() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new SetAutoRequestMap().withKeywordBids(
                        new KeywordBidsSetAutoItemMap()
                                .withAdGroupId(adGroupId)
                                .withBiddingRule(new SetAutoBiddingRule()
                                        .withNetworkByCoverage(new NetworkByCoverageBiddingRule()
                                                .withTargetCoverage(101)
                                                .withIncreasePercent(50)
                                                .withBidCeiling(MAX_SET_AUTO_BID)))
                ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(5005, Api5ErrorDetailsJava.FIELD_MUST_BE_IN_RANGE_FROM_TO,
                                path(KeywordBidsSetAutoItemMap.BIDDING_RULE,
                                        SetAutoBiddingRule.NETWORK_BY_COVERAGE,
                                        NetworkByCoverageBiddingRule.TARGET_COVERAGE),
                                1, 100))
                ));
    }

    @Test
    @TestCaseId("2987")
    public void trySetAutoInvalidAndValidBids() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetAutoItemMap()
                                        .withKeywordId(-1L)
                                        .withBiddingRule(new SetAutoBiddingRule()
                                                .withNetworkByCoverage(new NetworkByCoverageBiddingRule()
                                                        .withTargetCoverage(3)
                                                        .withIncreasePercent(50))),
                                new KeywordBidsSetAutoItemMap()
                                        .withKeywordId(keywordId2)
                                        .withBiddingRule(new SetAutoBiddingRule()
                                                .withNetworkByCoverage(new NetworkByCoverageBiddingRule()
                                                        .withTargetCoverage(3)
                                                        .withIncreasePercent(50)
                                                        .withBidCeiling(MAX_SET_AUTO_BID)))
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(5005, Api5ErrorDetailsJava.FIELD_MUST_BE_POSITIVE_INTEGER,
                                path(KeywordBidsSetAutoItemMap.KEYWORD_ID)))
                ),
                KeywordBidExpectedResult.successWithKeywordId());
    }

    @Test
    @TestCaseId("2988")
    public void trySetAutoOneValidAndOneWithoutRequiredFieldsBidsTest() {
        api.userSteps.keywordBidsSteps().shouldGetErrorOnBidsSetAuto(
                new SetAutoRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetAutoItemMap()
                                        .withKeywordId(keywordId2)
                                        .withBiddingRule(new SetAutoBiddingRule()
                                                .withNetworkByCoverage(new NetworkByCoverageBiddingRule()
                                                        .withTargetCoverage(3)
                                                        .withIncreasePercent(50))
                                                .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                        .withTargetTrafficVolume(10)
                                                        .withIncreasePercent(50))),
                                new KeywordBidsSetAutoItemMap()
                                        .withBiddingRule(new SetAutoBiddingRule()
                                                .withNetworkByCoverage(new NetworkByCoverageBiddingRule()
                                                        .withTargetCoverage(3)
                                                        .withIncreasePercent(50))
                                                .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                        .withTargetTrafficVolume(10)
                                                        .withIncreasePercent(50)))
                        ),
                BidsLogins.BIDS_CLIENT,
                new Api5Error(4005, Api5ErrorDetails.NULL_STRING));
    }


    @Test
    @TestCaseId("2989")
    public void trySetAutoBidsForAnotherClientAdGroupID() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetAutoItemMap()
                                        .withAdGroupId(anotherAdGroupId)
                                        .withBiddingRule(new SetAutoBiddingRule()
                                                .withNetworkByCoverage(new NetworkByCoverageBiddingRule()
                                                        .withTargetCoverage(3)
                                                        .withIncreasePercent(50)
                                                        .withBidCeiling(MAX_SET_AUTO_BID)))
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                path(KeywordBidsSetAutoItemMap.AD_GROUP_ID),
                                anotherAdGroupId))
                ));
    }

    @Test
    @TestCaseId("2990")
    public void trySetAutoBidsForAnotherClientKeywordID() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetAutoItemMap()
                                        .withKeywordId(anotherKeywordId)
                                        .withBiddingRule(new SetAutoBiddingRule()
                                                .withNetworkByCoverage(new NetworkByCoverageBiddingRule()
                                                        .withTargetCoverage(3)
                                                        .withIncreasePercent(50)
                                                        .withBidCeiling(MAX_SET_AUTO_BID)))
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                path(KeywordBidsSetAutoItemMap.KEYWORD_ID),
                                anotherKeywordId))
                ));
    }


    @Test
    @TestCaseId("2991")
    public void trySetAutoBidsForAnotherClientCampaignID() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetAutoItemMap()
                                        .withCampaignId(anotherCampaignId)
                                        .withBiddingRule(new SetAutoBiddingRule()
                                                .withNetworkByCoverage(new NetworkByCoverageBiddingRule()
                                                        .withTargetCoverage(3)
                                                        .withIncreasePercent(50)
                                                        .withBidCeiling(MAX_SET_AUTO_BID)))
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        (new Notification(8800, Api5ErrorDetails.KEYWORDS_NOT_FOUND_FOR_ID,
                                path(KeywordBidsSetAutoItemMap.CAMPAIGN_ID),
                                anotherCampaignId))
                ));
    }

    @Test
    @TestCaseId("3028")
    public void setAutoWithSeveralRules() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new ru.yandex.autotests.directapi.model.api5.keywordbids.SetAutoRequestMap().withKeywordBids(
                        new KeywordBidsSetAutoItemMap()
                                .withCampaignId(campaignId)
                                .withBiddingRule(new SetAutoBiddingRule()
                                        .withNetworkByCoverage(new NetworkByCoverageBiddingRule()
                                                .withTargetCoverage(3)
                                                .withBidCeiling(MAX_SET_AUTO_BID))
                                        .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                .withTargetTrafficVolume(10)
                                                .withBidCeiling(MAX_SET_AUTO_BID)))
                ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        new Notification(7000, Api5ErrorDetailsJava.SIZE_CANNOT_BE_MORE_THAN_MAX,
                                StringUtils.capitalize(BIDDING_RULE), 1)
                )
        );
    }
}
