package ru.yandex.autotests.direct.api.keywordbids.setauto;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.api.keywordbids.KeywordBidsFeatures;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidsSetAutoItemMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.NetworkByCoverageBiddingRule;
import ru.yandex.autotests.directapi.model.api5.keywordbids.SearchByTrafficVolumeBiddingRule;
import ru.yandex.autotests.directapi.model.api5.keywordbids.SetAutoBiddingRule;
import ru.yandex.autotests.directapi.model.api5.keywordbids.SetAutoRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(KeywordBidsFeatures.SET_AUTO)
@Tag(TagDictionary.TRUNK)
public class SetAutoPositiveTest {
    private static final Long MAX_BID = MoneyCurrency.get(Currency.RUB).getLongMaxPrice().longValue();
    private static final Long MAX_SET_AUTO_BID = MAX_BID / 2L;

    private static Long adGroupId;
    private static long keywordId1;
    private static Long campaignId;
    protected LogSteps log = LogSteps.getLogger(this.getClass());
    private static String login = BidsLogins.SUPER;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);

    @BeforeClass
    @Step("Подготовка данных для теста")
    public static void readBanner() {
        api.userSteps.clientFakeSteps().setAPIUnits(BidsLogins.BIDS_CLIENT, 12000000);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(BidsLogins.BIDS_CLIENT);
        api.userSteps.clientFakeSteps().enableAPI(BidsLogins.BIDS_CLIENT);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaignWithStrategies(
                new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                BidsLogins.BIDS_CLIENT
        );
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, BidsLogins.BIDS_CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, BidsLogins.BIDS_CLIENT);
        keywordId1 = api.userSteps.keywordsSteps().addDefaultKeyword(BidsLogins.BIDS_CLIENT, adGroupId);
    }

    @Test
    @TestCaseId("3001")
    public void setAutoWithValidCampaignId() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new SetAutoRequestMap().withKeywordBids(
                        new KeywordBidsSetAutoItemMap()
                                .withCampaignId(campaignId)
                                .withBiddingRule(new SetAutoBiddingRule()
                                        .withNetworkByCoverage(new NetworkByCoverageBiddingRule()
                                                .withTargetCoverage(3)
                                                .withIncreasePercent(50)
                                                .withBidCeiling(MAX_SET_AUTO_BID)))
                ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.successWithCampaignId()
        );
    }

    @Test
    @TestCaseId("3002")
    public void setAutoWithValidAdGroupId() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new SetAutoRequestMap().withKeywordBids(
                        new KeywordBidsSetAutoItemMap()
                                .withAdGroupId(adGroupId)
                                .withBiddingRule(new SetAutoBiddingRule()
                                        .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                .withTargetTrafficVolume(10)
                                                .withIncreasePercent(50)
                                                .withBidCeiling(MAX_SET_AUTO_BID)))
                ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.successWithAdGroupId()
        );
    }

    @Test
    @TestCaseId("3003")
    public void setAutoWithValidKeywordId() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new SetAutoRequestMap().withKeywordBids(
                        new KeywordBidsSetAutoItemMap()
                                .withKeywordId(keywordId1)
                                .withBiddingRule(new SetAutoBiddingRule()
                                        .withNetworkByCoverage(new NetworkByCoverageBiddingRule()
                                                .withTargetCoverage(3)
                                                .withIncreasePercent(50)
                                                .withBidCeiling(MAX_SET_AUTO_BID)))
                ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.successWithKeywordId()
        );
    }

    @Test
    @TestCaseId("3004")
    public void setAutoBidsWithoutMaxBid() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetAutoItemMap()
                                        .withKeywordId(keywordId1)
                                        .withBiddingRule(new SetAutoBiddingRule()
                                                .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                        .withTargetTrafficVolume(10)
                                                        .withIncreasePercent(50)))
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.successWithKeywordId());
    }

    @Test
    @TestCaseId("3005")
    public void setAutoWithMinIncreasePercent() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new SetAutoRequestMap().withKeywordBids(
                        new KeywordBidsSetAutoItemMap()
                                .withKeywordId(keywordId1)
                                .withBiddingRule(new SetAutoBiddingRule()
                                        .withNetworkByCoverage(new NetworkByCoverageBiddingRule()
                                                .withTargetCoverage(3)
                                                .withIncreasePercent(0)
                                                .withBidCeiling(MAX_SET_AUTO_BID)))
                ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.successWithKeywordId()
        );
    }

    @Test
    @TestCaseId("3006")
    public void setAutoWithMaxIncreasePercent() {
        //testplans string №89
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new SetAutoRequestMap().withKeywordBids(
                        new KeywordBidsSetAutoItemMap()
                                .withKeywordId(keywordId1)
                                .withBiddingRule(new SetAutoBiddingRule()
                                        .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                .withTargetTrafficVolume(10)
                                                .withIncreasePercent(1000)
                                                .withBidCeiling(MAX_SET_AUTO_BID)))
                ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.successWithKeywordId()
        );
    }

    @Test
    @TestCaseId("3007")
    public void setAutoWithoutIncreasePercent() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new SetAutoRequestMap().withKeywordBids(
                        new KeywordBidsSetAutoItemMap()
                                .withKeywordId(keywordId1)
                                .withBiddingRule(new SetAutoBiddingRule()
                                        .withNetworkByCoverage(new NetworkByCoverageBiddingRule()
                                                .withTargetCoverage(3)
                                                .withBidCeiling(MAX_SET_AUTO_BID)))
                ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.successWithKeywordId()
        );
    }
}
