package ru.yandex.autotests.direct.api.keywordbids.setauto;

import com.yandex.direct.api.v5.keywordbids.GetResponse;
import com.yandex.direct.api.v5.keywordbids.KeywordBidFieldEnum;
import com.yandex.direct.api.v5.keywordbids.KeywordBidNetworkFieldEnum;
import com.yandex.direct.api.v5.keywordbids.KeywordBidSearchFieldEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.api.keywordbids.KeywordBidsFeatures;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidsSetAutoItemMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.NetworkByCoverageBiddingRule;
import ru.yandex.autotests.directapi.model.api5.keywordbids.SearchByTrafficVolumeBiddingRule;
import ru.yandex.autotests.directapi.model.api5.keywordbids.SetAutoBiddingRule;
import ru.yandex.autotests.directapi.model.api5.keywordbids.SetAutoRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.junit.Assert.assertThat;

@Aqua.Test
@Features(KeywordBidsFeatures.SMOKE)
public class SetAutoSmokeTest {

    public static final String login = BidsLogins.BIDS_CLIENT;
    private static final Long MAX_BID = MoneyCurrency.get(Currency.RUB).getLongMaxPrice().longValue();
    private static final Long MAX_SET_AUTO_BID = MAX_BID / 2L;

    private static Long campaignId;
    private Long adGroupId;
    protected LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(login);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trashman = new Trashman(api);


    @BeforeClass
    @Step("Создание кампании")
    public static void prepareCampaign() {
        api.userSteps.clientFakeSteps().enableAPI(login);
        campaignId = api.userSteps.campaignSteps()
                .addDefaultTextCampaignWithStrategies(
                        new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                        new TextCampaignNetworkStrategyAddMap().defaultServingOff()
                );
    }

    @Before
    @Step("Создание группы")
    public void prepareAdGroup() {
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, login);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, login);
        api.userSteps.keywordsSteps().addDefaultKeywords(login, adGroupId, 2);
    }


    @Test
    @TestCaseId("3008")
    public void setAutoValidBids() {
        SetAutoRequestMap params = new SetAutoRequestMap();
        params.withKeywordBids(
                new KeywordBidsSetAutoItemMap()
                        .withAdGroupId(adGroupId)
                        .withBiddingRule(new SetAutoBiddingRule()
                                .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                        .withTargetTrafficVolume(15)
                                        .withIncreasePercent(50)
                                        .withBidCeiling(MAX_SET_AUTO_BID))));
        api.userSteps.keywordBidsSteps().keywordBidsSetAuto(params, login);
    }

    @Test
    @TestCaseId("3009")
    public void setAutoValidBidsNotEligibleGroup() {
        api.as(login);
        int shard = api.userSteps.clientFakeSteps().getUserShard(login);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).adGroupsSteps().setBsRarelyLoaded(adGroupId, true);
        final GetResponse getResponseBefore = api.userSteps.keywordBidsSteps().keywordBidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(new KeywordBidsSelectionCriteriaMap().withAdGroupIds(adGroupId))
                        .withFieldNames(KeywordBidFieldEnum.STRATEGY_PRIORITY, KeywordBidFieldEnum.SERVING_STATUS)
                        .withSearchFieldNames(KeywordBidSearchFieldEnum.BID)
                        .withNetworkFieldNames(KeywordBidNetworkFieldEnum.BID));
        SetAutoRequestMap params = new SetAutoRequestMap();
        params.withKeywordBids(
                new KeywordBidsSetAutoItemMap()
                        .withAdGroupId(adGroupId)
                        .withBiddingRule(new SetAutoBiddingRule()
                                .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                        .withTargetTrafficVolume(100)
                                        .withIncreasePercent(50)
                                        .withBidCeiling(MAX_SET_AUTO_BID))));
        api.userSteps.keywordBidsSteps().keywordBidsSetAuto(params, login);
        final GetResponse getResponseAfter = api.userSteps.keywordBidsSteps().keywordBidsGet(
                new GetRequestMap()
                        .withSelectionCriteria(new KeywordBidsSelectionCriteriaMap().withAdGroupIds(adGroupId))
                        .withFieldNames(KeywordBidFieldEnum.STRATEGY_PRIORITY, KeywordBidFieldEnum.SERVING_STATUS)
                        .withSearchFieldNames(KeywordBidSearchFieldEnum.BID)
                        .withNetworkFieldNames(KeywordBidNetworkFieldEnum.BID));
        assertThat("Ставка через setAuto, для группы в статусе \"мало показов\" не поменялась",
                getResponseBefore.getKeywordBids().get(0).getSearch().getBid(),
                equalTo(getResponseAfter.getKeywordBids().get(0).getSearch().getBid()));
    }

}
