package ru.yandex.autotests.direct.api.keywordbids.setauto;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.api.keywordbids.KeywordBidsFeatures;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidsSetAutoItemMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.SearchByTrafficVolumeBiddingRule;
import ru.yandex.autotests.directapi.model.api5.keywordbids.SetAutoBiddingRule;
import ru.yandex.autotests.directapi.model.api5.keywordbids.SetAutoRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.prices.KeywordBidsSteps;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Stories(ApiStories.UNITS)
@Features(KeywordBidsFeatures.SET_AUTO)
@Description("Проверка списания баллов.")
public class SetAutoUnitsTest {
    private static String client = BidsLogins.UNITS_SET_AUTO_CLIENT;
    private static final Long MAX_BID = MoneyCurrency.get(Currency.RUB).getLongMaxPrice().longValue();
    private static final Long MAX_SET_AUTO_BID = MAX_BID / 2L;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static Long adGroupId1;
    private static Long keywordId11;
    private static Long keywordId12;
    private static Long campaignId1;
    private static Long campaignId2;

    @Rule
    public Trashman trashman = new Trashman(api);

    private static final int SET_AUTO_COST = 25;
    private static final int SET_AUTO_COST_KEYWORD = 0;

    private static final int DEFAULT_ERROR_COST = 20;
    private static final int DEFAULT_FAULT_COST = 50;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId1 = api.userSteps.campaignSteps().addDefaultTextCampaignWithStrategies(
                new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                client
        );
        adGroupId1 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId1, client);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId1, client);
        keywordId11 = api.userSteps.keywordsSteps().addDefaultKeyword(client, adGroupId1);
        keywordId12 = api.userSteps.keywordsSteps().addDefaultKeyword(client, adGroupId1);

        campaignId2 = api.userSteps.campaignSteps().addDefaultTextCampaignWithStrategies(
                new TextCampaignSearchStrategyAddMap().defaultHighestPosition(),
                new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                client
        );
        Long adGroupId2 = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId2, client);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId2, client);
        api.userSteps.keywordsSteps().addDefaultKeyword(client, adGroupId2);
    }

    @Before
    public void clearSpentUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    @TestCaseId("3010")
    public void setAutoOneBid() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        KeywordBidsSteps keywordBidsSteps = api.userSteps.keywordBidsSteps();
        keywordBidsSteps.keywordBidsSetAuto(
                new SetAutoRequestMap().withKeywordBids(
                        new KeywordBidsSetAutoItemMap()
                                .withKeywordId(keywordId11)
                                .withBiddingRule(new SetAutoBiddingRule()
                                        .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                .withTargetTrafficVolume(10)
                                                .withIncreasePercent(50)
                                                .withBidCeiling(MAX_SET_AUTO_BID)))
                ), client);
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(SET_AUTO_COST + SET_AUTO_COST_KEYWORD));
    }

    @Test
    @TestCaseId("3011")
    public void setAutoWithError() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetAutoItemMap()
                                        .withKeywordId(keywordId11)
                                        .withBiddingRule(new SetAutoBiddingRule()
                                                .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                        .withTargetTrafficVolume(10)
                                                        .withIncreasePercent(50))),
                                new KeywordBidsSetAutoItemMap()
                                        .withKeywordId(-1L)
                                        .withBiddingRule(new SetAutoBiddingRule()
                                                .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                        .withTargetTrafficVolume(10)
                                                        .withIncreasePercent(50)))
                        ),
                client,
                KeywordBidExpectedResult.successWithKeywordId(),
                KeywordBidExpectedResult.errors(
                        (new Notification(5005, Api5ErrorDetailsJava.FIELD_MUST_BE_POSITIVE_INTEGER,
                                capitalize(KeywordBidsSetAutoItemMap.KEYWORD_ID)))
                ));
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(SET_AUTO_COST + DEFAULT_ERROR_COST + SET_AUTO_COST_KEYWORD));
    }

    @Test
    @TestCaseId("3012")
    public void setAutoTwoBids() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.keywordBidsSteps().keywordBidsSetAuto(
                new SetAutoRequestMap().withKeywordBids(
                        new KeywordBidsSetAutoItemMap()
                                .withKeywordId(keywordId11)
                                .withBiddingRule(new SetAutoBiddingRule()
                                        .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                .withTargetTrafficVolume(10)
                                                .withIncreasePercent(50)
                                                .withBidCeiling(MAX_SET_AUTO_BID))),
                        new KeywordBidsSetAutoItemMap()
                                .withKeywordId(keywordId12)
                                .withBiddingRule(new SetAutoBiddingRule()
                                        .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                .withTargetTrafficVolume(10)
                                                .withIncreasePercent(50)
                                                .withBidCeiling(MAX_SET_AUTO_BID)))
                ),
                client);
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        //noinspection PointlessArithmeticExpression
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(SET_AUTO_COST + 2 * SET_AUTO_COST_KEYWORD));
    }

    @Test
    @TestCaseId("3013")
    public void setAutoOneAdGroupBids() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.keywordBidsSteps().keywordBidsSetAuto(
                new SetAutoRequestMap().withKeywordBids(
                        new KeywordBidsSetAutoItemMap()
                                .withAdGroupId(adGroupId1)
                                .withBiddingRule(new SetAutoBiddingRule()
                                        .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                .withTargetTrafficVolume(10)
                                                .withIncreasePercent(50)
                                                .withBidCeiling(MAX_SET_AUTO_BID)))
                ),
                client);
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        //noinspection PointlessArithmeticExpression
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(SET_AUTO_COST + 2 * SET_AUTO_COST_KEYWORD));
    }

    @Test
    @TestCaseId("3014")
    public void setAutoTwoCampaignBids() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.keywordBidsSteps().keywordBidsSetAuto(
                new SetAutoRequestMap().withKeywordBids(
                        new KeywordBidsSetAutoItemMap()
                                .withCampaignId(campaignId1)
                                .withBiddingRule(new SetAutoBiddingRule()
                                        .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                .withTargetTrafficVolume(10)
                                                .withIncreasePercent(50)
                                                .withBidCeiling(MAX_SET_AUTO_BID))),
                        new KeywordBidsSetAutoItemMap()
                                .withCampaignId(campaignId2)
                                .withBiddingRule(new SetAutoBiddingRule()
                                        .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                .withTargetTrafficVolume(10)
                                                .withIncreasePercent(50)
                                                .withBidCeiling(MAX_SET_AUTO_BID)))
                ),
                client);
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        //noinspection PointlessArithmeticExpression
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(SET_AUTO_COST + 6 * SET_AUTO_COST_KEYWORD));
    }

    //FAULT

    @Test
    @TestCaseId("3015")
    public void trySetAutoNullParams() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.keywordBidsSteps().shouldGetErrorOnBidsSetAuto(
                new SetAutoRequestMap(),
                client,
                new Api5Error(8000,
                        Api5ErrorDetailsJava.MISSING_PARAMETER_VALUE,
                        capitalize(SetAutoRequestMap.KEYWORD_BIDS))
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(DEFAULT_FAULT_COST));

    }

    @Test
    @TestCaseId("3016")
    public void setAutoWithNotEnoughUnitsForActionButNotEmptyUnits() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.clientFakeSteps().fakeWithdrawClientUnits(client, unitsBefore);
        unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assumeThat("доступные баллы пользователя", unitsBefore, equalTo(0));
        api.userSteps.keywordBidsSteps().shouldGetErrorOnBidsSetAuto(
                new SetAutoRequestMap().withKeywordBids(
                        new KeywordBidsSetAutoItemMap()
                                .withKeywordId(keywordId11)
                                .withBiddingRule(new SetAutoBiddingRule()
                                        .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                .withTargetTrafficVolume(10)
                                                .withIncreasePercent(50)
                                                .withBidCeiling(MAX_SET_AUTO_BID)))
                ), client,
                new Api5Error(152, Api5ErrorDetails.NOT_ENOUGH_UNITS_FOR_OPERATION));
    }

}
