package ru.yandex.autotests.direct.api.keywordbids.setauto.strategy;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.api.keywordbids.KeywordBidsFeatures;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidsSetAutoItemMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.NetworkByCoverageBiddingRule;
import ru.yandex.autotests.directapi.model.api5.keywordbids.SearchByTrafficVolumeBiddingRule;
import ru.yandex.autotests.directapi.model.api5.keywordbids.SetAutoBiddingRule;
import ru.yandex.autotests.directapi.model.api5.keywordbids.SetAutoRequestMap;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(KeywordBidsFeatures.SET_AUTO)
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class SetAutoBidsAutoOnSearchAndOnContextStrategyTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String description;

    @Parameterized.Parameter(value = 1)
    public TextCampaignSearchStrategyMap searchStrategy;

    @Parameterized.Parameter(value = 2)
    public TextCampaignNetworkStrategyMap networkStrategy;

    private static final Long goalID = MetrikaGoals.getGoalForLogin(BidsLogins.BIDS_CLIENT);
    private Long adGroupId;

    @Parameterized.Parameters(name = "{0}")
    public static Collection data() {
        return Arrays.asList(new Object[][]{
                // auto strategy on search
                {"WB_MAXIMUM_CLICKS + NETWORK_DEFAULT",
                        new TextCampaignSearchStrategyMap().defaultWbMaximumClicks(Currency.RUB),
                        new TextCampaignNetworkStrategyMap().defaultNetworkDefault()},
                {"WB_MAXIMUM_CONVERSION_RATE + NETWORK_DEFAULT",
                        new TextCampaignSearchStrategyMap().defaultWbMaximumConversionRate(Currency.RUB,
                                goalID.longValue()),
                        new TextCampaignNetworkStrategyMap().defaultNetworkDefault()},
                {"AVERAGE_CPC + NETWORK_DEFAULT",
                        new TextCampaignSearchStrategyMap().defaultAverageCpc(Currency.RUB),
                        new TextCampaignNetworkStrategyMap().defaultNetworkDefault()},
                {"AVERAGE_CPA + NETWORK_DEFAULT",
                        new TextCampaignSearchStrategyMap().defaultAverageCpa(Currency.RUB, goalID.longValue()),
                        new TextCampaignNetworkStrategyMap().defaultNetworkDefault()},
                // auto strategy on network
                {"SERVING_OFF + WB_MAXIMUM_CLICKS",
                        new TextCampaignSearchStrategyMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyMap().defaultWbMaximumClicks(Currency.RUB)},
                {"SERVING_OFF + WB_MAXIMUM_CONVERSION_RATE",
                        new TextCampaignSearchStrategyMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyMap().defaultWbMaximumConversionRate(Currency.RUB,
                                goalID.longValue())},
                {"SERVING_OFF + AVERAGE_CPC",
                        new TextCampaignSearchStrategyMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyMap().defaultAverageCpc(Currency.RUB)},
                {"SERVING_OFF + AVERAGE_CPA",
                        new TextCampaignSearchStrategyMap().defaultServingOff(),
                        new TextCampaignNetworkStrategyMap().defaultAverageCpa(Currency.RUB, goalID.longValue())}
        });
    }

    @Before
    @Step("Подготовка данных для теста")
    public void createData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(BidsLogins.BIDS_CLIENT);
        int shard = api.userSteps.clientFakeSteps().getUserShard(BidsLogins.BIDS_CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign(BidsLogins.BIDS_CLIENT);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                .addCampMetrikaGoals(campaignId, goalID.longValue(), 200L, 200L);
        api.userSteps.campaignSteps().campaignsUpdateWithCheck(BidsLogins.BIDS_CLIENT,
                new CampaignUpdateItemMap()
                        .withId(campaignId)
                        .withTextCampaign(new TextCampaignUpdateItemMap()
                                .withBiddingStrategy(new TextCampaignStrategyMap()
                                        .withSearch(searchStrategy)
                                        .withNetwork(networkStrategy))));
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, BidsLogins.BIDS_CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, BidsLogins.BIDS_CLIENT);
        api.userSteps.keywordsSteps().addDefaultKeyword(BidsLogins.BIDS_CLIENT, adGroupId);
        api.protocol(ProtocolType.SOAP);
    }

    @Test
    @TestCaseId("3017")
    public void trySetAutoTestWithAutoStrategiesTest() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new SetAutoRequestMap().withKeywordBids(
                        new KeywordBidsSetAutoItemMap()
                                .withAdGroupId(adGroupId)
                                .withBiddingRule(new SetAutoBiddingRule()
                                        .withNetworkByCoverage(new NetworkByCoverageBiddingRule()
                                                .withTargetCoverage(3)
                                                .withIncreasePercent(50)
                                                .withBidCeiling(10000000L)))
                ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        new Notification(9601,
                                Api5ErrorDetails.CAMPAIGN_HAS_INSTALLED_AUTO_STRATEGY)));
    }

}
