package ru.yandex.autotests.direct.api.keywordbids.setauto.strategy;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.bids.BidsLogins;
import ru.yandex.autotests.direct.api.keywordbids.KeywordBidsFeatures;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidExpectedResult;
import ru.yandex.autotests.directapi.model.api5.keywordbids.KeywordBidsSetAutoItemMap;
import ru.yandex.autotests.directapi.model.api5.keywordbids.NetworkByCoverageBiddingRule;
import ru.yandex.autotests.directapi.model.api5.keywordbids.SearchByTrafficVolumeBiddingRule;
import ru.yandex.autotests.directapi.model.api5.keywordbids.SetAutoBiddingRule;
import ru.yandex.autotests.directapi.model.api5.keywordbids.SetAutoRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.allure.annotations.TestCaseId;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

@Aqua.Test
@Features(KeywordBidsFeatures.SET_AUTO)
@Tag(TagDictionary.TRUNK)
public class SetAutoBidsShowsDisabledOnSearchAndMaximumOnContextTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long adGroupId;

    @Before
    @Step("Подготовка данных для теста")
    public void createData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(BidsLogins.BIDS_CLIENT);
        Long campaignId = api.userSteps.campaignSteps().addDefaultTextCampaignWithStrategies(
                new TextCampaignSearchStrategyAddMap().defaultServingOff(),
                new TextCampaignNetworkStrategyAddMap().defaultMaximumCoverage(),
                BidsLogins.BIDS_CLIENT
        );
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId, BidsLogins.BIDS_CLIENT);
        api.userSteps.adsSteps().addDefaultTextAd(adGroupId, BidsLogins.BIDS_CLIENT);
        api.userSteps.keywordsSteps().addDefaultKeyword(BidsLogins.BIDS_CLIENT, adGroupId);
        api.protocol(ProtocolType.SOAP);
    }

    @Test
    @TestCaseId("3024")
    public void trySetAutoWithSearchScopeTest() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetAutoItemMap()
                                        .withAdGroupId(adGroupId)
                                        .withBiddingRule(new SetAutoBiddingRule()
                                                .withSearchByTrafficVolume(new SearchByTrafficVolumeBiddingRule()
                                                        .withTargetTrafficVolume(10)
                                                        .withIncreasePercent(50)
                                                        .withBidCeiling(10000000L)))
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.errors(
                        new Notification(9601,
                                Api5ErrorDetails.BIDS_WILL_NOT_APPLIED_BECAUSE_OF_SHOWS_DISABLED_ON_SEARCH)));
    }

    @Test
    @TestCaseId("3022")
    public void trySetAutoWithNetworkScopeTest() {
        api.userSteps.keywordBidsSteps().shouldGetKeywordBidResultOnSetAuto(
                new SetAutoRequestMap()
                        .withKeywordBids(
                                new KeywordBidsSetAutoItemMap()
                                        .withAdGroupId(adGroupId)
                                        .withBiddingRule(new SetAutoBiddingRule()
                                                .withNetworkByCoverage(new NetworkByCoverageBiddingRule()
                                                        .withTargetCoverage(10)
                                                        .withIncreasePercent(50)
                                                        .withBidCeiling(10000000L)))
                        ),
                BidsLogins.BIDS_CLIENT,
                KeywordBidExpectedResult.successWithAdGroupId());
    }
}
