package ru.yandex.autotests.direct.api.campaigns;

import java.util.Collections;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.util.streamex.StreamEx;

import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.bsfront.BsFrontTurbolandingRequest;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.bsfront.IntapiTurboLanding;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.bsfront.IntapiTurboLandingCounter;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.bsfront.IntapiTurboLandingGoal;

import static ru.yandex.autotests.direct.api.campaigns.BsFrontTestDataUtils.TurbolandingGoalWeight.CONVERSION_GOAL;

@ParametersAreNonnullByDefault
public class BsFrontTestDataUtils {

    public static BsFrontTurbolandingRequest getDefaultTurboladingSaveRequest(Long clientId, Long uid,
                                                                              IntapiTurboLanding turboLanding) {
        return new BsFrontTurbolandingRequest()
                .withClientId(clientId)
                .withOperatorUid(uid.intValue())
                .withTurbolanding(turboLanding);
    }

    public static IntapiTurboLanding getTestIntapiTurbolanding(Long id, List<IntapiTurboLandingCounter> counters) {
        return new IntapiTurboLanding()
                .withId(id)
                .withContentModerationRequired(false)
                .withCounters(counters)
                .withName("test_turbolanding")
                .withPreset("empty_preset")
                .withPreviewHref("http://ya.ru")
                .withUrl("http://ya.ru")
                .withVersion(1L);
    }

    public static IntapiTurboLandingCounter testTurbolandingCounter(Integer counterId,
                                                                    List<IntapiTurboLandingGoal> goals) {
        return new IntapiTurboLandingCounter()
                .withId(counterId)
                .withIsUserCounter(true)
                .withGoals(goals)
                .withGoalsList(Collections.emptyList());
    }

    public static List<IntapiTurboLandingGoal> testTurbolandingGoals(List<Long> conversionGoalIds) {
        return StreamEx.of(conversionGoalIds)
                .map(conversionGoalId -> new IntapiTurboLandingGoal()
                        .withId(conversionGoalId)
                        .withWeight(CONVERSION_GOAL.getWeight()))
                .toList();
    }

    public enum TurbolandingGoalWeight {
        CONVERSION_GOAL(1L),
        OTHER_GOAL(0L);

        private long goalWeight;

        TurbolandingGoalWeight(long goalWeight) {
            this.goalWeight = goalWeight;
        }

        Long getWeight() {
            return goalWeight;
        }
    }
}
