package ru.yandex.autotests.direct.api.campaigns;

import java.util.EnumSet;
import java.util.Set;

import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignSettingsEnum;
import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignSettingsGetEnum;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSettingsEnum;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSettingsGetEnum;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSettingsEnum;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSettingsGetEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSettingsEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSettingsGetEnum;

/**
 * Настройки кампании в api5, которые не нужно проверять
 * в тестах UpdateAndGetSettingsExtAllNoTest и UpdateAndGetSettingsExtAllYesTest
 * <p>
 * REQUIRE_SERVICING - в теории можно проверить,
 * но не с клиентом GET_SERV_CLIENT (у него нет counter)
 */
public class CampaignsDeprecatedSettings {

    public static EnumSet<TextCampaignSettingsEnum> TEXT_CAMPAIGN_DEPRECATED_SETTINGS = EnumSet.of(
            TextCampaignSettingsEnum.REQUIRE_SERVICING,
            TextCampaignSettingsEnum.ENABLE_AUTOFOCUS,
            TextCampaignSettingsEnum.ENABLE_RELATED_KEYWORDS,
            TextCampaignSettingsEnum.ENABLE_BEHAVIORAL_TARGETING
    );
    public static EnumSet<TextCampaignSettingsGetEnum> TEXT_CAMPAIGN_DEPRECATED_SETTINGS_GET = EnumSet.of(
            TextCampaignSettingsGetEnum.REQUIRE_SERVICING,
            TextCampaignSettingsGetEnum.ENABLE_AUTOFOCUS,
            TextCampaignSettingsGetEnum.ENABLE_RELATED_KEYWORDS,
            TextCampaignSettingsGetEnum.ENABLE_BEHAVIORAL_TARGETING,
            TextCampaignSettingsGetEnum.SHARED_ACCOUNT_ENABLED
    );

    public static EnumSet<DynamicTextCampaignSettingsEnum> DYNAMIC_TEXT_CAMPAIGN_DEPRECATED_SETTINGS = EnumSet.of(
            DynamicTextCampaignSettingsEnum.REQUIRE_SERVICING,
            DynamicTextCampaignSettingsEnum.ENABLE_BEHAVIORAL_TARGETING
    );
    public static EnumSet<DynamicTextCampaignSettingsGetEnum> DYNAMIC_TEXT_CAMPAIGN_DEPRECATED_SETTINGS_GET =
            EnumSet.of(
                    DynamicTextCampaignSettingsGetEnum.REQUIRE_SERVICING,
                    DynamicTextCampaignSettingsGetEnum.ENABLE_BEHAVIORAL_TARGETING,
                    DynamicTextCampaignSettingsGetEnum.SHARED_ACCOUNT_ENABLED
            );

    public static EnumSet<MobileAppCampaignSettingsEnum> MOBILE_APP_CAMPAIGN_DEPRECATED_SETTINGS = EnumSet.of(
            MobileAppCampaignSettingsEnum.REQUIRE_SERVICING,
            MobileAppCampaignSettingsEnum.ENABLE_BEHAVIORAL_TARGETING,
            MobileAppCampaignSettingsEnum.ENABLE_AUTOFOCUS
    );
    public static EnumSet<MobileAppCampaignSettingsGetEnum> MOBILE_APP_CAMPAIGN_DEPRECATED_SETTINGS_GET = EnumSet.of(
            MobileAppCampaignSettingsGetEnum.REQUIRE_SERVICING,
            MobileAppCampaignSettingsGetEnum.ENABLE_BEHAVIORAL_TARGETING,
            MobileAppCampaignSettingsGetEnum.ENABLE_AUTOFOCUS,
            MobileAppCampaignSettingsGetEnum.SHARED_ACCOUNT_ENABLED
    );

    public static EnumSet<CpmBannerCampaignSettingsEnum> CPM_BANNER_CAMPAIGN_DEPRECATED_SETTINGS = EnumSet.of(
            CpmBannerCampaignSettingsEnum.REQUIRE_SERVICING
    );
    public static EnumSet<CpmBannerCampaignSettingsGetEnum> CPM_BANNER_CAMPAIGN_DEPRECATED_SETTINGS_GET = EnumSet.of(
            CpmBannerCampaignSettingsGetEnum.REQUIRE_SERVICING,
            CpmBannerCampaignSettingsGetEnum.SHARED_ACCOUNT_ENABLED
    );
}
