package ru.yandex.autotests.direct.api.campaigns;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

import ru.yandex.autotests.irt.testutils.beandiffer2.Diff;
import ru.yandex.autotests.irt.testutils.beandiffer2.differ.AbstractDiffer;

/**
 * Сравнение id в формате 1.3088934E7, 13088934 и "13088934"
 */
public class LongOrStringDiffer extends AbstractDiffer {

    @Override
    public List<Diff> compare(Object actual, Object expected) {
        List<Diff> result = new ArrayList<>();

        if (actual == null && expected == null) {
            return result;
        }
        if (actual == null || expected == null) {
            result.add(Diff.changed(getField(), actual, expected));
            return result;
        }
        if (!StringUtils.equals(toQuotedString(actual), toQuotedString(expected))) {
            result.add(Diff.changed(getField(), actual, expected));
        }
        return result;
    }

    private String toQuotedString(Object o) {
        if (o instanceof Double) {
            return "\"" + ((Double)o).longValue() + "\"";
        } else if (o instanceof String && ((String) o).startsWith("\"")) {
            return (String) o;
        } else {
            return "\"" + o.toString() + "\"";
        }
    }
}
