package ru.yandex.autotests.direct.api.campaigns.add;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.campaigns.TimeTargetMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by gerdler on 12.09.2016.
 * https://st.yandex-team.ru/TESTIRT-10182
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка однозначного преобразования поля TimeZone запроса в timezone_id в БД при создании кампании")
@Issue("https://st.yandex-team.ru/DIRECT-57460")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class AddCampaignTimeZoneSaveToDBTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String timeZone;

    @Parameterized.Parameter(1)
    public Short expectedTimeZoneId;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {TimeTargetMap.TimeZone.EUROPE_MOSCOW, (short) 130},
                {TimeTargetMap.TimeZone.EUROPE_KIEV, (short) 61}
        });
    }

    int shard = api.userSteps.clientFakeSteps().getUserShard(CLIENT);
    DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("1")
    public void addWithTimeZoneAndCheckTimeZoneIdInDB() {
        Long campaignId = api.userSteps.campaignSteps().addCampaign(
                new CampaignAddItemMap().defaultCampaignAddItem()
                        .withTimeZone(timeZone)
                        .withDefaultTextCampaign()
        );
        assertThat("Поле timezone_id в БД имеет правильное значение",
                jooqDbSteps.campaignsSteps().getCampaignById(campaignId).getTimezoneId(),
                equalTo(expectedTimeZoneId)
        );
    }
}
