package ru.yandex.autotests.direct.api.campaigns.add;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlApi5Error;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 16.09.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка агентств и субклиентов. Негативные сценарии")
@Issue("https://st.yandex-team.ru/DIRECT-34567")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class AddCampaignsAgencyAndSubclientsNegativeTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String operator;

    @Parameterized.Parameter(2)
    public String client;

    @Parameterized.Parameter(3)
    public JavaOrPerlApi5Error expectedError;

    @Parameterized.Parameters(name = "{0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {"клиент - другой клиент",
                        CampaignsLogins.CLIENT, CampaignsLogins.SINGLE_CLIENT,
                        JavaOrPerlApi5Error.both(
                                new Api5Error(8800, Api5ErrorDetails.UNKNOWN_LOGIN_IN_CLIENT_LOGIN))},
                {"агентство - клиент",
                        CampaignsLogins.AGENCY_1_CAMPAIGNS, CampaignsLogins.SINGLE_CLIENT,
                        JavaOrPerlApi5Error.both(
                                new Api5Error(8800, Api5ErrorDetails.UNKNOWN_LOGIN_IN_CLIENT_LOGIN))},
                {"субклиент без прав на редактирование",
                        Logins.SUB_CLIENT_WITHOUT_EDIT_RIGHTS, null,
                        JavaOrPerlApi5Error
                                .java(new Api5Error(54, Api5ErrorDetails.NULL_STRING))
                                .perl(new Api5Error(54, Api5ErrorDetails.NO_RIGHTS_TO_CREATE_CAMPAIGN))},
                {"субклиент без прав редактирования, со свободой",
                        CampaignsLogins.SUB_CLIENT_WITHOUT_EDIT_RIGHTS, null,
                        JavaOrPerlApi5Error
                                .java(new Api5Error(54, Api5ErrorDetails.NULL_STRING))
                                .perl(new Api5Error(54, Api5ErrorDetails.NO_RIGHTS_TO_CREATE_CAMPAIGN))},
        };
        return Arrays.asList(data);
    }

    @Before
    public void createGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(operator);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("2")
    public void checkRightsToAddTextCampaign() {
        //DIRECT-45258
        //DIRECT-46018
        api.as(operator).userSteps.campaignSteps().expectErrorOnCampaignsAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                .defaultCampaignAddItem()
                                .withDefaultTextCampaign()
                        ),
                client,
                expectedError
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("3")
    public void checkRightsToAddMobileAppCampaign() {
        api.as(operator).userSteps.campaignSteps().expectErrorOnCampaignsAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                .defaultCampaignAddItem()
                                .withDefaultMobileAppCampaign()
                        ),
                client,
                expectedError
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("4")
    public void checkRightsToAddDynamicTextCampaign() {
        api.as(operator).userSteps.campaignSteps().expectErrorOnCampaignsAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                .defaultCampaignAddItem()
                                .withDefaultDynamicTextCampaign()
                        ),
                client,
                expectedError
        );
    }

    @Test
    public void checkRightsToAddCpmBannerCampaign() {
        api.as(operator).userSteps.campaignSteps().expectErrorOnCampaignsAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                .defaultCampaignAddItem()
                                .withDefaultCpmBannerCampaign()
                        ),
                client,
                expectedError
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("5")
    public void checkRightsToAddWithFakeAuthorization() {
        //DIRECT-45258
        //DIRECT-46018
        api.as(Logins.SUPER_LOGIN, operator).userSteps.campaignSteps().expectErrorOnCampaignsAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                .defaultCampaignAddItem()
                                .withDefaultTextCampaign()
                        ),
                client,
                expectedError
        );
    }
}
