package ru.yandex.autotests.direct.api.campaigns.add;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.AddResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 27.08.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка агентств и субклиентов. Позитивные сценарии")
@Issue("https://st.yandex-team.ru/DIRECT-34567")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class AddCampaignsAgencyAndSubclientsPositiveTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String operator;

    @Parameterized.Parameter(2)
    public String client;

    @Parameterized.Parameter(3)
    public ExpectedResult expectedResult;

    @Parameterized.Parameter(4)
    public String expectedAgency;

    @Parameterized.Parameters(name = "{0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {"агентство - субклиент с правами редактирования",
                        CampaignsLogins.AGENCY_CAMPAIGNS, CampaignsLogins.SUB_CLIENT_WITH_EDIT_RIGHTS,
                        ExpectedResult.success(),
                        CampaignsLogins.AGENCY_CAMPAIGNS},
                {"агентство - субклиент без прав редактирования",
                        CampaignsLogins.AGENCY_CAMPAIGNS, CampaignsLogins.SUB_CLIENT_WITHOUT_EDIT_RIGHTS,
                        ExpectedResult.success(),
                        CampaignsLogins.AGENCY_CAMPAIGNS},
                {"представитель агентства - субклиент",
                        CampaignsLogins.AGENCY_REP_CAMPAIGNS, CampaignsLogins.SUBCLIENT_CAMPAIGNS,
                        ExpectedResult.success(),
                        CampaignsLogins.AGENCY_1_CAMPAIGNS},
                {"сервисируемый клиент",
                        CampaignsLogins.SERV_CLIENT, null, ExpectedResult.success(),
                        null},
                {"субклиент с правами редактирования",
                        Logins.SUB_CLIENT_WITH_EDIT_RIGHTS, null, ExpectedResult.success(),
                        CampaignsLogins.AGENCY_CAMPAIGNS},
                {"агентство - субклиент с двумя агентствами",
                        CampaignsLogins.AGENCY_1_CAMPAIGNS, CampaignsLogins.SUBCLIENT_CAMPAIGNS,
                        ExpectedResult.success(),
                        CampaignsLogins.AGENCY_1_CAMPAIGNS},

        };
        return Arrays.asList(data);
    }

    @Before
    public void createGroup() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(operator);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("6")
    public void checkRightsToAddCampaign() {
        //DIRECT-45258
        AddResponse response = api.as(Logins.SUPER_LOGIN, operator).userSteps.campaignSteps()
                .shouldGetResultOnAdd(new AddRequestMap()
                                .withCampaigns(new CampaignAddItemMap()
                                        .defaultCampaignAddItem()
                                        .withDefaultTextCampaign()
                                ),
                        client,
                        expectedResult
                );

        Long id = response.getAddResults().get(0).getId();

        Long expectedAgencyId = (expectedAgency == null) ? 0L :
                Long.valueOf(api.userSteps.clientFakeSteps().getClientData(expectedAgency).getClientID());

        Integer agencyId = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(id).getAgencyID();
        assertThat("агентство кампании правильное", agencyId.longValue(), equalTo(expectedAgencyId));
    }
}
