package ru.yandex.autotests.direct.api.campaigns.add;

import com.yandex.direct.api.v5.campaigns.AddResponse;
import org.apache.commons.beanutils.BeanMap;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsType;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlApi5Error;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang.WordUtils.capitalize;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 28.09.15.
 * https://st.yandex-team.ru/TESTIRT-7291
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Использование в запросе Campaigns.add разных типов кампаний")
@Issue("https://st.yandex-team.ru/DIRECT-43063")
@Tag(TagDictionary.TRUNK)
public class AddDifferentTypesOfCampaignsInOneRequestTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static DirectJooqDbSteps jooqDbSteps;

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        int shard = api.userSteps.clientFakeSteps().getUserShard(CLIENT);
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("9")
    public void addTextAndMobileAppCampaigns() {
        AddResponse addResponse = api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                        .defaultCampaignAddItem()
                                        .withDefaultTextCampaign(),
                                new CampaignAddItemMap()
                                        .defaultCampaignAddItem()
                                        .withDefaultMobileAppCampaign()
                        ),
                ExpectedResult.success(), ExpectedResult.success());
        Long textId = addResponse.getAddResults().get(0).getId();
        Long mobileAppId = addResponse.getAddResults().get(1).getId();

        CampaignsRecord campaignRecord = jooqDbSteps.campaignsSteps().getCampaignById(textId);
        assertThat("текстовая кампания создалась с правильным типом", campaignRecord.getType(),
                equalTo(CampaignsType.text));
        campaignRecord = jooqDbSteps.campaignsSteps().getCampaignById(mobileAppId);
        assertThat("кампания РМП создалась с правильным типом", campaignRecord.getType(),
                equalTo(CampaignsType.mobile_content));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("10")
    public void addMobileAppAndTextCampaigns() {
        AddResponse addResponse = api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                        .defaultCampaignAddItem()
                                        .withDefaultMobileAppCampaign(),
                                new CampaignAddItemMap()
                                        .defaultCampaignAddItem()
                                        .withDefaultTextCampaign()
                        ),
                ExpectedResult.success(), ExpectedResult.success());
        Long mobileAppId = addResponse.getAddResults().get(0).getId();
        Long textId = addResponse.getAddResults().get(1).getId();

        CampaignsRecord campaignRecord = jooqDbSteps.campaignsSteps().getCampaignById(mobileAppId);
        assertThat("кампания РМП создалась с правильным типом", campaignRecord.getType(),
                equalTo(CampaignsType.mobile_content));
        campaignRecord = jooqDbSteps.campaignsSteps().getCampaignById(textId);
        assertThat("текстовая кампания создалась с правильным типом", campaignRecord.getType(),
                equalTo(CampaignsType.text));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("11")
    public void addTextAndDynamicTextCampaigns() {
        AddResponse addResponse = api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                        .defaultCampaignAddItem()
                                        .withDefaultTextCampaign(),
                                new CampaignAddItemMap()
                                        .defaultCampaignAddItem()
                                        .withDefaultDynamicTextCampaign()
                        ),
                ExpectedResult.success(), ExpectedResult.success());
        Long textId = addResponse.getAddResults().get(0).getId();
        Long dynamicTextId = addResponse.getAddResults().get(1).getId();

        CampaignsRecord campaignRecord = jooqDbSteps.campaignsSteps().getCampaignById(textId);
        assertThat("текстовая кампания создалась с правильным типом", campaignRecord.getType(),
                equalTo(CampaignsType.text));
        campaignRecord = jooqDbSteps.campaignsSteps().getCampaignById(dynamicTextId);
        assertThat("динамическая текстовая кампания создалась с правильным типом", campaignRecord.getType(),
                equalTo(CampaignsType.dynamic));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("12")
    public void addDynamicTextAndMobileAppCampaigns() {
        AddResponse addResponse = api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                        .defaultCampaignAddItem()
                                        .withDefaultDynamicTextCampaign(),
                                new CampaignAddItemMap()
                                        .defaultCampaignAddItem()
                                        .withDefaultMobileAppCampaign()
                        ),
                ExpectedResult.success(), ExpectedResult.success());
        Long dynamicTextId = addResponse.getAddResults().get(0).getId();
        Long mobileAppId = addResponse.getAddResults().get(1).getId();

        CampaignsRecord campaignRecord = jooqDbSteps.campaignsSteps().getCampaignById(dynamicTextId);
        assertThat("динамическая текстовая кампания создалась с правильным типом", campaignRecord.getType(),
                equalTo(CampaignsType.dynamic));
        campaignRecord = jooqDbSteps.campaignsSteps().getCampaignById(mobileAppId);
        assertThat("кампания РМП создалась с правильным типом", campaignRecord.getType(),
                equalTo(CampaignsType.mobile_content));
    }

    @Test
    public void addMobileAppAndCpmBannerCampaigns() {
        AddResponse addResponse = api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                        .defaultCampaignAddItem()
                                        .withDefaultMobileAppCampaign(),
                                new CampaignAddItemMap()
                                        .defaultCampaignAddItem()
                                        .withDefaultCpmBannerCampaign()
                        ),
                ExpectedResult.success(), ExpectedResult.success());

        Long mobileAppId = addResponse.getAddResults().get(0).getId();
        Long cpmBannerId = addResponse.getAddResults().get(1).getId();

        CampaignsRecord campaignRecord = jooqDbSteps.campaignsSteps().getCampaignById(mobileAppId);
        assertThat("кампания РМП создалась с правильным типом", campaignRecord.getType(),
                equalTo(CampaignsType.mobile_content));
        campaignRecord = jooqDbSteps.campaignsSteps().getCampaignById(cpmBannerId);
        assertThat("медийная кампания создалась с правильным типом", campaignRecord.getType(),
                equalTo(CampaignsType.cpm_banner));
    }

    @Test
    public void addDynamicTextAndCpmBannerCampaigns() {
        AddResponse addResponse = api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                        .defaultCampaignAddItem()
                                        .withDefaultDynamicTextCampaign(),
                                new CampaignAddItemMap()
                                        .defaultCampaignAddItem()
                                        .withDefaultCpmBannerCampaign()
                        ),
                ExpectedResult.success(), ExpectedResult.success());

        Long dynamicTextId = addResponse.getAddResults().get(0).getId();
        Long cpmBannerId = addResponse.getAddResults().get(1).getId();

        CampaignsRecord campaignRecord = jooqDbSteps.campaignsSteps().getCampaignById(dynamicTextId);
        assertThat("динамическая текстовая кампания создалась с правильным типом", campaignRecord.getType(),
                equalTo(CampaignsType.dynamic));
        campaignRecord = jooqDbSteps.campaignsSteps().getCampaignById(cpmBannerId);
        assertThat("медийная кампания создалась с правильным типом", campaignRecord.getType(),
                equalTo(CampaignsType.cpm_banner));
    }

    @Test
    public void addTextAndCpmBannerCampaigns() {
        AddResponse addResponse = api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                        .defaultCampaignAddItem()
                                        .withDefaultCpmBannerCampaign(),
                                new CampaignAddItemMap()
                                        .defaultCampaignAddItem()
                                        .withDefaultTextCampaign()
                        ),
                ExpectedResult.success(), ExpectedResult.success());

        Long cpmBannerId = addResponse.getAddResults().get(0).getId();
        Long textId = addResponse.getAddResults().get(1).getId();

        CampaignsRecord campaignRecord = jooqDbSteps.campaignsSteps().getCampaignById(textId);
        assertThat("текстовая кампания создалась с правильным типом", campaignRecord.getType(),
                equalTo(CampaignsType.text));
        campaignRecord = jooqDbSteps.campaignsSteps().getCampaignById(cpmBannerId);
        assertThat("медийная кампания создалась с правильным типом", campaignRecord.getType(),
                equalTo(CampaignsType.cpm_banner));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("13")
    public void tryAddOneCampaignWithTwoTypes() {
        //DIRECT-46791
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                .defaultCampaignAddItem()
                                .withDefaultTextCampaign()
                                .withDefaultMobileAppCampaign()),

                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5009,
                                Api5ErrorDetails.ONLY_ONE_OF_FIELDS_SHOULD_BE_SPECIFIED_BM,
                                "CPM_BANNER, DYNAMIC, MOBILE_CONTENT, PERFORMANCE, TEXT")))
                        .perl(ExpectedResult.errors(new Notification(5009,
                                Api5ErrorDetails.CAMPAIGN_CAN_CONTAIN_ONLY_ONE_OF_OBJECTS,
                                capitalize(CampaignAddItemMap.CPM_BANNER_CAMPAIGN) + ", " +
                                        capitalize(CampaignAddItemMap.DYNAMIC_TEXT_CAMPAIGN) + ", " +
                                        capitalize(CampaignAddItemMap.MOBILE_APP_CAMPAIGN) + ", " +
                                        capitalize(CampaignAddItemMap.SMART_CAMPAIGN) + ", " +
                                        capitalize(CampaignAddItemMap.TEXT_CAMPAIGN)))));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("14")
    public void tryAddOneCampaignWithThreeTypes() {
        //DIRECT-46791
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                .defaultCampaignAddItem()
                                .withDefaultTextCampaign()
                                .withDefaultMobileAppCampaign()
                                .withDefaultDynamicTextCampaign()),

                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5009,
                                Api5ErrorDetails.ONLY_ONE_OF_FIELDS_SHOULD_BE_SPECIFIED_BM,
                                "CPM_BANNER, DYNAMIC, MOBILE_CONTENT, PERFORMANCE, TEXT")))
                        .perl(ExpectedResult.errors(new Notification(5009,
                                Api5ErrorDetails.CAMPAIGN_CAN_CONTAIN_ONLY_ONE_OF_OBJECTS,
                                capitalize(CampaignAddItemMap.CPM_BANNER_CAMPAIGN) + ", " +
                                        capitalize(CampaignAddItemMap.DYNAMIC_TEXT_CAMPAIGN) + ", " +
                                        capitalize(CampaignAddItemMap.MOBILE_APP_CAMPAIGN) + ", " +
                                        capitalize(CampaignAddItemMap.SMART_CAMPAIGN) + ", " +
                                        capitalize(CampaignAddItemMap.TEXT_CAMPAIGN)))));

    }

    @Test
    public void tryAddOneCampaignWithAllTypes() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                .defaultCampaignAddItem()
                                .withDefaultTextCampaign()
                                .withDefaultMobileAppCampaign()
                                .withDefaultDynamicTextCampaign()
                                .withDefaultCpmBannerCampaign()),

                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5009,
                                Api5ErrorDetails.ONLY_ONE_OF_FIELDS_SHOULD_BE_SPECIFIED_BM,
                                "CPM_BANNER, DYNAMIC, MOBILE_CONTENT, PERFORMANCE, TEXT")))
                        .perl(ExpectedResult.errors(new Notification(5009,
                                Api5ErrorDetails.CAMPAIGN_CAN_CONTAIN_ONLY_ONE_OF_OBJECTS,
                                capitalize(CampaignAddItemMap.CPM_BANNER_CAMPAIGN) + ", " +
                                        capitalize(CampaignAddItemMap.DYNAMIC_TEXT_CAMPAIGN) + ", " +
                                        capitalize(CampaignAddItemMap.MOBILE_APP_CAMPAIGN) + ", " +
                                        capitalize(CampaignAddItemMap.SMART_CAMPAIGN) + ", " +
                                        capitalize(CampaignAddItemMap.TEXT_CAMPAIGN)))));
    }
}
