package ru.yandex.autotests.direct.api.campaigns.add;

import java.util.Arrays;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 21.08.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка ограничений на количество кампаний")
@Issue("https://st.yandex-team.ru/DIRECT-34567")
public class AmountOfCampaignsRestrictionTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    //Успешный вызов с максимумом - в юнит-тестах

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("15")
    public void addOneCampaign() {
        CampaignAddItemMap[] campaignAddItemMaps =
                new CampaignAddItemMap[AddRequestMap.MAX_AMOUNT_OF_CAMPAIGNS_IN_REQUEST + 1];
        Arrays.fill(campaignAddItemMaps, new CampaignAddItemMap().defaultCampaignAddItem().withDefaultTextCampaign());
        api.userSteps.campaignSteps().expectErrorOnCampaignsAddIgnoringDetails(new AddRequestMap()
                        .withCampaigns(campaignAddItemMaps),
                new Api5Error(9300,
                        Api5ErrorDetails.ADD_NO_MORE_THAN_CAMPAIGNS, AddRequestMap.MAX_AMOUNT_OF_CAMPAIGNS_IN_REQUEST));
    }
}
