package ru.yandex.autotests.direct.api.campaigns.add;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import org.joda.time.DateTime;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.UsersRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 21.08.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка заполнения ClientInfo и Email данными из таблицы users, если поля не указаны в Campaigns.add")
@Issue("https://st.yandex-team.ru/DIRECT-45122")
@Tag(TagDictionary.TRUNK)
public class AutocompleteClientInfoAndEmailTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);
    private static DirectJooqDbSteps jooqDbSteps;

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static UsersRecord users;
    private static CampaignGetItem campaignGetItem;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        Long id = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .withName(CampaignAddItemMap.DEFAULT_NAME)
                .withStartDate(DateTime.now().toString("yyyy-MM-dd"))
                .withTextCampaign(new TextCampaignAddItemMap()
                        .withBiddingStrategy(new TextCampaignStrategyAddMap().defaultTextCampaignStrategy())));
        campaignGetItem =
                api.userSteps.campaignSteps()
                        .campaignsGet(id, CampaignFieldEnum.CLIENT_INFO, CampaignFieldEnum.NOTIFICATION);

        jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT);
        users = jooqDbSteps.usersSteps().getUser(CLIENT);
        assumeThat("из таблицы users получена информация о клиенте", users, notNullValue());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("16")
    public void checkClientInfo() {
        assertThat("кампания создалась с правильным ClientInfo", campaignGetItem.getClientInfo(),
                equalTo(users.getFio()));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("17")
    public void checkFEmail() {
        assertThat("кампания создалась с правильным email",
                campaignGetItem.getNotification().getEmailSettings().getEmail(), equalTo(users.getEmail()));
    }
}
