package ru.yandex.autotests.direct.api.campaigns.add;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignBaseMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static ru.yandex.autotests.directapi.apiclient.errors.Path.path;

/**
 * Created by pavryabov on 04.09.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка валидации поля BlockedIps. Негативные сценарии")
@Issue("https://st.yandex-team.ru/DIRECT-34567")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class BlockedIpsValidationNegativeTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter()
    public String description;

    @Parameterized.Parameter(1)
    public String[] blockedIps;

    @Parameterized.Parameter(2)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Collection testData() {
        List<String> overLengthBlockedIps = new ArrayList<>();
        for (int i = 0; i <= CampaignAddItemMap.MAX_AMOUNT_OF_BLOCKED_IPS; i++) {
            overLengthBlockedIps.add(CampaignBaseMap.generateRandomNotPrivateIp());
        }
        String someString = "someString";
        String invalidFormat = "8.8.8";
        String localhost = "127.0.0.1";
        String privateSubnetwork = "192.168.0.1";
        Object[][] data = new Object[][]{
                {"пустая строка", new String[]{""},

                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errorsIgnoringDetails(new Notification(5004,
                                        Api5ErrorDetailsJava.INVALID_VALUE_PATH_AND_VALUE,
                                        path(capitalize(CampaignAddItemMap.BLOCKED_IPS), 0).toString(), "")))
                                .perl(ExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.ELEMENT_OF_ARRAY_CANT_BE_EMPTY_STRING,
                                capitalize(CampaignAddItemMap.BLOCKED_IPS))))},

                {"пробел", new String[]{" "},

                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errorsIgnoringDetails(new Notification(5004,
                                        Api5ErrorDetailsJava.INVALID_VALUE_PATH_AND_VALUE,
                                        path(capitalize(CampaignAddItemMap.BLOCKED_IPS), 0).toString(), " ")))
                                .perl(ExpectedResult.errors(new Notification(5005,
                                Api5ErrorDetails.ELEMENT_OF_ARRAY_CANT_BE_EMPTY_STRING,
                                capitalize(CampaignAddItemMap.BLOCKED_IPS))))},

                {"строка", new String[]{someString},

                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errorsIgnoringDetails(new Notification(5004,
                                        Api5ErrorDetailsJava.INVALID_VALUE_PATH_AND_VALUE,
                                        path(capitalize(CampaignAddItemMap.BLOCKED_IPS), 0).toString(), someString)))
                                .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.WRONG_IP_ADDRESS_FORMAT,
                                someString)))},

                {"повторяющееся значение", new String[]{"8.8.8.8", "8.8.8.8"},

                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errorsIgnoringDetails(new Notification(9802,
                                        Api5ErrorDetailsJava.ELEMENT_PRESENT_IN_LIST_MORE_THAN_ONE_TIME_WITHOUT_LIST,
                                        "8.8.8.8")))
                                .perl(ExpectedResult.errors(new Notification(9802,
                                Api5ErrorDetails.ELEMENT_PRESENT_IN_LIST_MORE_THAN_ONE_TIME,
                                "8.8.8.8", capitalize(CampaignAddItemMap.BLOCKED_IPS))))},

                {invalidFormat, new String[]{invalidFormat},

                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errorsIgnoringDetails(new Notification(5004,
                                        Api5ErrorDetailsJava.INVALID_VALUE_PATH_AND_VALUE,
                                        path(capitalize(CampaignAddItemMap.BLOCKED_IPS), 0).toString(), invalidFormat)))
                                .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.WRONG_IP_ADDRESS_FORMAT,
                                invalidFormat)))},

                {localhost, new String[]{localhost},

                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errorsIgnoringDetails(new Notification(5006,
                                        Api5ErrorDetailsJava.INVALID_VALUE_PATH_AND_VALUE,
                                        path(capitalize(CampaignAddItemMap.BLOCKED_IPS), 0).toString(), localhost)))
                                .perl(ExpectedResult.errors(new Notification(5006,
                                Api5ErrorDetails.YOU_CANNOT_BLOCK_PRIVATE_SUBNETWORK_IPS,
                                localhost)))},

                {privateSubnetwork, new String[]{privateSubnetwork},

                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errorsIgnoringDetails(new Notification(5006,
                                        Api5ErrorDetailsJava.INVALID_VALUE_PATH_AND_VALUE,
                                        path(capitalize(CampaignAddItemMap.BLOCKED_IPS), 0).toString(),
                                        privateSubnetwork)))
                                .perl(ExpectedResult.errors(new Notification(5006,
                                Api5ErrorDetails.YOU_CANNOT_BLOCK_PRIVATE_SUBNETWORK_IPS,
                                privateSubnetwork)))},

                {"Количество элементов, превышающее максимальную длину", overLengthBlockedIps.toArray(new String[]{}),

                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errorsIgnoringDetails(new Notification(7001,
                                        Api5ErrorDetailsJava.SIZE_CANNOT_BE_MORE_THAN_MAX,
                                        capitalize(CampaignAddItemMap.BLOCKED_IPS),
                                        CampaignAddItemMap.MAX_AMOUNT_OF_BLOCKED_IPS)))
                                .perl(ExpectedResult.errors(new Notification(7001,
                                Api5ErrorDetails.MAXIMUM_NUMBER_OF_BLOCKED_IPS_EXCEEDED,
                                CampaignAddItemMap.MAX_AMOUNT_OF_BLOCKED_IPS)))}

//                {invalidFormat + ',' + localhost, new String[]{invalidFormat, localhost},
//                        ExpectedResult.errors(
//                                new Notification(4000, Api5ErrorDetails.WRONG_IP_ADDRESS_FORMAT, invalidFormat))},
//                                DIRECT-46538
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("18")
    public void addWithBlockedIps() {
        //DIRECT-45935
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                .defaultCampaignAddItem().withBlockedIps(blockedIps)
                                .withDefaultTextCampaign()
                        ),
                expectedResult);
    }
}
