package ru.yandex.autotests.direct.api.campaigns.add;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.AddResponse;
import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignBaseMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.Matchers.containsInAnyOrder;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 04.09.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка валидации поля BlockedIps. Позитивные сценарии")
@Issue("https://st.yandex-team.ru/DIRECT-34567")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class BlockedIpsValidationPositiveTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String[] blockedIps;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        List<String> maxLengthBlockedIps = new ArrayList<String>();
        for (int i = 0; i < CampaignAddItemMap.MAX_AMOUNT_OF_BLOCKED_IPS; i++) {
            maxLengthBlockedIps.add(CampaignBaseMap.generateRandomNotPrivateIp());
        }
        return Arrays.asList(new Object[][]{
                {"8.8.8.8", new String[]{"8.8.8.8"}},
                {"Максимальное количество элементов", maxLengthBlockedIps.toArray(new String[]{})},
        });
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("19")
    public void addWithBlockedIpsAndCheckSave() {
        //DIRECT-45935
        AddResponse addResponse = api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                .defaultCampaignAddItem().withBlockedIps(blockedIps)
                                .withDefaultTextCampaign()
                        ),
                ExpectedResult.success());
        Long id = addResponse.getAddResults().get(0).getId();
        CampaignGetItem campaignGetItem =
                api.userSteps.campaignSteps().campaignsGet(id, CampaignFieldEnum.BLOCKED_IPS);

        assertThat("поле BlockedIps сохранилось верно",
                campaignGetItem.getBlockedIps().getValue().getItems(),
                containsInAnyOrder(blockedIps));
    }
}
