package ru.yandex.autotests.direct.api.campaigns.add;

import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingAddMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by pavryabov on 08.10.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка SOAP")
@Tag(TagDictionary.TRUNK)
@Issue("https://st.yandex-team.ru/DIRECT-34567")
public class CampaignsAddSOAPTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT).protocol(ProtocolType.SOAP);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final String ADD_REQUEST = "AddRequest";

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("21")
    public void addOneCampaign() {
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                .defaultCampaignAddItem()
                                .withDefaultTextCampaign()
                        ),
                ExpectedResult.success());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("20")
    public void emptyRequest() {
        api.userSteps.campaignSteps().expectErrorOnCampaignsAdd(
                new AddRequestMap(),
                new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD, ADD_REQUEST,
                        capitalize(AddRequestMap.CAMPAIGNS)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("22")
    public void campaignWithoutName() {
        api.userSteps.campaignSteps().expectErrorOnCampaignsAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withName(null)
                        .withDefaultTextCampaign()),
                new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                        capitalize(AddRequestMap.CAMPAIGNS),
                        capitalize(CampaignAddItemMap.NAME)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("23")
    public void campaignsWithoutStartDate() {
        api.userSteps.campaignSteps().expectErrorOnCampaignsAdd(
                new AddRequestMap().withCampaigns(new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withStartDate(null)
                        .withDefaultTextCampaign()),
                new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                        capitalize(AddRequestMap.CAMPAIGNS),
                        capitalize(CampaignAddItemMap.START_DATE)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("24")
    public void checkTimeTargetingValidation() {
        ////DIRECT-47205
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap()
                        .withCampaigns(new CampaignAddItemMap()
                                .defaultCampaignAddItem()
                                .withDefaultTextCampaign()
                                .withTimeTargeting(new TimeTargetingAddMap()
                                        .withConsiderWorkingWeekends(YesNoEnum.NO)
                                        .withHolidaysSchedule(null))
                        ),
                ExpectedResult.success());
    }
}
