package ru.yandex.autotests.direct.api.campaigns.add;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 12.09.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка правильности списания баллов")
@Issue("https://st.yandex-team.ru/DIRECT-34567")
public class CampaignsAddUnitsTest {

    private static final String client = CampaignsLogins.CLIENT_UNITS_ADD;

    private static final int CALL_COST = 10;
    private static final int CAMPAIGN_COST = 5;
    private static final int DEFAULT_ERROR_COST = 20;
    private static final int COMMON_REQUEST_ERROR = 50;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("30")
    public void addOneCampaign() {
        //DIRECT-46263
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.campaignSteps().campaignsAdd(new AddRequestMap().withCampaigns(
                new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withDefaultTextCampaign()));
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(CALL_COST + CAMPAIGN_COST));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("31")
    public void addTwoCampaigns() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.campaignSteps().campaignsAdd(new AddRequestMap().withCampaigns(
                new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withDefaultTextCampaign(),
                new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withDefaultTextCampaign()));
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(CALL_COST + 2 * CAMPAIGN_COST));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("25")
    public void addOneCampaignWithError() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap().withCampaigns(
                new CampaignAddItemMap()
                        .defaultCampaignAddItem().withStartDate("invalidDate")
                        .withDefaultTextCampaign()),
                ExpectedResult.errorsIgnoringDetails(new Notification(5004,
                        Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE))
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(CALL_COST + DEFAULT_ERROR_COST));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("26")
    public void addTwoCampaignsWithOneError() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap().withCampaigns(
                new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withDefaultTextCampaign(),
                new CampaignAddItemMap()
                        .defaultCampaignAddItem().withStartDate("invalidDate")
                        .withDefaultTextCampaign()),
                ExpectedResult.success(),
                ExpectedResult.errorsIgnoringDetails(new Notification(5004,
                        Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE))
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(CALL_COST + DEFAULT_ERROR_COST + CAMPAIGN_COST));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("27")
    public void addTwoCampaignsWithTwoErrors() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.campaignSteps().shouldGetResultOnAdd(new AddRequestMap().withCampaigns(
                new CampaignAddItemMap()
                        .defaultCampaignAddItem().withStartDate("invalidDate")
                        .withDefaultTextCampaign(),
                new CampaignAddItemMap()
                        .defaultCampaignAddItem().withStartDate("invalidDate")
                        .withDefaultTextCampaign()),
                ExpectedResult.errorsIgnoringDetails(new Notification(5004,
                        Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE)),
                ExpectedResult.errorsIgnoringDetails(new Notification(5004,
                        Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE))
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(CALL_COST + 2 * DEFAULT_ERROR_COST));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("28")
    public void addWithInvalidRequest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.campaignSteps().expectErrorOnCampaignsAdd(new AddRequestMap().withCampaigns(
                new CampaignAddItemMap()
                        .defaultCampaignAddItem().withStartDate(null)
                        .withDefaultTextCampaign()),
                new Api5Error(8000, Api5ErrorDetails.IN_ELEMENT_OF_ARRAY_MISSING_REQUIRED_FIELD,
                        capitalize(AddRequestMap.CAMPAIGNS),
                        capitalize(CampaignAddItemMap.START_DATE)));
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(COMMON_REQUEST_ERROR));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("29")
    public void callCampaignsAddWithZeroUnits() {
        int units = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.clientFakeSteps().fakeWithdrawClientUnits(client, units);
        units = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assumeThat("у клиента не осталось баллов", units, equalTo(0));
        api.userSteps.campaignSteps().expectErrorOnCampaignsAdd(new AddRequestMap().withCampaigns(
                new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withDefaultTextCampaign()),
                new Api5Error(152, Api5ErrorDetails.NOT_ENOUGH_UNITS_FOR_OPERATION)
        );
    }
}
