package ru.yandex.autotests.direct.api.campaigns.add;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsCurrency;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 03.09.15.
 * https://st.yandex-team.ru/TESTIRT-6546
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка валюты кампании")
@Issue("https://st.yandex-team.ru/DIRECT-34567")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class CheckCurrencyAfterCreateTest {

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String login;

    @Parameterized.Parameter(1)
    public CampaignsCurrency currency;

    @Parameterized.Parameters(name = "Login = {0}, Currency = {1}")
    public static Collection data() {
        Object[][] data = new Object[][]{
                {Logins.LOGIN_FOR_RUB, CampaignsCurrency.RUB},
                {Logins.LOGIN_FOR_USD, CampaignsCurrency.USD},
                {Logins.LOGIN_FOR_UAH, CampaignsCurrency.UAH},
                {Logins.LOGIN_FOR_EUR, CampaignsCurrency.EUR},
                {Logins.LOGIN_FOR_KZT, CampaignsCurrency.KZT},
                {Logins.LOGIN_FOR_CHF, CampaignsCurrency.CHF},
                {Logins.LOGIN_FOR_TRY, CampaignsCurrency.TRY},
                {Logins.CLIENT_BYN, CampaignsCurrency.BYN}
        };
        return Arrays.asList(data);
    }

    private Long id;

    @Before
    public void prepareData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(login);
        id = api.as(login).userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withDefaultTextCampaign());
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("33")
    public void checkCurrency() {
        int shard = api.userSteps.clientFakeSteps().getUserShard(login);
        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        CampaignsRecord campaignRecord = jooqDbSteps.campaignsSteps().getCampaignById(id);

        assumeThat("из таблицы campaigns получена информация о кампании", campaignRecord, notNullValue());
        assertThat("кампания создалась с правильной валютой", campaignRecord.getCurrency(), equalTo(currency));
    }
}
