package ru.yandex.autotests.direct.api.campaigns.add;

import java.util.Arrays;
import java.util.Collection;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45mng.Account;
import ru.yandex.autotests.directapi.common.api45mng.CreateNewSubclientResponse;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.CampaignFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.enums.CampaignType;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.notNullValue;
import static org.junit.Assert.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 23.10.15.
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Создание текстовых кампаний")
@Issue("https://st.yandex-team.ru/DIRECT-47025")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class CheckSharedAccountAfterCreatingCampaignTest {

    public static String agencyLogin = Logins.AGENCY_ENABLE_SHARED_ACCOUNT;
    public static String managerLogin = Logins.MANAGER_GEO;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).wsdl(APIPort_PortType.class).as(agencyLogin);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public CampaignType type;

    @Parameterized.Parameters(name = "campaignType = {0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {CampaignType.TEXT},
                {CampaignType.MOBILE_CONTENT},
                {CampaignType.DYNAMIC},
                {CampaignType.CPM_BANNER}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void sharedAccountFlagOn() {
        api.userSteps.clientFakeSteps().enableAgencyWallet(agencyLogin);
        api.userSteps.clientFakeSteps().enableToCreateSubClients(agencyLogin);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(agencyLogin);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(managerLogin);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("34")
    public void newSubclientCampaign() {
        api.as(agencyLogin);
        CreateNewSubclientResponse subClient = api.userSteps.clientSteps()
                .createNewAgencySubClient("create", agencyLogin, Currency.RUB);
        api.userSteps.campaignSteps().addDefaultCampaign(subClient.getLogin(), type);
        Account account = api.userSteps.financeSteps().getAccount(subClient.getLogin());
        assumeThat("вернулась информация по ОС", account, notNullValue());
        assertThat(account.getLogin(), equalTo(subClient.getLogin().toLowerCase()));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("35")
    public void newServicedClientCampaign() {
        api.as(managerLogin);
        CreateNewSubclientResponse subClient =
                api.userSteps.clientSteps().createNewServicedSubClient("subClient", managerLogin, Currency.RUB);
        api.userSteps.campaignSteps().addDefaultCampaign(subClient.getLogin(), type);
        Account account = api.userSteps.financeSteps().getAccount(subClient.getLogin());
        assumeThat("вернулась информация по ОС", account, notNullValue());
        assertThat(account.getLogin(), equalTo(subClient.getLogin().toLowerCase()));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("36")
    public void checkWalletStatusBsSynced() {
        api.as(managerLogin);
        CreateNewSubclientResponse subClient =
                api.userSteps.clientSteps().createNewServicedSubClient("subClient", managerLogin, Currency.RUB);
        api.userSteps.campaignSteps().addDefaultCampaign(subClient.getLogin(), type);
        Account account = api.userSteps.financeSteps().getAccount(subClient.getLogin());
        assumeThat("вернулась информация по ОС", account, notNullValue());
        CampaignFakeInfo campaignFakeInfo =
                api.userSteps.campaignFakeSteps().fakeGetCampaignParams(account.getAccountID());
        assertThat("кошелек не синхронизирован с БК", campaignFakeInfo.getStatusBsSynced(), equalTo(Status.NO));
    }
}
