package ru.yandex.autotests.direct.api.campaigns.add;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.AxisError;
import ru.yandex.autotests.directapi.apiclient.errors.AxisErrorDetails;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45mng.CreateNewSubclientResponse;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 04.12.15.
 * https://st.yandex-team.ru/TESTIRT-7924
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Issue("https://st.yandex-team.ru/DIRECT-49039")
@Description("Если клиент создает первую текстовую кампанию при наличии кампаний других типов, " +
        "ОС не должен подключаться")
public class CheckSharedAccountAfterCreatingFirstTextCampaignText {

    public static final String MANAGER = Logins.MANAGER_GEO;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).wsdl(APIPort_PortType.class).as(MANAGER);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private String subclient;

    @Before
    @Step("Подготовка данных для теста")
    public void createCampaign() {
        CreateNewSubclientResponse createNewSubclientResponse =
                api.userSteps.clientSteps().createServicedClient("subClient", MANAGER);
        subclient = createNewSubclientResponse.getLogin();
        Long mobileAppCampaignId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign(subclient);
        api.userSteps.deleteAccountByLogin(subclient);

        int shard = api.userSteps.clientFakeSteps().getUserShard(subclient);
        DirectJooqDbSteps jooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShard(shard);
        CampaignsRecord campaignRecord = jooqDbSteps.campaignsSteps().getCampaignById(mobileAppCampaignId);
        campaignRecord.setWalletCid(0L);
        jooqDbSteps.campaignsSteps().updateCampaigns(campaignRecord);
        api.userSteps.financeSteps().shouldGetErrorsOnAccountManagementGet(
                subclient,
                new AxisError(515, AxisErrorDetails.EMPTY_STRING));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("37")
    public void createFirstTextCampaign() {
        api.userSteps.campaignSteps().addDefaultTextCampaign(subclient);
        api.userSteps.financeSteps().shouldGetErrorsOnAccountManagementGet(
                subclient,
                new AxisError(515, AxisErrorDetails.EMPTY_STRING));
    }
}
