package ru.yandex.autotests.direct.api.campaigns.add;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.CampaignFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 18.11.15.
 * https://st.yandex-team.ru/TESTIRT-7756
 */
@Aqua.Test
@Features(CampaignsFeatures.ADD)
@Description("Проверка статусов динамической текстовой кампании после создания")
@Issue("https://st.yandex-team.ru/DIRECT-44876")
public class CheckStatusesAfterAddDynamicTextCampaignTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;
    private static final Integer CONTEXT_LIMIT = 0;
    private static final String PLATFORM = "search";

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static int shard;

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long id;
    private static CampaignFakeInfo campaignFakeInfo;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        shard = api.userSteps.clientFakeSteps().getUserShard(CLIENT);
        id = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withDefaultDynamicTextCampaign());
        campaignFakeInfo = api.userSteps.getDarkSideSteps().getCampaignFakeSteps().fakeGetCampaignParams(id);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("38")
    public void checkStatusModerate() {
        assertThat("у созданной кампании StatusModerate = New",
                campaignFakeInfo.getStatusModerate(), equalTo(Status.NEW));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("39")
    public void checkStatusPostModerate() {
        assertThat("у созданной кампании StatusPostModerate = New",
                campaignFakeInfo.getStatusPostModerate(), equalTo(Status.NEW));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("40")
    public void checkStatusShow() {
        assertThat("у созданной кампании StatusShow = Yes",
                campaignFakeInfo.getStatusShow(), equalTo(Status.YES));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("41")
    public void checkStatusActive() {
        assertThat("у созданной кампании StatusActive = No",
                campaignFakeInfo.getStatusActive(), equalTo(Status.NO));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("42")
    public void checkStatusBsSynced() {
        assertThat("у созданной кампании StatusBsSynced = No",
                campaignFakeInfo.getStatusBsSynced(), equalTo(Status.NO));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("43")
    public void checkContextLimitInDB() {
        CampaignsRecord campaigns =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampaignById(id);
        assertThat("кампания создалась с правильным значением ContextLimit", campaigns.getContextlimit(),
                equalTo(CONTEXT_LIMIT));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("43")
    public void checkPlatformInDB() {
        CampaignsRecord campaigns =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampaignById(id);
        assertThat("кампания создалась с правильным значением DontShowYacontext",
                campaigns.getPlatform().toString(),
                equalTo(PLATFORM));
    }
}
